package jp.ac.osaka_u.ist.sel.crossword;

import java.io.IOException;
import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.crossword.board.CrossWordBoardView;
import jp.ac.osaka_u.ist.sel.crossword.board.CrossWordBox;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Point;
import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

public class SelectionActivity extends Activity {

	private final int MENU_ID1 = Menu.FIRST;
	
	private String filename = null;
	private ArrayList<String> fileList = new ArrayList<String>();
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_selection);
		sizeAdjustment();
		createFileSelection();
	}

	private void sizeAdjustment(){
		//[̉ʃTCY̎擾
		Point size = new Point();
		WindowManager wm = (WindowManager)getSystemService(WINDOW_SERVICE);
		Display disp = wm.getDefaultDisplay();
		disp.getSize(size);
			Log.d("width", "width:"+ size.x);
			Log.d("height", "height:"+ size.y);

			float scale = Math.min(size.x, size.y);
			
			TextView title = (TextView)findViewById(R.id.text_selection);
			title.setTextSize(TypedValue.COMPLEX_UNIT_PX, scale / 30);
			Button startButton = (Button)findViewById(R.id.button_start_puzzle);
			startButton.setTextSize(TypedValue.COMPLEX_UNIT_PX, scale / 20);
	}
	
	/**
	 * assets".dat"t@C擾AIpʂ쐬
	 */
	private void createFileSelection() {
		AssetManager assetManager = getResources().getAssets();
		String[] assetsList = null;
	
		try{
			assetsList = assetManager.list("");
		}catch (IOException e) {
			e.printStackTrace();
		}
		
		int dataNumber = 0;
		for (int i=0; i < assetsList.length; i++){
			String str = assetsList[i];
			if (str.endsWith(".dat")){
				Log.d("file Managar", str);
				fileList.add(str);
				add_file(dataNumber,str);
				dataNumber++;
			}
		}

		if(fileList.isEmpty()){
			Log.e("file Managar", ".datt@C܂łB");
		}else{
			RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
			radioGroup.check(0);
		}
	}

	/**
	 * ".dat"t@CɑΉIpʂ쐬
	 */
	private void add_file(int id, String file){
		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
		RadioButton button1 = new RadioButton(this);
		button1.setLayoutParams(new LinearLayout.LayoutParams(
		        ViewGroup.LayoutParams.WRAP_CONTENT,
		        ViewGroup.LayoutParams.WRAP_CONTENT));
		String str = file.substring(0, file.length()-4);
		button1.setText(""+ (id+1) +": "+str);
		button1.setId(id);
		radioGroup.addView(button1);
		
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
	    super.onCreateOptionsMenu(menu);

	    menu.add(0,MENU_ID1,1,"AvI"); 
	    return true;
	}
	
	/**
     * j[{^̏
     */
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        return true;
    }
    
    /**
     * j[Ȉ
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        case MENU_ID1:
            //AvI
        	appli_finish();
            return true;
        default:
            break;
        }
        return super.onOptionsItemSelected(item);
    }

    /**
     * AvI
     */
    private void appli_finish(){
		// _CAO̍쐬
    	AlertDialog.Builder alertDialog=new AlertDialog.Builder(this);
        alertDialog.setTitle("Av̏I̊mF");
        alertDialog.setMessage("AvI܂H");
        alertDialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // OK{^̏
                moveTaskToBack(true);
            }
        });
        alertDialog.setNegativeButton("", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                // NG{^̏
            }
        });
        alertDialog.show();
    }
    
	public void onClick_start_puzzle_button(View v){

		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup1);
		filename = fileList.get(radioGroup.getCheckedRadioButtonId());
		
		// CeggĉʑJ
        Intent intent_start_button = new Intent();
        intent_start_button.setClassName(
        		"jp.ac.osaka_u.ist.sel.crossword",
        		"jp.ac.osaka_u.ist.sel.crossword.PuzzleActivity");
        // putExtragăpỸt@Cn        
        intent_start_button.putExtra("FILENAME", filename);
        startActivity(intent_start_button);
        
	}
	
}
