package jp.ac.osaka_u.ist.sel.crossword.board;

import java.util.ArrayList;
import java.util.Iterator;

import jp.ac.osaka_u.ist.sel.crossword.PuzzleActivity;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;


/**
 *
 * Ֆʃr[
 *
 * @author m-sano
 *
 */
public class CrossWordBoardView extends View {

	// `pBėp邽߂ɍŏ1
	private Paint paint = new Paint();

	// Ֆʃf[^B}X̏W
	private CrossWordBox[][] boardBoxes;

	// ̃}X
	private int countBoxAcross = -1;

	// c̃}X
	private int countBoxDown = -1;

	private int screenSizeX = 0;
	private int screenSizeY = 0;

	// }X̑傫
	// ftHg 20
	private int boxSize = 20;

	private final PuzzleActivity puzzleActivity;
	private AbstractMotionManager motionManager;


	private boolean isGiveup = false;

	/**
	 *
	 * Ֆʃr[𐶐
	 *
	 * @param context eCAEg
	 * @param reader ǂݍQuestionReader
	 *
	 */
	public CrossWordBoardView(PuzzleActivity context, QuestionReader reader) {
		super(context);
		puzzleActivity=context;

		// Ֆʂ̃}X擾
		this.countBoxAcross = reader.getWidthSize();
		this.countBoxDown = reader.getHeightSize();

		// Ֆʗp̔z񐶐
		boardBoxes = new CrossWordBox[countBoxAcross][countBoxDown];

		// g̃CX^X
		for(int i = 0; i < countBoxDown; i++) {
			for(int j = 0; j < countBoxAcross; j++) {
				boardBoxes[i][j] = new CrossWordBox(0 + boxSize * j, 0 + boxSize * i, boxSize);
			}
		}

		// qgԍ̐ݒ
		int[][] hintNumberData = reader.getNumbers();

		// f[^͐Ɖ肵ĂAG[`FbN͂Ă܂B
		for(int i = 0; i < hintNumberData.length; i++) {
			for(int j = 0; j < hintNumberData[i].length; j++) {
				boardBoxes[i][j].setHintNumber(hintNumberData[i][j]);
			}
		}

		// 𕶎̐ݒ
		ArrayList<String> answerWords = reader.getBoardLines();
		Iterator<String> it = answerWords.iterator();
		int index = 0;
		while(it.hasNext()) {
			String line = it.next();
			for(int i = 0; i < line.length(); i++) {
				char c;
				if((c = line.charAt(i)) == '') {
					boardBoxes[index][i].setValid(false);
				} else {
					boardBoxes[index][i].setAnswerWord(c);
				}
			}
			index++;
		}
	}



	/**
	 *
	 * }X̑傫ݒ肷B
	 * CAEgr[̃TCY擾ۂ́A
	 * ANeBreBԂɂȂĂKv̂ŁA
	 * onCreateȂǂŌĂłӖ
	 *
	 * @param width ẻTCY
	 * @param height ȅcTCY
	 */
	public void setBoxSize(int width, int height) {
		boxSize = calcBoxSize(width, height);

		// }Xp̐`Đ
		for(int i = 0; i < countBoxDown; i++) {
			for(int j = 0; j < countBoxAcross; j++) {
				boardBoxes[i][j].set(0 + boxSize * j, 0 + boxSize * i, boxSize);
			}
		}
		this.invalidate();		// r[̍XV

		Log.d("board", "setBoxSize:" + Integer.toString(boxSize));
	}



	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
		super.onMeasure(widthMeasureSpec, heightMeasureSpec);

		// r[̂̃TCYύX
		int sizeX = MeasureSpec.getSize(widthMeasureSpec);
		int sizeY = MeasureSpec.getSize(heightMeasureSpec);
		int viewSize = (sizeX < sizeY) ? sizeX : sizeY;
		setMeasuredDimension(viewSize, viewSize);
	}



	@Override
	protected void onDraw(Canvas canvas) {
        paint.setColor(Color.BLACK);
        paint.setStyle(Style.STROKE);

        // Canvasɕ`
        for(int i = 0; i < countBoxDown; i++) {
			for(int j = 0; j < countBoxAcross; j++) {
				boardBoxes[i][j].draw(canvas, paint);
			}
		}
	}



	// ʂ̌ςȂǂɌĂ΂B
	// NɂĂ΂Ă݂Ȃ̂ŁATCY
	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		screenSizeX = w;
		screenSizeY = h;
		setBoxSize(screenSizeX, screenSizeY);
	}



	/**
	 *
	 * K؂ȃ}X̃TCYvZB
	 * CAEg̏̕ɁÃ}XƂČvZĂ̂ŁA
	 * גՖʂ͂҂TCYɂȂł͂ȂB
	 *
	 * @param parentWidth eCAEg̕
	 * @param parentHeight eCAEg̍
	 *
	 * @return
	 *
	 */
	private int calcBoxSize(int parentWidth, int parentHeight) {
		int parentMinSize = (parentWidth > parentHeight) ? parentHeight:parentWidth;
		int boxMaxNum = (countBoxAcross > countBoxDown) ? countBoxDown:countBoxAcross;

		return (parentMinSize / boxMaxNum);
	}



	/**
	 *
	 * }Xɕݒ肵܂
	 * }X}XA͈͊Oꍇ͉ȂB
	 *
	 * @param i sڂ̃}X
	 * @param j ڂ̃}X
	 * @param word 镶
	 *
	 */
	public void setCurrentWord(int i, int j, char word) {

		if(i < 0 || boardBoxes.length <= i || j < 0 || boardBoxes[i].length <= j) {
			Log.e("board", "CrossWordBoardView.setCurrentWord: sȃ}Xw肳܂B");
			return;
		}

		if(!boardBoxes[i][j].isValid()) {
			Log.e("board", "CrossWordBoardView.setCurrentWord: w肵}X͖}XłB");
			return;
		}

		this.boardBoxes[i][j].setCurrentWord(word);
		this.invalidate();
	}


	/**
	 *
	 * }Xɕݒ肵܂B
	 * w蕶񂪒ꍇȂǁA}Xɓ鎖oȂ
	 * falseԂ܂B
	 *
	 * @param hintNum qgԍ
	 * @param orient KeyWordData̕萔
	 * @param keyword 錾t
	 *
	 */
	public boolean setCurrentWord(int hintNum, int orient, String keyword) {
		ArrayList<CrossWordBox> boxArray = getBoxForKeyword(hintNum, orient);

		// L[[h
		if(boxArray.size() < keyword.length()) {
			Log.e("board", "CrossWordBoardView.setCurrentWord: L[[h܂B");
			return false;
		}

		// e}Xɕ
		for(int i = 0; i < boxArray.size(); i++) {
			boxArray.get(i).setCurrentWord(keyword.charAt(i));
		}
		this.invalidate();
		return true;
	}



	/**
	 *
	 * }Xɕݒ肵܂B
	 * w蕶񂪒ꍇȂǁA}Xɓ鎖oȂ
	 * _CAOŃ[UɊmF܂B
	 *
	 * ͂sꍇ trueA
	 * ㏑ꍇ false
	 *
	 * ۂɏ㏑s
	 * _CAO\͐ił܂߁A
	 * _CAǑʂ󂯂ĉƂ
	 *
	 * @param hintNum qgԍ
	 * @param orient KeyWordData̕萔
	 * @param keyword 錾t
	 * @param parent eANeBreBB_CAOpB
	 *
	 */
	public boolean setCurrentWord(int hintNum, int orient, String keyword, Activity parent) {
		ArrayList<CrossWordBox> boxArray = getBoxForKeyword(hintNum, orient);

		// L[[h
		if(boxArray.size() < keyword.length()) {
			Log.e("board", "CrossWordBoardView.setCurrentWord: L[[h܂B");
			System.err.println(keyword);
			return false;
		}

		// `FbN
		for(int i = 0; i < keyword.length(); i++) {
			char c = boxArray.get(i).getCurrentWord();

			// ͍ςA͕ƈقȂ
			if(c != ' ' && c != keyword.charAt(i)) {
				Log.i("board", "ɓ͍ς̕ƋĂ܂B");

				// _CAO
				AlertDialog.Builder dialog = new AlertDialog.Builder(parent);	// mF_CAO
				dialog.setTitle("㏑̊mF");
				dialog.setMessage("㏑镶݂܂B͂Ă낵łH");

				// YES{^
				dialog.setPositiveButton("͂", new DialogInterface.OnClickListener() {
					ArrayList<CrossWordBox> boxArray;
					CrossWordBoardView boardView;
					String keyword;

					// NXɊOϐn߂setter
					public DialogInterface.OnClickListener set(ArrayList<CrossWordBox> array, CrossWordBoardView view, String key) {
						this.boxArray = array;
						this.boardView = view;
						this.keyword = key;

						return this;
					}

					@Override
					public void onClick(DialogInterface dialog, int which) {
						// e}Xɕ
						for(int i = 0; i < this.keyword.length(); i++) {
							this.boxArray.get(i).setCurrentWord(keyword.charAt(i));
						}
						this.boardView.invalidate();

						this.boardView.checkAnswer();
					}
				}.set(boxArray, this, keyword));

				// NO{^
				dialog.setNegativeButton("", null);

				dialog.show();

				return false;
			}
		}

		// ㏑Ȃ
		// e}Xɕ
		for(int i = 0; i < keyword.length(); i++) {
			boxArray.get(i).setCurrentWord(keyword.charAt(i));
		}
		this.invalidate();

		// mF
		this.checkAnswer();

		return true;
	}




	/**
	 *
	 * qgԍƕÃqg̃JM̂߂̓̓}X
	 * zƂĕԂ܂B
	 * 肪ƁAnull Ԃ܂B
	 *
	 * @param hintNum qgԍ
	 * @param orient KeyWordData̕萔
	 *
	 * @return ͂}Xz
	 *
	 */
	private ArrayList<CrossWordBox> getBoxForKeyword(int hintNum, int orient) {

		ArrayList<CrossWordBox> boxArray = new ArrayList<CrossWordBox>();

		// 擪}X̑{
		int[] topBoxIndex = this.getBoxIndexFromHintNumber(hintNum);

		// Tׂqg̃}X
		if(topBoxIndex == null) {
			Log.e("board", "CrossWordBoardView.getBoxForKeyword: w肵qg͂}X݂͑܂B");
			return null;
		}

		int line = topBoxIndex[0];
		int column = topBoxIndex[1];

		// ^ẽJM
		if(orient == KeywordData.ORIENT_HEIGHT) {
			// [ɒH蒅A}Xł΂őł؂
			while((line < boardBoxes.length) && boardBoxes[line][column].isValid()) {
				boxArray.add(boardBoxes[line][column]);
				line++;
			}
		} else {
			// ̃JM
			while((column < boardBoxes[line].length) && boardBoxes[line][column].isValid()) {
				boxArray.add(boardBoxes[line][column]);
				column++;
			}
		}
		return boxArray;
	}



	/**
	 *
	 * qgԍƓԍ}XTA
	 * ̃CfbNXԂ܂B
	 * ꍇ null Ԃ܂B
	 *
	 * @param hintNum qgԍ
	 *
	 * @return }X̃CfbNXBvf2̔z[0]sA[1]
	 *
	 */
	private int[] getBoxIndexFromHintNumber(int hintNum) {
		int[] index = new int[2];

		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {
				if(boardBoxes[i][j].getHintNumber() == hintNum) {
					index[0] = i;
					index[1] = j;
					return index;
				}
			}
		}
		return null;
	}



	/**
	 *
	 * }Xɕ폜܂B
	 *
	 * 1}X폜ƔĂ̂ŃRgAEgB
	 * Ö׃R[h͒uƂ܂AsvȂ폜ĂB
	 *
	 * @param hintNum qgԍ
	 * @param orient KeyWordData̕萔
	 *
	 */
	/*public boolean clearCurrentWord(int hintNum, int orient) {
		ArrayList<CrossWordBox> boxArray = getBoxForKeyword(hintNum, orient);

		// e}X̕
		for(int i = 0; i < boxArray.size(); i++) {
			boxArray.get(i).clearCurrentWord();
		}
		this.invalidate();
		return true;
	}*/



	/**
	 *
	 * }X̕폜܂B
	 *
	 * @param i }Xsڂ
	 * @param j }Xڂ
	 * @return
	 *
	 */
	public void clearCurrentWord(int i, int j) {

		// }X̕
		if(0 <= i && i < boardBoxes.length && 0 <= j && j < boardBoxes[i].length) {
			boardBoxes[i][j].clearCurrentWord();
			this.invalidate();
		}
	}



	/**
	 *
	 * `FbNtOݒ肷B
	 *
	 * @param flag trueȂ琳`FbNsB
	 *
	 */
	public void setCheckFlag(boolean flag) {
		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {
				boardBoxes[i][j].setCheckFlag(flag);
			}
		}
		this.invalidate();
	}



	/**
	 *
	 * 𓚕\tOݒ肷B
	 *
	 * MuAbvtO͂ŗĂ邱ƂɂB
	 *
	 * @param flag trueȂ𓚕\
	 *
	 */
	public void setShowAnswer(boolean flag) {
		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {
				boardBoxes[i][j].setIsShowAnswer(flag);
			}
		}
		this.isGiveup = flag;
		this.invalidate();
	}



	/**
	 *
	 * w}X̑IԂݒ
	 *
	 * @param flag trueȂI
	 *
	 */
	public void setSelectBox(int m, int n, boolean flag) {

		if(m < 0 || m >= boardBoxes.length || n < 0 || n >= boardBoxes[m].length) {
			return;
		}

		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[m].length; j++) {
				boardBoxes[m][n].setIsSelect(flag);
			}
		}
		this.invalidate();
	}



	/**
	 *
	 * SĂ̑I
	 *
	 */
	public void unselectBox() {
		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {
				boardBoxes[i][j].setIsSelect(false);
			}
		}
		this.invalidate();
	}



	/**
	 *
	 * ̐Fς
	 *
	 */
	public void changeRightColor() {
		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {
				boardBoxes[i][j].setRightAnswerFlag(true);
			}
		}
		this.invalidate();
	}



	/**
	 * Ֆʂ^b`ꂽƂ̓
	 */
	public boolean onTouchEvent(MotionEvent event){
		//^b`Wƃ}XboardBoxes[x][y]Ή
		int x = (int) (event.getX() / boxSize);
		int y = (int) (event.getY() / boxSize);
		Log.d("TouchEvent", "X:" + x + ",Y:" + y);

		//^b`܂ܓƔՖʊOɏo\
		if (!isOnBoard(x,y)){
			Log.e("board", "CrossWordBoardView.onTouchEvent: ^b`W͔ՊOłB");
		}

		switch (event.getAction()) {
        	case MotionEvent.ACTION_DOWN:    //^b`
        		Log.d("TouchEvent", "getAction()" + "ACTION_DOWN");
        		motionManager=puzzleActivity.delete_button_isChecked()?new DeleteMotionManager(puzzleActivity, event, y, x):new InputMotionManager(puzzleActivity, event, y, x);
        		break;
        	case MotionEvent.ACTION_MOVE:    //^b`܂ܓ
        		Log.d("TouchEvent", "getAction()" + "ACTION_MOVE");
        		motionManager.onMove(event,y, x);
        		break;
        	case MotionEvent.ACTION_UP:        //w𗣂
        		Log.d("TouchEvent", "getAction()" + "ACTION_UP");
        		motionManager.onUp(y, x);
        		motionManager=null;
        		break;
		}

		return true;
    }

	/**
	 * }X̍W(x,y)Ֆʓɂtrue
	 */
	public boolean isOnBoard(int x, int y){
		if ((x<0)||(x>countBoxAcross-1)||(y<0)||(y>countBoxDown-1)){
			return false;
		}
		return true;
	}

	/**
	 * 폜{^ON/OFF̏Ԃ擾ē𕪂
	 * onTouchEvent()ĂяoƂz
	 * ̃\bhsvȂ΁A폜Ăč\܂
	 */
	public void edit(){

		//폜{^ONȂtrueAOFFȂfalse
		boolean delete_mode = puzzleActivity.delete_button_isChecked();
		if (delete_mode){
			//폜[h
    		Log.d("Edit", "delete_mode");
		}else{
			//̓[h
    		Log.d("Edit", "input_mode");
		}

	}



	/**
	 *
	 * 𓚂ׂB
	 *
	 * ԈႢA󔒃}XƉȂB
	 *
	 * SĐ̏ꍇ̂݁Ał邱ƂʒmB
	 *
	 */
	public void checkAnswer() {
		for(int i = 0; i < boardBoxes.length; i++) {
			for(int j = 0; j < boardBoxes[i].length; j++) {

				// s̃}XΏI
				if(!boardBoxes[i][j].isRight())	return;
			}
		}

		this.changeRightColor();
		Toast.makeText(this.getContext(), "I", Toast.LENGTH_LONG).show();
	}



	public char[][] getCurrentWordForSave() {
		char[][] currentWords = new char[countBoxDown][countBoxAcross];
		for(int i = 0; i < countBoxDown; i++) {
			for(int j = 0; j < countBoxAcross; j++) {
				currentWords[i][j] = boardBoxes[i][j].getCurrentWord();
			}
		}
		return currentWords;
	}



	public boolean getIsGiveUpForSave() {
		return isGiveup;
	}



	public void setCurrentWordForRestore(char[][] currentWords, boolean isGiveUp) {
		for(int i = 0; i < currentWords.length; i++) {
			for(int j = 0; j < currentWords[i].length; j++) {
				boardBoxes[i][j].setCurrentWord(currentWords[i][j]);
				boardBoxes[i][j].setCheckFlag(isGiveUp);
				boardBoxes[i][j].setIsShowAnswer(isGiveUp);
				this.isGiveup = isGiveUp;
			}
		}
		this.invalidate();
	}
}
