package jp.ac.osaka_u.ist.sel.crossword.board;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Align;
import android.graphics.Paint.Style;
import android.graphics.RectF;
import android.util.Log;


/**
 *
 * Ֆʂ̃}X
 * \WȂǂ RectF ɕWڂĂ͂B
 *
 * @author m-sano
 *
 */
public class CrossWordBox extends RectF {

	// }X̑傫
	private float boxSize = 20.0f;

	// ̃}Xɓ鐳̕
	private char answerWord = ' ';

	// Ã}XɓĂ镶
	private char currentWord = ' ';

	// }Xi}XjۂB}XȂ false
	private boolean isValid = true;

	// qgԍ
	// qgԍ\}XłꍇÃqgԍݒ肷
	// ꍇ -1 ݒ肷B
	private int hintNumber = -1;

	// `FbNtOBtrueŃ~Xӏ킩B
	private boolean checkFlag = false;

	// 𓚂\Ȃ true
	private boolean isShowAnswer = false;

	// I
	private boolean isSelect = false;

	// ̐Fς
	private boolean rightAnswerFlag = false;



	/**
	 *
	 * }X̕\Ww肵āA}X𐶐B
	 *
	 * @param left [
	 * @param top [
	 * @param size }X̃TCY
	 *
	 */
	public CrossWordBox(float left, float top, float size) {
		super(left, top, left + size, top + size);

		this.boxSize = size;
	}



	/**
	 *
	 * }X̍WĐݒ
	 *
	 * @param left [
	 * @param top [
	 * @param size }X̃TCY
	 *
	 */
	public void set(float left, float top, float size) {
		this.set(left, top, left + size, top + size);
		this.boxSize = size;
	}



	/**
	 *
	 * ƂȂ镶擾
	 * ݒȂ甼pXy[X ' ' Ԃ͂
	 *
	 * @return ƂȂ镶
	 *
	 */
	public char getAnswerWord() {
		return this.answerWord;
	}



	/**
	 *
	 * ݕ\Ă镶擾
	 * ݒȂ甼pXy[X ' ' Ԃ͂
	 *
	 * @return
	 *
	 */
	public char getCurrentWord() {
		return this.currentWord;
	}



	/**
	 *
	 * L}Xׂ
	 *
	 * @return L}XȂ trueAȂ false
	 *
	 */
	public boolean isValid() {
		return this.isValid;
	}



	/**
	 *
	 * ̕ݒ肷B
	 * J^JiȊO͖B
	 * ''  'b' ͑啶ɕϊB
	 *
	 * @param word ̕iJ^Jij
	 *
	 */
	public void setAnswerWord(char word) {

		if(!this.isHiragana(word)) {
			Log.e("board", "CrossWordBox.setAnswerWord: J^Jił͂܂B͖܂B");
		}
		this.answerWord = this.covertKanaSmallToLarge(word);
	}



	/**
	 *
	 * J^Jiׂ
	 *
	 * Unicode ł̕сiJ^Jij
	 *
	 * 
	 * ÂĂłƂǂȂɂʂ˂̂͂΂ςЂт҂ӂԂՂւׂ؂قڂ
	 * ܂݂ނ߂
	 *
	 * {L "["
	 *
	 * @param word Ώە
	 *
	 * @return J^JiȂ true
	 *
	 */
	private boolean isHiragana(char word) {
		if((word >= '@' && word <= '') || word == '[') {
			return true;
		}
		return false;
	}



	/**
	 *
	 * ̃J^Jił΁A啶ɒĂԂB
	 * ȊO͂̂܂
	 *
	 * @param word Ώە
	 *
	 * @return ̃J^Ji啶ɒ
	 *
	 */
	private char covertKanaSmallToLarge(char word) {
		char newWord = word;
		if(word == '@' || word == 'B' || word == 'D' || word == 'F' || word == 'H'
				|| word == 'b' || word == '' || word == '' || word == '') {
			newWord++;
		}
		return newWord;
	}



	/**
	 *
	 * ݕ\̕ݒ肷B
	 * J^JiȊO͖B
	 * ''  'b' ͑啶ɕϊB
	 *
	 * @param word \镶iЂ炪ȁj
	 *
	 */
	public void setCurrentWord(char word) {
		if(!this.isHiragana(word)) {
			Log.e("board", "CrossWordBox.setCurrentWord: J^Jił͂܂B͖܂B");
		}
		this.currentWord = this.covertKanaSmallToLarge(word);
	}



	/**
	 *
	 * ݕ\̕폜
	 *
	 */
	public void clearCurrentWord() {
		this.currentWord = ' ';
	}



	/**
	 *
	 * }X̗LAݒ肷B
	 *
	 * @param valid LȂ trueAȂfalseݒ肷
	 *
	 */
	public void setValid(boolean valid) {
		this.isValid = valid;
	}



	/**
	 *
	 * qgԍ擾
	 *
	 * @return qgԍBݒȂ -1 ɂ
	 *
	 */
	public int getHintNumber() {
		return this.hintNumber;
	}



	/**
	 *
	 * qgԍݒ肷
	 * ݒ̏ꍇ -1 ݒ肷B
	 * ȊOꍇA-1 ɂȂB
	 *
	 * @param num qgԍ
	 *
	 */
	public void setHintNumber(int num) {
		if(num < 1) {
			this.hintNumber = -1;
		}
		this.hintNumber = num;
	}



	/**
	 *
	 * `p\bh
	 *
	 * @param canvas `悷LoX
	 * @param paint `p̃yCg
	 *
	 */
	public void draw(Canvas canvas, Paint paint) {

		// }X̕`
		paint.setStrokeWidth(1);
		if(isValid()) {

			// I
			if(this.isSelect) {
				paint.setColor(Color.CYAN);
				paint.setStyle(Style.FILL);
				canvas.drawRect(this, paint);

				paint.setStyle(Style.STROKE);
			}

			// `FbNŁAԈႢƂ킩ԂB
			// gƓhԂ̐F𕪂Ȃ炵̂ŁAg͕ʓr`
			if(this.checkFlag && (this.getAnswerWord() != this.getCurrentWord())) {
				paint.setColor(Color.RED);
				paint.setStyle(Style.FILL);
				canvas.drawRect(this, paint);

				paint.setStyle(Style.STROKE);
			}

			// 
			if(this.rightAnswerFlag) {
				paint.setColor(Color.rgb(50, 255, 100));
				paint.setStyle(Style.FILL);
				canvas.drawRect(this, paint);

				paint.setStyle(Style.STROKE);
			}
		} else {
			paint.setStyle(Style.FILL_AND_STROKE);
		}
		paint.setColor(Color.BLACK);
		canvas.drawRect(this, paint);

		// qgԍ̕`
		paint.setColor(Color.BLACK);
		paint.setStrokeWidth(0);
		paint.setStyle(Style.STROKE);
		paint.setTextAlign(Align.CENTER);

		float hintSize = this.boxSize / 4.0f;
		paint.setTextSize(hintSize);	// Ƃ肠qgԍ̃TCY̓}X1/4
		if(getHintNumber() > 0 && isValid()) {
			canvas.drawText(String.valueOf(getHintNumber()), left + hintSize/2.0f + 1, top + hintSize, paint);
		}

		// ̕\
		if(this.currentWord != ' ' || this.isShowAnswer) {
			float charSize = this.boxSize / 2.0f;
			paint.setTextSize(charSize);	// // ̃TCY̓}X1/2

			// 𓚂͂
			char word;
			if(this.isShowAnswer) {
				word = getAnswerWord();
			} else {
				word = getCurrentWord();
			}

			canvas.drawText(String.valueOf(word), this.centerX(), this.centerY() + charSize/2.0f, paint);
		}
	}



	/**
	 *
	 * `FbNtOݒ肷B
	 * ʂ`悷ɂ́Ar[ōXVsKvB
	 * }X̏ꍇ͉ȂB
	 *
	 * @param flag trueȂ琳`FbNsB
	 *
	 */
	public void setCheckFlag(boolean flag) {
		if(this.isValid()) {
			this.checkFlag = flag;
		}
	}



	/**
	 *
	 * 𓚕\ꍇ́Atrue ݒ肵܂B
	 * ʂ`悷ɂ́Ar[ōXVsKvB
	 * }X̏ꍇ͉ȂB
	 *
	 * @param flag trueȂ𓚕\
	 *
	 */
	public void setIsShowAnswer(boolean flag) {
		if(this.isValid()) {
			this.isShowAnswer = flag;
		}
	}



	/**
	 *
	 * I̋\sꍇ́Atrue ݒ肵܂B
	 * ʂ`悷ɂ́Ar[ōXVsKvB
	 * }X̏ꍇ͉ȂB
	 *
	 * @param flag trueȂ琅FɂȂB
	 *
	 */
	public void setIsSelect(boolean flag) {
		if(this.isValid()) {
			this.isSelect = flag;
		}
	}



	/**
	 *
	 * 𓚂AȂ킿A
	 * ͂Ɛv邩ׂB
	 *
	 * }X͕K true
	 *
	 * @return vȂ true
	 *
	 */
	public boolean isRight() {
		if(!this.isValid) {
			return true;
		}

		if(this.isValid && (this.getAnswerWord() == this.getCurrentWord())) {
			return true;
		}

		return false;
	}



	/**
	 *
	 * ̐F
	 *
	 * @param flag trueȂΐFɂȂ
	 *
	 */
	public void setRightAnswerFlag(boolean flag) {
		if(this.isValid()) {
			this.rightAnswerFlag = flag;
		}
	}
}
