package jp.ac.osaka_u.ist.sel.crossword.board;

import jp.ac.osaka_u.ist.sel.crossword.PuzzleActivity;
import android.view.MotionEvent;

public class DeleteMotionManager extends AbstractMotionManager {
	private int lastBoxX,lastBoxY;
	public DeleteMotionManager(PuzzleActivity p,MotionEvent event,int boxY,int boxX){
		// TODO Auto-generated constructor stub
		super(p,event,boxY,boxX);
		sendDelete(boxY,boxX);
		puzzleActivity.getView().setSelectBox(boxY, boxX, true);
		lastBoxX=boxX;
		lastBoxY=boxY;
	}
	public void onMove(MotionEvent evant,int boxY,int boxX){
		if(boxY!=lastBoxY||boxX!=lastBoxX){
			sendDelete(boxY, boxX);
			puzzleActivity.getView().unselectBox();
			puzzleActivity.getView().setSelectBox(boxY, boxX, true);
			lastBoxX=boxX;
			lastBoxY=boxY;
		}
	}
	public void onUp(int boxY,int boxX){
		puzzleActivity.getView().unselectBox();
	}
	private void sendDelete(int boxY,int boxX){
		if(puzzleActivity.getView().isOnBoard(boxX, boxY)){
			puzzleActivity.sendDelete(boxY, boxX);
		}
	}
}
