package jp.ac.osaka_u.ist.sel.crossword.board;

import java.util.ArrayList;

import jp.ac.osaka_u.ist.sel.crossword.PuzzleActivity;

import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.content.DialogInterface;
import android.inputmethodservice.Keyboard.Key;
import android.view.MotionEvent;

public class InputMotionManager extends AbstractMotionManager {
	private boolean isExpired=false;
	public InputMotionManager(PuzzleActivity p,MotionEvent event,int boxY,int boxX){
		// TODO Auto-generated constructor stub
		super(p,event,boxY,boxX);
		if(p.getView().isOnBoard(boxX, boxY)){
			puzzleActivity.getView().setSelectBox(boxY, boxX, true);
		}else{
			isExpired=true;
		}
	}
	public void onMove(MotionEvent event,int boxY,int boxX){
		if(isExpired)return;
		float dy=event.getY()-y;
		float dx=event.getX()-x;
		final float THRESHOLD=100;
		if(Math.max(dy, dx)<THRESHOLD)return;
		final int orient=(dy>dx)?KeywordData.ORIENT_HEIGHT:KeywordData.ORIENT_WIDTH;
		ArrayList<KeywordData> keywordDatas=puzzleActivity.getKeywordDatas();
		int hintNumber=puzzleActivity.getHintsPotision()[this.boxY][this.boxX];
		for(KeywordData k:keywordDatas){
			if(k.getNumber()==hintNumber&&k.getOrient()==orient){
				puzzleActivity.getInputManager().startInput(k);
				isExpired=true;
				return;
			}
		}
		System.out.println(hintNumber+":"+dy+":"+dx);
	}
	public void onUp(int boxY,int boxX){
		puzzleActivity.getView().unselectBox();
		if(isExpired)return;
		if(this.boxY!=boxY||this.boxX!=boxX)return;
		int hintNumber=puzzleActivity.getHintsPotision()[boxY][boxX];
		ArrayList<KeywordData> k=(ArrayList<KeywordData>)puzzleActivity.getKeywordDatas().clone();
		for(int i=k.size()-1;i>=0;i--){
			if(k.get(i).getNumber()!=hintNumber){
				k.remove(i);
			}
		}
		if(k.size()>0){
			if(k.size()==1){
				puzzleActivity.getInputManager().startInput(k.get(0));
			}else{
				final KeywordData down,across;
				if(k.get(0).getOrient()==KeywordData.ORIENT_HEIGHT){
					down=k.get(0);
					across=k.get(1);
				}else{
					down=k.get(1);
					across=k.get(0);
				}
				final Builder builder=new AlertDialog.Builder(puzzleActivity);
				builder.setTitle("ǂɓ͂܂H");
				builder.setMessage(down.toHintString()+"\n"+across.toHintString());
				builder.setPositiveButton("^e", new DialogInterface.OnClickListener() {
					
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						puzzleActivity.getInputManager().startInput(down);
					}
				});
				builder.setNeutralButton("R", new DialogInterface.OnClickListener() {
					
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						puzzleActivity.getInputManager().startInput(across);
					}
				});
				builder.setNegativeButton("LZ", new DialogInterface.OnClickListener() {
					
					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						dialog.dismiss();
					}
				});
				final AlertDialog dialog=builder.create();
				dialog.show();
			}
		}
	}

}
