package jp.ac.osaka_u.ist.sel.crossword.board;

import java.io.Serializable;

public class KeywordData implements Serializable{

	/**
	 * c
	 */
	public static final int ORIENT_HEIGHT = 1;

	/**
	 * 
	 */
	public static final int ORIENT_WIDTH = 2;

	private String keyword;
	private String hint;
	private int orient;
	private int number;


	public String getKeyword() {
		return keyword;
	}
	public String getHint() {
		return hint;
	}
	public int getOrient() {
		return orient;
	}
	public int getNumber(){
		return number;
	}
	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}
	public void setHint(String hint) {
		this.hint = hint;
	}
	public void setOrient(int orient) {
		this.orient = orient;
	}
	public void setNumber(int number){
		this.number=number;
	}

	@Override
	public String toString() {
		String orientStr;
		if(getOrient() == ORIENT_HEIGHT) {
			orientStr = "Height";
		} else if(getOrient() == ORIENT_WIDTH) {
			orientStr = "Width";
		} else {
			orientStr = "Unknown";
		}

		return keyword + ": orient=" + orientStr + "\n" + hint;
	}
	
	public String toHintString(){
		return String.format("(%d:%s)%s",getNumber(),(getOrient()==KeywordData.ORIENT_HEIGHT)?"^e":"R", getHint());
	}
}
