package jp.ac.osaka_u.ist.sel.crossword.board;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.Log;

public class QuestionReader {

	private int size_h = -1;	// c̃}X
	private int size_w = -1;	// ̃}X
	private ArrayList<String> boardLines = new ArrayList<String>();	// ՖʁisPʁj
	private ArrayList<KeywordData> keyList = new ArrayList<KeywordData>();
	private int[][] numbers;

	/**
	 *
	 * t@Cw肵āAǂݍށB
	 *
	 * @param filename fBNgassetsɑ݂t@C
	 * @param resource Activity.getResource()Ŏ擾ł郊\[X
	 * @throws IOException o̓G[
	 * @throws QuestionDataException f[^Ƀ~X
	 *
	 */
	public QuestionReader(String filename, Resources resource) throws IOException, QuestionDataException {
		AssetManager manager = resource.getAssets();
		InputStream in = manager.open(filename);
		BufferedReader reader = new BufferedReader(new InputStreamReader(in));

		String line;
		while((line = reader.readLine()) != null) {

			// Ֆʂ̎擾
			if(line.equals("#begin{board}")) {
				readBoardData(reader);
			}else if(line.equals("#begin{number}")){
				readNumberData(reader);
			}else if(line.equals("#begin{keyword}")) {
				// JM̎擾
				Log.d("board", "QuestionReader Keyword Start.");
				readKeywordData(reader);
				Log.d("board", "QuestionReader Keyword End.");
			} else {
				Log.d("board", "QuestionReader Constructor: Skip Line");
			}
		}
		Log.d("board", "QuestionReader Process End.");
		reader.close();
	}


	public int getHeightSize() {
		return size_h;
	}

	private void setHeightSize(int height) {
		size_h = height;
	}


	public int getWidthSize() {
		return size_w;
	}


	private void setWidthSize(int width) {
		size_w = width;
	}


	public ArrayList<String> getBoardLines() {
		return boardLines;
	}


	public ArrayList<KeywordData> getKeywordList() {
		return keyList;
	}

	public int[][] getNumbers(){
		return numbers;
	}
	
	private void readKeywordData(BufferedReader reader) throws IOException, QuestionDataException {
		String line;
		while((line = reader.readLine()) != "#end{keyword}") {

			// I
			if(line.equals("#end{keyword}")) {
				return;
			}

			if(line.equals("#begin{height}")) {
				Log.d("board", "QuestionReader Height Start.");
				readHeightData(reader);
				Log.d("board", "QuestionReader Height End.");
			} else if(line.equals("#begin{width}")) {
				Log.d("board", "QuestionReader Width Start.");
				readWidthData(reader);
				Log.d("board", "QuestionReader Width End.");
			} else {
				Log.d("board", "readKeywordData: Skip Line");
			}
		}

		// rŃt@CI
		// f[^ΓBȂ
		Log.e("board", "readKeywordData: Syntax Error");
		throw new QuestionDataException();
	}


	private void readHeightData(BufferedReader reader) throws IOException, QuestionDataException {
		String line;
		while((line = reader.readLine()) != null) {

			// s̓XLbv
			if(line.equals("")) {
				continue;
			}

			// I
			if(line.equals("#end{height}")) {
				return;
			}

			String[] dataArray = line.split("=");	// 0:ԍA1:JMA2:qg

			if(dataArray.length != 3) {
				Log.e("board", "readHeightData: Syntax Error");
				throw new QuestionDataException();
			}

			KeywordData keyData = new KeywordData();
			keyData.setNumber(Integer.parseInt(dataArray[0]));
			keyData.setKeyword(dataArray[1]);
			keyData.setHint(dataArray[2]);
			keyData.setOrient(KeywordData.ORIENT_HEIGHT);
			keyList.add(keyData);
		}

		// rŃt@CI
		// f[^ΓBȂ
		Log.e("board", "readHeightData: Syntax Error");
		throw new QuestionDataException();
	}


	private void readWidthData(BufferedReader reader) throws IOException, QuestionDataException {
		String line;
		while((line = reader.readLine()) != null) {

			// s̓XLbv
			if(line.equals("")) {
				continue;
			}

			// I
			if(line.equals("#end{width}")) {
				return;
			}

			String[] dataArray = line.split("=");	// 0:ԍA1:JMA2:qg

			if(dataArray.length != 3) {
				Log.e("board", "readWidthData: Syntax Error");
				throw new QuestionDataException();
			}

			KeywordData keyData = new KeywordData();
			keyData.setNumber(Integer.parseInt(dataArray[0]));
			keyData.setKeyword(dataArray[1]);
			keyData.setHint(dataArray[2]);
			keyData.setOrient(KeywordData.ORIENT_WIDTH);
			keyList.add(keyData);
		}

		// rŃt@CI
		// f[^ΓBȂ
		Log.e("board", "readWidthData: Syntax Error");
		throw new QuestionDataException();
	}


	private void readBoardData(BufferedReader reader) throws IOException, QuestionDataException {
		String line;
		while((line = reader.readLine()) != null) {

			// s̓XLbv
			if(line.equals("")) {
				continue;
			}

			// I
			if(line.equals("#end{board}")) {
				setHeightSize(boardLines.size());
				return;
			}

			// AՖʃTCY̌
			if(getWidthSize() == -1) {
				setWidthSize(line.length());
			} else if(getWidthSize() != line.length()) {
				Log.e("board", "BoardReader: Number of Column unmatched");
				Log.e("board", "WidthSize: " + getWidthSize() + ", LineLength: " + line.length());
				throw new QuestionDataException();
			}

			boardLines.add(line);
		}

		// rŃt@CI
		// f[^ΓBȂ
		Log.e("board", "BoardReader: Syntax Error");
		throw new QuestionDataException();
	}

	private void readNumberData(BufferedReader reader) throws IOException, QuestionDataException {
		numbers=new int[size_h][size_w];
		String line;
		int row=0;
		while((line = reader.readLine()) != null) {

			// s̓XLbv
			if(line.equals("")) {
				continue;
			}

			// I
			if(line.equals("#end{number}")) {
				//setHeightSize(boardLines.size());
				return;
			}
			
			String[] nums=line.split(",");
			for(int i=0;i<nums.length;i++){
				try{
					numbers[row][i]=Integer.parseInt(nums[i]);
				}catch (NumberFormatException e) {
					// TODO: handle exception
				}
			}
			row++;
		}

		// rŃt@CI
		// f[^ΓBȂ
		Log.e("number", "NumberReader: Syntax Error");
		throw new QuestionDataException();
	}
}
