package jp.ac.osaka_u.ist.sel.crossword.voice.recognizer;

import java.net.URLEncoder;

import javax.xml.parsers.DocumentBuilderFactory;


import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import android.os.AsyncTask;

public class ToKana {
	public String toKanaString(String string){
		try{
			System.err.println("http://jlp.yahooapis.jp/MAService/V1/parse?appid=dj0zaiZpPWx3Y3J1Rk1RTzJwTSZzPWNvbnN1bWVyc2VjcmV0Jng9ZjI-&sentence="+URLEncoder.encode(string, "UTF-8"));
		}catch(Exception e){}
		StringBuilder res=new StringBuilder();
		WordInfo[] wordInfo=toKanaList(string);
		for(WordInfo w:wordInfo){
//			if(!w.getPos().equals(""))return "";
			String reading=w.getReading();
			for(int i=0;i<reading.length();i++){
				Character c=reading.charAt(i);
				if(''<=c&&c<='['){
					res.append(c);
				}
			}
		}
		return res.toString();
	}
	public WordInfo[] toKanaList(final String string){
		try{
			AsyncTask<Void, Void, WordInfo[]> at=new AsyncTask<Void, Void, WordInfo[]>() {
				@Override
				protected WordInfo[] doInBackground(Void... params) {
					// TODO Auto-generated method stub
					try {
						Document document=DocumentBuilderFactory.newInstance().newDocumentBuilder().parse("http://jlp.yahooapis.jp/MAService/V1/parse?appid=dj0zaiZpPWx3Y3J1Rk1RTzJwTSZzPWNvbnN1bWVyc2VjcmV0Jng9ZjI-&sentence="+URLEncoder.encode(string, "UTF-8"));
						NodeList readingList=document.getElementsByTagName("reading");
						NodeList posList=document.getElementsByTagName("pos");
						WordInfo[] wordInfo=new WordInfo[readingList.getLength()];
						for(int i=0;i<readingList.getLength();i++){
							wordInfo[i]=new WordInfo(readingList.item(i).getTextContent(),posList.item(i).getTextContent());
						}
						return wordInfo;
					} catch (Exception e) {
						e.printStackTrace();
						return null;
					}
				}
			};
			at.execute();
			return at.get();
		}catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			return null;
		}
	}
	public static String toKatakana(String string){
		StringBuilder builder=new StringBuilder();
		for(int i=0;i<string.length();i++){
			char c=string.charAt(i);
			if(''<=c&&c<'@'){
				builder.append((char)(c+('@'-'')));
			}else{
				builder.append(c);
			}
		}
		return builder.toString();
	}
}
