package jp.ac.osaka_u.ist.sel.crossword.voice.recognizer;

import java.util.ArrayList;
import java.util.Arrays;

import jp.ac.osaka_u.ist.sel.crossword.board.KeywordData;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.content.Intent;
import android.speech.RecognizerIntent;
import android.widget.Toast;

public class VoiceRecognizer {

	public static final int VOICE_RECOGNITION_REQUEST_CODE=18194;	//FpNGXgR[h
	private final Activity activity;
	private int wordLength;

	public VoiceRecognizer(Activity activity) {
		this.activity=activity;
	}

	public void requestRecognition(KeywordData k){
		this.wordLength=k.getKeyword().length();
		Intent intent = new Intent(
				RecognizerIntent.ACTION_RECOGNIZE_SPEECH); // ACTION_WEB_SEARCH
		intent.putExtra(
				RecognizerIntent.EXTRA_LANGUAGE_MODEL,
				RecognizerIntent.LANGUAGE_MODEL_FREE_FORM);
		intent.putExtra(
				RecognizerIntent.EXTRA_PROMPT,
				k.toHintString()); // DȕɕύXł܂

		try {
			// Cegs
			activity.startActivityForResult(intent, VOICE_RECOGNITION_REQUEST_CODE);
		} catch (ActivityNotFoundException e) {
			// ̃CegɉłANeBreBCXg[ĂȂꍇ
			Toast.makeText(activity,
					"F𗘗pł܂", Toast.LENGTH_LONG).show();
			Intent dummyIntent=new Intent();
			ArrayList<String> value=new ArrayList<String>(Arrays.asList(new String[]{"","eXg","p","","ł","123","STU","[[[","ABC","EDF","Ă"}));
			dummyIntent.putStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS, value);
			((VoiceRecognitionActivity)activity).onActivityResult( VOICE_RECOGNITION_REQUEST_CODE, Activity.RESULT_OK, dummyIntent);
		}
	}

	public void onActivityResult(int resultCode,Intent data){
		if(resultCode==Activity.RESULT_OK){
			ArrayList<String> results = data.getStringArrayListExtra(
					RecognizerIntent.EXTRA_RESULTS);
			final ArrayList<String> kanas=new ArrayList<String>();
			for(int i=0;i<results.size();i++){
				String temp=new ToKana().toKanaString(results.get(i));
				if(temp.length()==wordLength&&!kanas.contains(temp)){
					kanas.add(temp);
				}
			}
			if(kanas.isEmpty()){
				Intent intent=new Intent();
				intent.putExtra(VoiceRecognitionActivity.RECOGNITION_RESULT, new ChoiceNotFoundException());
				activity.setResult(Activity.RESULT_OK, intent);
				activity.finish();
			}else{
				kanas.add(0,"LZ");
				AlertDialog.Builder builder=new AlertDialog.Builder(activity);
				builder.setItems(kanas.toArray(new String[0]),new DialogInterface.OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						// TODO Auto-generated method stub
						Intent intent=new Intent();
						if(which==0){
							intent.putExtra(VoiceRecognitionActivity.RECOGNITION_RESULT, new RecognitionCanceledException());
						}else{
							intent.putExtra(VoiceRecognitionActivity.RECOGNITION_RESULT, kanas.get(which));
						}
						activity.setResult(Activity.RESULT_OK, intent);
						activity.finish();
					}
				});
				builder.setCancelable(false);
				AlertDialog dialog=builder.create();
				dialog.setCanceledOnTouchOutside(false);
				dialog.show();
			}
		}else {
			Intent intent=new Intent();
			intent.putExtra(VoiceRecognitionActivity.RECOGNITION_RESULT, new RecognitionCanceledException());
			activity.setResult(Activity.RESULT_OK, intent);
			activity.finish();
		}
	}
}
