package jp.ac.osaka_u.ist.sel.android.BluetoothReversi;

import java.util.ArrayList;
import java.util.Random;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Toast;

public class BoardViewAlone extends View implements OnClickListener,Runnable {
	private Paint paint = new Paint();

	//逕ｻ髱｢謠冗判逕ｨ
	private int dispWidth;
	private int dispHeight;
	private int size;
	//TODO 逕ｻ蜒剰ｪｭ縺ｿ霎ｼ縺ｿ
	private Resources res = this.getContext().getResources();
	private Bitmap IMG_BLACK = BitmapFactory.decodeResource(res,R.drawable.reversi_black);
	private Bitmap IMG_YELLOW = BitmapFactory.decodeResource(res,R.drawable.yellow);
	private Bitmap IMG_WHITE = BitmapFactory.decodeResource(res,R.drawable.reversi_white);
	private Bitmap IMG_BOARD = BitmapFactory.decodeResource(res,R.drawable.board);
	//逶､髱｢
	private final int BLANK = 0;
	private final int BLACK = 1;
	private final int WHITE = 2;
	private final int WALL = 3;
	//迥ｶ諷�
	private final int TITLE = 0;
	private  int PLAYER = 1;
	private  int RIVAL = 2;
	private final int TURN = 3;
	private final int REVERS = 4;
	private final int CONTROL = 5;
	private final int PASS = 6;
	private final int RESULT = 7;
	private int[] board = new int[100];

	private int page = TITLE;
	private int turn;
	private int turnCount;
	private int place;
	private int rivalPlace=0;
	private int[] placeMap = new int[100];
	private int[] direction = {-11, -10, -9, -1, 1, 9, 10, 11};
	private Activity ctx;


	private Bitmap turn_img[] = {

			BitmapFactory.decodeResource(res,R.drawable.turn1),
			BitmapFactory.decodeResource(res,R.drawable.turn2),
			BitmapFactory.decodeResource(res,R.drawable.turn3),
			BitmapFactory.decodeResource(res,R.drawable.turn4),
			BitmapFactory.decodeResource(res,R.drawable.turn5),
			BitmapFactory.decodeResource(res,R.drawable.turn6),
			BitmapFactory.decodeResource(res,R.drawable.turn7),
			BitmapFactory.decodeResource(res,R.drawable.turn8),
			BitmapFactory.decodeResource(res,R.drawable.turn9),
			BitmapFactory.decodeResource(res,R.drawable.turn10),
			BitmapFactory.decodeResource(res,R.drawable.turn11),
			BitmapFactory.decodeResource(res,R.drawable.turn12)};


	private Bitmap turn_img_rev[] = {

			BitmapFactory.decodeResource(res,R.drawable.turn12),
			BitmapFactory.decodeResource(res,R.drawable.turn11),
			BitmapFactory.decodeResource(res,R.drawable.turn10),
			BitmapFactory.decodeResource(res,R.drawable.turn9),
			BitmapFactory.decodeResource(res,R.drawable.turn8),
			BitmapFactory.decodeResource(res,R.drawable.turn7),
			BitmapFactory.decodeResource(res,R.drawable.turn6),
			BitmapFactory.decodeResource(res,R.drawable.turn5),
			BitmapFactory.decodeResource(res,R.drawable.turn4),
			BitmapFactory.decodeResource(res,R.drawable.turn3),
			BitmapFactory.decodeResource(res,R.drawable.turn2),
			BitmapFactory.decodeResource(res,R.drawable.turn1)};

	private static int animation_cnt = -1;
	private Handler mHandler = new Handler();

	private boolean threadFlag = false;



	private ArrayList<Integer> reverseList = new ArrayList<Integer>();


	public BoardViewAlone(Context context) {

		super(context);
		for(int i=11;i<=88;i++) board[i] = BLANK;
		for(int i=0;i<10;i++) board[i] = WALL;
		for(int i=1;i<9;i++) board[i*10] = WALL;
		for(int i=1;i<9;i++) board[i*10+9] = WALL;
		for(int i=0;i<10;i++) board[i+90] = WALL;
		board[44] = WHITE;
		board[45] = BLACK;
		board[54] = BLACK;
		board[55] = WHITE;
		page = PLAYER;
		turn = PLAYER;
		ctx = (Activity)context;
	}

	public BoardViewAlone(Context context,AttributeSet attrs) {

		super(context,attrs);

		setFocusable(true);

		initGame();

		ctx = (Activity)context;
	}

	public void restartGame() {

		this.initGame();
		invalidate();
	}

	private void initGame() {

		turnCount = 0;
		rivalPlace=0;

		for(int i=11;i<=88;i++) board[i] = BLANK;
		for(int i=0;i<10;i++) board[i] = WALL;
		for(int i=1;i<9;i++) board[i*10] = WALL;
		for(int i=1;i<9;i++) board[i*10+9] = WALL;
		for(int i=0;i<10;i++) board[i+90] = WALL;
		board[44] = WHITE;
		board[45] = BLACK;
		board[54] = BLACK;
		board[55] = WHITE;

		for (int i=0; i<100; i++) placeMap[i] = 0;

		long seed = System.currentTimeMillis();
		Random rnd = new Random(seed);
		int ran = rnd.nextInt(2)+1;

		if (ran == BLACK) {

			PLAYER = BLACK;
			RIVAL = WHITE;
			turn = PLAYER;
		} else {

			PLAYER = WHITE;
			RIVAL = BLACK;
			turn = RIVAL;
		}

		page = TITLE;
	}

	@Override
	public void onDraw(Canvas c) {

		//TODO 繝懊�ｼ繝峨ｒ陦ｨ遉ｺ
		dispWidth = c.getWidth();
		dispHeight = c.getHeight();
		size = dispWidth/10;
		IMG_BLACK = Bitmap.createScaledBitmap(IMG_BLACK, size, size, true);
		IMG_WHITE = Bitmap.createScaledBitmap(IMG_WHITE, size, size, true);
		IMG_BOARD = Bitmap.createScaledBitmap(IMG_BOARD, dispWidth, dispWidth, true);
		IMG_YELLOW = Bitmap.createScaledBitmap(IMG_YELLOW, size, size, true);
		paint.setStrokeWidth(3);
		paint.setColor(Color.GREEN);

		c.drawBitmap(IMG_BOARD, 0,0, null);

		//アニメーションに関する処理
		if ((reverseList.size()!=0) && (animation_cnt>0)) {

			for (int j=0; j<reverseList.size(); j++) {

				int rp = reverseList.get(j);

				if (animation_cnt == 12) {

					break;
				}

				if (turn == PLAYER) {
					if (PLAYER == BLACK) {
						c.drawBitmap(turn_img_rev[animation_cnt],size*(rp%10),size*(rp/10), null);
					} else {
						c.drawBitmap(turn_img[animation_cnt],size*(rp%10),size*(rp/10), null);
					}
				} else {
					if (PLAYER == BLACK) {
						c.drawBitmap(turn_img[animation_cnt],size*(rp%10),size*(rp/10), null);
					} else {
						c.drawBitmap(turn_img_rev[animation_cnt],size*(rp%10),size*(rp/10), null);
					}
				}

			}

		} else if (animation_cnt == -10){

			for (int j=0; j<reverseList.size(); j++) {

				int rp = reverseList.get(j);

				if (turn == PLAYER) {
					if (PLAYER == BLACK) {
						c.drawBitmap(IMG_BLACK, size*(rp%10), size*(rp/10), null);
						board[rp] = BLACK;

					} else {
						c.drawBitmap(IMG_WHITE, size*(rp%10), size*(rp/10), null);
						board[rp] = WHITE;
					}
				} else {
					if (PLAYER == BLACK) {
						c.drawBitmap(IMG_WHITE, size*(rp%10), size*(rp/10), null);
						board[rp] = WHITE;

					} else {
						c.drawBitmap(IMG_BLACK, size*(rp%10), size*(rp/10), null);
						board[rp] = BLACK;
					}
				}
			}

			reverseList.clear();
			animation_cnt = -1;
			threadFlag = false;

		} else {

		}
	//アニメーションに関する処理

		for(int i=11;i<=88;i++) {
			if(board[i]==BLACK){

            	c.drawBitmap(IMG_BLACK, size*(i%10), size*(i/10), null);
				/*if(rivalPlace==i){
					paint.setStyle(Paint.Style.STROKE);
					paint.setColor(Color.MAGENTA);
					c.drawCircle (size*(i%10)+size/2, size*(i/10)+size/2, size/2-2, paint);
					paint.setStyle(Paint.Style.FILL);
				}*/
			}
				if(board[i]==WHITE){

					c.drawBitmap(IMG_WHITE, size*(i%10), size*(i/10), null);
					/*if(rivalPlace ==i){
						paint.setStyle(Paint.Style.STROKE);
						paint.setColor(Color.MAGENTA);
						c.drawCircle (size*(i%10)+size/2, size*(i/10)+size/2, size/2-2, paint);
						paint.setStyle(Paint.Style.FILL);
					}*/
				}
		}

		switch(page) {
		case TITLE:
			//show player stone color and message
			//transitions with tap screen
			paint.setColor(Color.BLACK);
			paint.setTextSize(36);
			c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.3), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			if (PLAYER == BLACK)
				c.drawText("あなた", (float)(dispWidth*0.27), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			else
				c.drawText("CPU", (float)(dispWidth*0.29), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.6), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			if (PLAYER == BLACK)
				c.drawText("CPU", (float)(dispWidth*0.58), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			else c.drawText("あなた", (float)(dispWidth*0.56), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawText("画面をタップでゲーム開始",(float)(dispWidth*0.2), (float)(dispWidth*0.25),paint);

			break;
		case TURN:
			page = turn;
			invalidate();
			break;
		case BLACK:
		case WHITE:
			if(page == PLAYER){

				makePlaceMap(PLAYER);
				for(int i=11;i<=88;i++) {
					if(placeMap[i]>0){
		            	c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10), null);
					}
				}

				paint.setColor(Color.BLACK);
				paint.setTextSize(36);
				c.drawText("あなたの番", (float)(dispWidth*0.15), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
				rivalPlace = 0;

				if (PLAYER == BLACK) {
					c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
				} else {
					c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
				}

				break;
			}else{

				makePlaceMap(RIVAL);
				place = getPutPlace(RIVAL);
				rivalPlace = place;
				page = REVERS;
				invalidate();

				break;
			}
		case REVERS:
			reverse(turn, place);


			//アニメーションに関する処理
			this.startAnimation();
			//アニメーションに関する処理


			//繝壹�ｼ繧ｸ遘ｻ蜍�
			page = CONTROL;
			invalidate(new Rect(size*(place%10),size*(place/10),size*(place%10)+size,size*(place/10)+size));
			break;
		case CONTROL:

			if (threadFlag) break;

			//繧ｿ繝ｼ繝ｳ繧剃ｺ､莉｣
			if(turn==PLAYER) turn = RIVAL;
			else turn = PLAYER;
			//繝壹�ｼ繧ｸ遘ｻ蜍�
			if(makePlaceMap(PLAYER)==true && makePlaceMap(RIVAL)==true) page = RESULT;
			else if(makePlaceMap(turn)==true) page = PASS;
			else page = TURN;
			invalidate();
			break;
		case PASS:
			Toast.makeText(ctx,"pass",Toast.LENGTH_SHORT).show();
			//繧ｿ繝ｼ繝ｳ繧剃ｺ､莉｣
			if(turn==PLAYER) turn = RIVAL;
			else turn = PLAYER;
			//繝壹�ｼ繧ｸ遘ｻ蜍�
			page = TURN;
			rivalPlace = 0;
			invalidate();
			break;
		case RESULT:
			paint.setColor(Color.BLACK);
			paint.setTextSize(36);

			c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.27), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			c.drawText(String.valueOf(count(BLACK)), (float)(dispWidth*0.3), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.6), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			c.drawText(String.valueOf(count(WHITE)), (float)(dispWidth*0.57), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			if(count(PLAYER)==count(RIVAL)){
				c.drawText("引き分けです", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);
			}else
			if(count(PLAYER)>count(RIVAL)){
				c.drawText("あなたの勝ち!", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);
			}
			else{
				c.drawText("あなたの負け!", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);
			}

			break;
		}

	}

	public boolean onTouchEvent(MotionEvent me) {

		if (threadFlag) return true;

		int padX = (int)(me.getX()/size);
		int padY = (int)(me.getY()/size);
		if(me.getAction()==MotionEvent.ACTION_DOWN) {
			switch(page) {
			case TITLE:

				//transitions to PLAYER or RIVAL
				if (PLAYER == BLACK) page = PLAYER;
				else page = RIVAL;

				invalidate();
				break;
			case BLACK:
			case WHITE:
				if(page == PLAYER){
					if(padX+padY*10<100){
						if(placeMap[padX+padY*10]>0) {
							place = padX+padY*10;
							page = REVERS;
						}
						invalidate();
					}
					break;
				}else{

					invalidate();
					break;
				}
			case PASS:
				break;
			case RESULT:
				break;
			}
		}
		return true;
	}
	void reverse(int myColor, int p) {//遏ｳ繧偵�ｲ縺｣縺上ｊ霑斐☆
		int yourColor = PLAYER;
		turnCount++;
		if(myColor==PLAYER) yourColor = RIVAL;
		if(p<board.length){
			board[p] = myColor;
			for(int i : direction) {
				if(board[p+i]==yourColor) {
					for(int j=2;j<8;j++) {
						if(board[p+i*j]==myColor) {
							for(int k=1;k<j;k++) {


								board[p+i*k] = BLANK;

								//store reverse cell data to ArrayList
								reverseList.add(p+i*k);

							}
							break;
						} else if(board[p+i*j]==yourColor) {
						} else {
							break;
						}
					}
				}
			}
		}
	}
	public boolean makePlaceMap(int myColor) {//鄂ｮ縺代ｋ蝣ｴ謇�縺ｮ蛻､螳�
		int yourColor;
		boolean pass = true;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		for(int p=0;p<100;p++) {
			placeMap[p] = 0;
			if(0<p && p<100 && board[p]==0) {
				for(int i: direction) {
					if(board[p+i]==yourColor) {
						for(int j=2;j<8;j++) {
							if(board[p+i*j]==myColor) {
								placeMap[p] += j-1;
								pass = false;
								break;
							} else if(board[p+i*j]==yourColor) {
							} else {
								break;
							}
						}
					}
				}
			}
		}
		return pass;
	}
	public int getPutPlace(int myColor){
		int tmpBoard[] = new int[100];
		int[] direction = {-11, -10, -9, -1, 1, 9, 10, 11};
		int value,place = 0;
		int maxValue = -100;//譛�螟ｧ隧穂ｾ｡蛟､
		int yourColor;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		for(int i=11;i<=88;i++) {
			if(placeMap[i]>0){
				if(i<tmpBoard.length){
					System.arraycopy(board, 0, tmpBoard, 0, 100);
					tmpBoard[i] = myColor;
					for(int dir : direction) {
						if(tmpBoard[i+dir]==yourColor) {
							for(int j=2;j<8;j++) {
								if(tmpBoard[i+dir*j]==myColor) {
									for(int k=1;k<j;k++) {
										tmpBoard[i+dir*k] = myColor;
									}
									break;
								} else if(tmpBoard[i+dir*j]==yourColor) {
								} else {
									break;
								}
							}
						}
					}
					if(!isPass(yourColor,tmpBoard)) {
						value = (-1)*getBoardScore(yourColor,tmpBoard,3);
					} else {
						if(!isPass(myColor,tmpBoard)) {
							value = getBoardScore(myColor,tmpBoard,3);
						} else {
							value = getBoardValue(myColor, tmpBoard)-getDropDownPlace(yourColor,tmpBoard)*2;
						}
					}
					if(value > maxValue){
						maxValue = value;
						place = i;
					}
				}
			}
		}
		return place;
	}

	public int getBoardValue(int myColor, int[] board){
		int value = 0;
		int yourColor;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		if (turnCount>47){
			return count(myColor,board);
		}else{
			int valuePlace[][] = {
					{ 40,-12,  5, -1, -1,  5,-12, 40,},
					{-12,-17, -1, -3, -3, -1,-17,-12,},
					{  5, -1,  2, -1, -1,  2, -1,  5,},
					{ -1, -3, -1,  0,  0, -1, -3, -1,},
					{ -1, -3, -1,  0,  0, -1, -3, -1,},
					{  5, -1,  2, -1, -1,  2, -1,  5,},
					{-12,-17, -1, -3, -3, -1,-17,-12,},
					{ 40,-12,  4, -1, -1,  4,-12, 40,}};
			for(int i=11;i<=88;i++) {
				if(board[i]==myColor){
					value += valuePlace[(i%10)-1][(i/10)-1];
				}
				if(board[i]==yourColor){
					value -= valuePlace[(i%10)-1][(i/10)-1];
				}
			}
		}
		return value;

	}
	public int getDropDownPlace(int myColor, int[] board){
		int value = 0,tmp = 0;
		int[] direction = {-11, -10, -9, -1, 1, 9, 10, 11};
		int yourColor;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		if(turnCount>47)return 0;
		else{
			for(int p=11;p<89;p++) {
				tmp = 0;
				if(0<p && p<100 && board[p]==0) {
					for(int i: direction) {
						if(board[p+i]==yourColor) {
							for(int j=2;j<8;j++) {
								if(board[p+i*j]==myColor) {
									tmp += j-1;
									break;
								} else if(board[p+i*j]==yourColor) {
								} else {
									break;
								}
							}
						}
					}
				}
				if(tmp>0) value++;
			}
			return value;
		}
	}
	private int getBoardScore(int myColor, int[] board, int repeat){
		int yourColor;
		int place = 0;
		int value = 0;
		int maxValue=-100;
		boolean pass = true;
		int tmpBoard[] = new int[100];
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		for(int p=0;p<100;p++) {
			System.arraycopy(board, 0, tmpBoard, 0, 100);
			if(reverse(myColor,tmpBoard,p)){
				if(repeat == 1){
					value = getBoardValue(myColor, tmpBoard)-getDropDownPlace(yourColor,tmpBoard)*2;
				}else{
					if(isPass(yourColor,tmpBoard)==false) {
						value = (-1)*getBoardScore(yourColor,tmpBoard,repeat-1);
					} else {
						if(isPass(myColor,tmpBoard)==false) {
							value = getBoardScore(myColor,tmpBoard,repeat-1);
						} else {
							value = getBoardValue(myColor, tmpBoard)-getDropDownPlace(yourColor,tmpBoard)*2;
						}
					}
				}
				if(maxValue < value)maxValue = value;
			}
		}
		return maxValue;
	}
	private boolean reverse(int myColor,int[] board,int p){
		int yourColor;
		boolean fg = false;

		if(myColor==PLAYER) yourColor = RIVAL;
		else yourColor  = PLAYER;
		if(board[p]==BLANK){
			for(int i : direction) {
				if(board[p+i]==yourColor) {
					for(int j=2;j<8;j++) {
						if(board[p+i*j]==myColor) {
							fg = true;
							for(int k=1;k<j;k++) {
								board[p+i*k] = myColor;
							}
							break;
						} else if(board[p+i*j]==yourColor) {
						} else {
							break;
						}
					}
				}
			}
		}
		if(fg)	board[p] = myColor;
		return fg;
	}
	private boolean isPass(int myColor,int[] board) {
		int yourColor;
		boolean pass = true;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		for(int p=0;p<100;p++) {
			if(0<p && p<100 && board[p]==0) {
				for(int i: direction) {
					if(board[p+i]==yourColor) {
						for(int j=2;j<8;j++) {
							if(board[p+i*j]==myColor) {
								pass = false;
								break;
							} else if(board[p+i*j]==yourColor) {
							} else {
								break;
							}
						}
					}
				}
			}
		}
		return pass;
	}
	public int count(int color) {
		int count = 0;
		for(int i=0;i<100;i++) {
			if(board[i]==color) count++;
		}
		return count;
	}

	public int count(int color, int[] board){
		int count = 0;
		for(int i=0;i<100;i++) {
			if(board[i]==color) count++;
		}
		return count;
	}
	@Override
	public void onClick(View v) {

	}

	private void startAnimation() {

		animation_cnt = 0;
		threadFlag = true;

		//各画像をリサイズ
		for (int i=0; i<12; i++) {
			turn_img[i] = Bitmap.createScaledBitmap(turn_img[i],size,size,true);
			turn_img_rev[i] = Bitmap.createScaledBitmap(turn_img_rev[i],size,size,true);
		}

		new Thread(this).start();
	}

	@Override
	public void run() {

		for (animation_cnt=0; animation_cnt<11; animation_cnt++) {

			mHandler.post(new Runnable(){
				@Override
				public void run(){

					for (int i=0; i<reverseList.size(); i++) {

						Rect rect;
						int place = 0;

						place = reverseList.get(i);
						rect = new Rect(size*(place%10),size*(place/10),size*(place%10)+size,size*(place/10)+size);
						invalidate(rect);
					}
				}
			});
			try {
				Thread.sleep(50);
			} catch (Exception e) {

			}

		}

		mHandler.post(new Runnable(){
			@Override
			public void run(){

				animation_cnt = -10;
				invalidate();

			}
		});

		return ;
	}

    public boolean getThreadStat() {

    	return threadFlag;
    }
}