package jp.ac.osaka_u.ist.sel.android.BluetoothReversi;

import java.util.ArrayList;
import java.util.Random;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;

@SuppressLint("ClickableViewAccessibility")
public class BoardViewPairCircle extends View implements Runnable {

	private Paint paint = new Paint();

	private int dispWidth;
	private int dispHeight;
	private int size;

	private Resources res = this.getContext().getResources();
    private Bitmap IMG_BOARD = BitmapFactory.decodeResource(res, R.drawable.nip_board);
    private Bitmap IMG_BLACK = BitmapFactory.decodeResource(res, R.drawable.reversi_black);
    private Bitmap IMG_WHITE = BitmapFactory.decodeResource(res, R.drawable.reversi_white);
    private Bitmap IMG_YELLOW = BitmapFactory.decodeResource(res, R.drawable.yellow);

    private final int BLANK = 0;
    private final int BLACK = 1;
    private final int WHITE = 2;
    private final int WALL = 3;

    private final int TITLE = 0;
    private int PLAYER = 1;
    private int RIVAL = 2;
    private final int TURN = 3;
    private final int REVERS = 4;
    private final int CONTROL = 5;
    private final int PASS = 6;
    private final int RESULT = 7;
    private final int WAIT = 8;
	private final int[] ARC = {13,14,15,16,27,38,48,58,68,77,86,85,84,83,72,61,51,41,31,22};
    private int[] board = new int[100];

    private int page = TITLE;
    private int turn;
    private int place;
	private int rivalPlace=0;
    private int[] placeMap = new int[100];
    private int[] direction = {-11, -10, -9, -1, 1, 9, 10, 11};

    private int playerStat = SERVER;
    private static int CLIENT = 0;
    private static int SERVER = 1;

    private BluetoothReversi ctx;

    private BluetoothReversiService btos;

	private Bitmap turn_img[] = {

			BitmapFactory.decodeResource(res,R.drawable.turn1),
			BitmapFactory.decodeResource(res,R.drawable.turn2),
			BitmapFactory.decodeResource(res,R.drawable.turn3),
			BitmapFactory.decodeResource(res,R.drawable.turn4),
			BitmapFactory.decodeResource(res,R.drawable.turn5),
			BitmapFactory.decodeResource(res,R.drawable.turn6),
			BitmapFactory.decodeResource(res,R.drawable.turn7),
			BitmapFactory.decodeResource(res,R.drawable.turn8),
			BitmapFactory.decodeResource(res,R.drawable.turn9),
			BitmapFactory.decodeResource(res,R.drawable.turn10),
			BitmapFactory.decodeResource(res,R.drawable.turn11),
			BitmapFactory.decodeResource(res,R.drawable.turn12)};


	private Bitmap turn_img_rev[] = {

			BitmapFactory.decodeResource(res,R.drawable.turn12),
			BitmapFactory.decodeResource(res,R.drawable.turn11),
			BitmapFactory.decodeResource(res,R.drawable.turn10),
			BitmapFactory.decodeResource(res,R.drawable.turn9),
			BitmapFactory.decodeResource(res,R.drawable.turn8),
			BitmapFactory.decodeResource(res,R.drawable.turn7),
			BitmapFactory.decodeResource(res,R.drawable.turn6),
			BitmapFactory.decodeResource(res,R.drawable.turn5),
			BitmapFactory.decodeResource(res,R.drawable.turn4),
			BitmapFactory.decodeResource(res,R.drawable.turn3),
			BitmapFactory.decodeResource(res,R.drawable.turn2),
			BitmapFactory.decodeResource(res,R.drawable.turn1)};

	private static int animation_cnt = -1;
	private Handler mHandler = new Handler();

	private boolean threadFlag = false;

	private ArrayList<Integer> reverseList = new ArrayList<Integer>();

	public BoardViewPairCircle(Context context) {

		super(context);


		Log.i("BoardView","constructor1");

		for(int i=11;i<=88;i++) board[i] = BLANK;
		for(int i=0;i<10;i++) board[i] = WALL;
		for(int i=1;i<9;i++) board[i*10] = WALL;
		for(int i=1;i<9;i++) board[i*10+9] = WALL;
		for(int i=0;i<10;i++) board[i+90] = WALL;
		board[11] = WALL;
		board[12] = WALL;
		board[17] = WALL;
		board[18] = WALL;
		board[21] = WALL;
		board[28] = WALL;
		board[71] = WALL;
		board[78] = WALL;
		board[81] = WALL;
		board[82] = WALL;
		board[87] = WALL;
		board[88] = WALL;
		board[44] = WHITE;
		board[45] = BLACK;
		board[54] = BLACK;
		board[55] = WHITE;

        ctx = (BluetoothReversi)context;
	}

	public BoardViewPairCircle(Context context,AttributeSet attrs) {

		super(context,attrs);

		Log.i("BoardView","constructor2");
		setFocusable(true);

		for(int i=11;i<=88;i++) board[i] = BLANK;
		for(int i=0;i<10;i++) board[i] = WALL;
		for(int i=1;i<9;i++) board[i*10] = WALL;
		for(int i=1;i<9;i++) board[i*10+9] = WALL;
		for(int i=0;i<10;i++) board[i+90] = WALL;
		board[11] = WALL;
		board[12] = WALL;
		board[17] = WALL;
		board[18] = WALL;
		board[21] = WALL;
		board[28] = WALL;
		board[71] = WALL;
		board[78] = WALL;
		board[81] = WALL;
		board[82] = WALL;
		board[87] = WALL;
		board[88] = WALL;
		board[44] = WHITE;
		board[45] = BLACK;
		board[54] = BLACK;
		board[55] = WHITE;

        ctx = (BluetoothReversi)context;
	}


	public void setBluetoothReversiService(BluetoothReversiService arg) {

		btos=arg;

		playerStat = btos.getPlayerStat();

		if (playerStat == SERVER) {

			 Random rnd = new Random();

		        int ran = rnd.nextInt(2)+1;

		        if (ran == BLACK) {

		        	page = TITLE;
		        	turn = PLAYER;

		        } else {

					page = TITLE;
					PLAYER = WHITE;
					RIVAL = BLACK;
					turn = RIVAL;
		        }

	            byte[] send = ("nip"+Integer.toString(ran)).getBytes();
	            btos.write(send);

		} else {

		}
/*
		if (playerStat == CLIENT) {

			page = WAIT;
			PLAYER = WHITE;
			RIVAL = BLACK;
			turn = RIVAL;
		} else {

			page = PLAYER;
			turn = PLAYER;
		}*/
	}

	public void setBluetoothReversiService(BluetoothReversiService arg,int ran) {

		btos=arg;

		playerStat = btos.getPlayerStat();


        if (ran == WHITE) {


        	page = TITLE;
        	turn = PLAYER;

        } else {

			page = TITLE;
			PLAYER = WHITE;
			RIVAL = BLACK;
			turn = RIVAL;
        }
	}

    @Override
    public void onDraw(Canvas c) {

		dispWidth = c.getWidth();
		dispHeight = c.getHeight();
		size = dispWidth/10;
		IMG_BOARD = Bitmap.createScaledBitmap(IMG_BOARD, dispWidth, dispWidth, true);
		IMG_BLACK = Bitmap.createScaledBitmap(IMG_BLACK, size, size, true);
		IMG_WHITE = Bitmap.createScaledBitmap(IMG_WHITE, size, size, true);
		IMG_YELLOW = Bitmap.createScaledBitmap(IMG_YELLOW, size, size, true);

		c.drawBitmap(IMG_BOARD, 0, 0, null);

		//アニメーションに関する処理
		if ((reverseList.size()!=0) && (animation_cnt>0)) {

			for (int j=0; j<reverseList.size(); j++) {

				int rp = reverseList.get(j);

				if (animation_cnt == 12) {

					break;
				}

				if (turn == PLAYER) {
					if (PLAYER == BLACK) {
						if(rp ==13 || rp == 16){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10)+size/4, null);
						}else if(rp ==31 || rp == 61){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10)+size/5, size*(rp/10), null);
						}else if(rp ==38 || rp == 68){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10)-size/5, size*(rp/10), null);
						}else if(rp ==83 || rp == 86){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10)-size/4, null);
						}else
		            	c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10), null);
					}else {
						if(rp ==13 || rp == 16){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10), size*(rp/10)+size/4, null);
						}else if(rp ==31 || rp == 61){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10)+size/5, size*(rp/10), null);
						}else if(rp ==38 || rp == 68){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10)-size/5, size*(rp/10), null);
						}else if(rp ==83 || rp == 86){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10), size*(rp/10)-size/4, null);
						}else
						c.drawBitmap(turn_img[animation_cnt],size*(rp%10),size*(rp/10), null);
					}
				} else {
					if (PLAYER == BLACK) {
						if(rp ==13 || rp == 16){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10), size*(rp/10)+size/4, null);
						}else if(rp ==31 || rp == 61){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10)+size/5, size*(rp/10), null);
						}else if(rp ==38 || rp == 68){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10)-size/5, size*(rp/10), null);
						}else if(rp ==83 || rp == 86){
							c.drawBitmap(turn_img[animation_cnt], size*(rp%10), size*(rp/10)-size/4, null);
						}else
						c.drawBitmap(turn_img[animation_cnt],size*(rp%10),size*(rp/10), null);
					} else {
						if(rp ==13 || rp == 16){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10)+size/4, null);
						}else if(rp ==31 || rp == 61){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10)+size/5, size*(rp/10), null);
						}else if(rp ==38 || rp == 68){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10)-size/5, size*(rp/10), null);
						}else if(rp ==83 || rp == 86){
							c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10)-size/4, null);
						}else
		            	c.drawBitmap(turn_img_rev[animation_cnt], size*(rp%10), size*(rp/10), null);					}
				}

			}

		} else if (animation_cnt == -10){

			for (int j=0; j<reverseList.size(); j++) {

				int rp = reverseList.get(j);

				if (turn == PLAYER) {
					if (PLAYER == BLACK) {
						board[rp] = BLACK;

					} else {
						board[rp] = WHITE;
					}
				} else {
					if (PLAYER == BLACK) {
						board[rp] = WHITE;

					} else {
						board[rp] = BLACK;
					}
				}
			}

			reverseList.clear();
			animation_cnt = -1;
			threadFlag = false;

		} else {

		}


    	for(int i=11;i<=88;i++) {
    		if(board[i]==BLACK){
				if(i ==13 || i == 16){
					c.drawBitmap(IMG_BLACK, size*(i%10), size*(i/10)+size/4, null);
				}else if(i ==31 || i == 61){
					c.drawBitmap(IMG_BLACK, size*(i%10)+size/5, size*(i/10), null);
				}else if(i ==38 || i == 68){
					c.drawBitmap(IMG_BLACK, size*(i%10)-size/5, size*(i/10), null);
				}else if(i ==83 || i == 86){
					c.drawBitmap(IMG_BLACK, size*(i%10), size*(i/10)-size/4, null);
				}else
            	c.drawBitmap(IMG_BLACK, size*(i%10), size*(i/10), null);
			}
			if(board[i]==WHITE){
				if(i ==13 || i == 16){
					c.drawBitmap(IMG_WHITE, size*(i%10), size*(i/10)+size/4, null);
				}else if(i ==31 || i == 61){
					c.drawBitmap(IMG_WHITE, size*(i%10)+size/5, size*(i/10), null);
				}else if(i ==38 || i == 68){
					c.drawBitmap(IMG_WHITE, size*(i%10)-size/5, size*(i/10), null);
				}else if(i ==83 || i == 86){
					c.drawBitmap(IMG_WHITE, size*(i%10), size*(i/10)-size/4, null);
				}else
            	c.drawBitmap(IMG_WHITE, size*(i%10), size*(i/10), null);
			}
		}


        switch(page) {

		case TITLE:
			//show player stone color and message
			//transitions with tap screen
			paint.setColor(Color.BLACK);
			paint.setTextSize(36);
			c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.3), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			if (PLAYER == BLACK)
				c.drawText("あなた", (float)(dispWidth*0.27), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			else
				c.drawText("あいて", (float)(dispWidth*0.29), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.6), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			if (PLAYER == BLACK)
				c.drawText("あいて", (float)(dispWidth*0.58), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			else c.drawText("あなた", (float)(dispWidth*0.56), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawText("画面をタップでゲーム開始",(float)(dispWidth*0.2), (float)(dispWidth*0.25),paint);

			break;

        case WAIT:
        	paint.setColor(Color.BLACK);
			paint.setTextSize(36);
			c.drawText("あいての番", (float)(dispWidth*0.15), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			if (PLAYER == BLACK) {
				c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			} else {
				c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			}
            break;
        case TURN:

            page = turn;
            invalidate();
            break;
        case BLACK:
        	makePlaceMap(PLAYER);
        	for(int i=11;i<=88;i++) {
        		if(placeMap[i]>0){
					if(i ==13 || i == 16){
						c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10)+size/4, null);
					}else if(i ==31 || i == 61){
						c.drawBitmap(IMG_YELLOW, size*(i%10)+size/5, size*(i/10), null);
					}else if(i ==38 || i == 68){
						c.drawBitmap(IMG_YELLOW, size*(i%10)-size/5, size*(i/10), null);
					}else if(i ==83 || i == 86){
						c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10)-size/4, null);
					}else
	            	c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10), null);
				}
            }

			paint.setColor(Color.BLACK);
			paint.setTextSize(36);
			c.drawText("あなたの番", (float)(dispWidth*0.15), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			rivalPlace = 0;

			if (PLAYER == BLACK) {
				c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			} else {
				c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			}
            break;

        case WHITE:
        	makePlaceMap(PLAYER);
        	for(int i=11;i<=88;i++) {
        		if(placeMap[i]>0){
					if(i ==13 || i == 16){
						c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10)+size/4, null);
					}else if(i ==31 || i == 61){
						c.drawBitmap(IMG_YELLOW, size*(i%10)+size/5, size*(i/10), null);
					}else if(i ==38 || i == 68){
						c.drawBitmap(IMG_YELLOW, size*(i%10)-size/5, size*(i/10), null);
					}else if(i ==83 || i == 86){
						c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10)-size/4, null);
					}else
	            	c.drawBitmap(IMG_YELLOW, size*(i%10), size*(i/10), null);
				}
            }

			paint.setColor(Color.BLACK);
			paint.setTextSize(36);
			c.drawText("あなたの番", (float)(dispWidth*0.15), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			if (PLAYER == BLACK) {
				c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			} else {
				c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			}
            break;

        case REVERS:
        	reverse(turn, place);

			//アニメーションに関する処理
			this.startAnimation();
			//アニメーションに関する処理

			page = CONTROL;
			invalidate(new Rect(size*(place%10),size*(place/10),size*(place%10)+size,size*(place/10)+size));
            break;
        case CONTROL:

        	if (threadFlag) break;

            if(turn==PLAYER) {

    			//btcs.write()で送信
    			byte[] send = Integer.toString(place).getBytes();
    			btos.write(send);

            	turn = RIVAL;
            	page = WAIT;
            } else {
            	turn = PLAYER;
            	page = PLAYER;
            }

            if(makePlaceMap(PLAYER)==true && makePlaceMap(RIVAL)==true) page = RESULT;
            else if(makePlaceMap(turn)==true) page = PASS;

            invalidate();
            break;
        case PASS:

        	Toast.makeText(ctx,"pass",Toast.LENGTH_SHORT).show();

            if(turn==PLAYER) {
            	turn = RIVAL;
            	page = WAIT;
            }
            else {
            	turn = PLAYER;
            	page = PLAYER;
            }
            rivalPlace = 0;
            invalidate();
            break;
        case RESULT:
        	paint.setColor(Color.BLACK);
			paint.setTextSize(36);

			c.drawBitmap(IMG_BLACK,(float)(dispWidth*0.2), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			c.drawText(String.valueOf(count(BLACK)), (float)(dispWidth*0.25), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);

			c.drawBitmap(IMG_WHITE,(float)(dispWidth*0.5), (float)(dispWidth+(dispHeight-dispWidth)*0.25), null);
			c.drawText(String.valueOf(count(WHITE)), (float)(dispWidth*0.55), (float)(dispWidth+(dispHeight-dispWidth)*0.25), paint);
			if(count(PLAYER)==count(RIVAL)){
				c.drawText("引き分けです", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);
				if(playerStat==SERVER){
					AlertDialog.Builder alertDlg = new AlertDialog.Builder(ctx);
	                alertDlg.setCancelable(false);
	                alertDlg.setMessage("再戦しますか？");
	                alertDlg.setPositiveButton(
	                    "はい",
	                    new DialogInterface.OnClickListener() {
	                        public void onClick(DialogInterface dialog, int which) {
	                            //when pushed "Yes" button

	                        	restart();
	                        }
	                    });
	                alertDlg.setNegativeButton(
	                    "いいえ",
	                    new DialogInterface.OnClickListener() {
	                        public void onClick(DialogInterface dialog, int which) {
	                            //when pushed "No" button
	                        	btos.stop();
	    						ctx.setRecreateFlag(true);
	    						ctx.recreate();
	                        }
	                    });

	                //show dialog
	                alertDlg.create().show();
				}
			}else
        	if(count(PLAYER)>count(RIVAL)){
        		c.drawText("あなたの勝ち!", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);
        	}
        	else{
        		c.drawText("あなたの負け!", (float)(dispWidth*0.1), (float)(dispWidth+(dispHeight-dispWidth)*0.1), paint);

                AlertDialog.Builder alertDlg = new AlertDialog.Builder(ctx);
                alertDlg.setCancelable(false);
                alertDlg.setMessage("再戦しますか？");
                alertDlg.setPositiveButton(
                    "はい",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            //when pushed "Yes" button

                        	restart();
                        }
                    });
                alertDlg.setNegativeButton(
                    "いいえ",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int which) {
                            //when pushed "No" button
                        	btos.stop();
    						ctx.setRecreateFlag(true);
    						ctx.recreate();
                        }
                    });

                //show dialog
                alertDlg.create().show();
        	}

            break;
        }
    }

    public void restart() {


    	for(int i=11;i<=88;i++) board[i] = BLANK;
		for(int i=0;i<10;i++) board[i] = WALL;
		for(int i=1;i<9;i++) board[i*10] = WALL;
		for(int i=1;i<9;i++) board[i*10+9] = WALL;
		for(int i=0;i<10;i++) board[i+90] = WALL;
		board[11] = WALL;
		board[12] = WALL;
		board[17] = WALL;
		board[18] = WALL;
		board[21] = WALL;
		board[28] = WALL;
		board[71] = WALL;
		board[78] = WALL;
		board[81] = WALL;
		board[82] = WALL;
		board[87] = WALL;
		board[88] = WALL;
		board[44] = WHITE;
		board[45] = BLACK;
		board[54] = BLACK;
		board[55] = WHITE;



		 Random rnd = new Random();

		        int ran = rnd.nextInt(2)+1;

		        if (ran == BLACK) {

		        	PLAYER = BLACK;
		        	RIVAL = WHITE;
		        	page = TITLE;
		        	turn = PLAYER;


		        } else {

					page = TITLE;
					PLAYER = WHITE;
					RIVAL = BLACK;
					turn = RIVAL;
		        }

	            byte[] send = ("restart"+Integer.toString(ran)).getBytes();
	            btos.write(send);
	            invalidate();
    }

    public void restart(int ran) {

    	for(int i=11;i<=88;i++) board[i] = BLANK;
        for(int i=0;i<10;i++) board[i] = WALL;
        for(int i=1;i<9;i++) board[i*10] = WALL;
        for(int i=1;i<9;i++) board[i*10+9] = WALL;
        for(int i=0;i<10;i++) board[i+90] = WALL;
        board[44] = WHITE;
        board[45] = BLACK;
        board[54] = BLACK;
        board[55] = WHITE;

        if (ran == WHITE) {

        	PLAYER = BLACK;
        	RIVAL = WHITE;
        	page = TITLE;
        	turn = PLAYER;


        } else {

			page = TITLE;
			PLAYER = WHITE;
			RIVAL = BLACK;
			turn = RIVAL;
        }
        invalidate();
    }

    public boolean onTouchEvent(MotionEvent me) {

    	int padX = (int)(me.getX()/size);
        int padY = (int)(me.getY()/size);
    	if(me.getAction()==MotionEvent.ACTION_DOWN) {
            switch(page) {
			case TITLE:

				if (PLAYER == BLACK) {
					page = PLAYER;

				} else {
					page = WAIT;
				}

				invalidate();
				break;


            case WAIT:

                break;
            case BLACK:
            	if(padX+padY*10<100){
            		if(placeMap[padX+padY*10]>0) {
            			place = padX+padY*10;
            			page = REVERS;
            			/*
            			//btcs.write()で送信
                        byte[] send = Integer.toString(place).getBytes();
                        btos.write(send);
                        */
                    	rivalPlace = 0;
            		}
            		invalidate();
            	}
                break;
            case WHITE:
            	if(padX+padY*10<100){
            		if(placeMap[padX+padY*10]>0) {
            			place = padX+padY*10;
            			page = REVERS;

            	/*
    			//btcs.write()で送信
            	byte[] send =Integer.toString(place).getBytes();
                btos.write(send);
                */

            			rivalPlace = 0;
            		}
            		invalidate();
            	}
                break;
            case PASS:

                break;
            case RESULT:

                break;
            }
        }
        return true;
    }

    public void setPlaeAfterRead(String readMessage) {

        place = Integer.valueOf(readMessage);
        rivalPlace = place;
        if (place == 100) {

        	page = CONTROL;

        	invalidate();
        } else if (place == 200) {

        	page = RESULT;
        	invalidate();

        } else {
        	page = REVERS;
        	invalidate();
        }
    }


    void reverse(int myColor, int p) {//驕擾ｽｳ郢ｧ蛛ｵ�ｽ�ｲ邵ｺ�｣邵ｺ荳奇ｽ企恆譁絶�
		int yourColor = PLAYER;
		if(myColor==PLAYER) yourColor = RIVAL;
		if(p<board.length){
			board[p] = myColor;
			for(int i : direction) {
				if(!((((p / 10 == 1) || (p/10 ==8)) && (i == 1 || i ==-1))
						|| ((p == 13 || p == 22 || p == 31 || p == 86 || p == 77 || p == 68) && (i == 9 || i == -9))
						|| ((p == 83 || p == 72 || p == 61 || p == 16 || p == 27 || p == 38) && (i == 11 || i == -11))
						|| (((p % 10 == 1) || (p % 10 == 8)) && (i == 10 || i == -10))
						)){
					if(board[p+i]==yourColor) {
						for(int j=2;j<8;j++) {
							if(board[p+i*j]==myColor) {
								for(int k=1;k<j;k++) {


									//board[p+i*k] = myColor;

									board[p+i*k] = BLANK;

									//store reverse cell data to ArrayList
									reverseList.add(p+i*k);

								}
								break;
							} else if(board[p+i*j]==yourColor) {
							} else {
								break;
							}
						}
					}
				}
			}
			int index = 0;
			int count = 0;
			int start = -1;
			int dir = 1;
			for (int i = 0; i< ARC.length; i++){
				if( ARC[i] == p){
					index = i;
					start = i;
				}
			}
			if(start != -1){
				if(index == ARC.length-1){
					index = -1;
				}
				if(board[ARC[index+dir]]==yourColor){
					index +=dir;
					count++;
					while (true){
						if(index == ARC.length-1){
							index = -1;
						}
						if(board[ARC[index+dir]]==myColor) {
							if(index+dir == start){
								break;
							}
							index = start;
							for(int k=1;k<=count;k++) {
								index += dir;
								if(index == ARC.length){
									index = 0;
								}


								//board[ARC[index]] = myColor;
								board[ARC[index]] = BLANK;

								//store reverse cell data to ArrayList
								reverseList.add(ARC[index]);


							}
							break;
						} else if(board[ARC[index+dir]]==yourColor) {
							if(index+dir == start){
								break;
							}
							index+=dir;
							count++;
						} else {
							break;
						}
					}
				}
				dir = -1;
				count = 0;
				index = start;
				if(index == 0){
					index = ARC.length;
				}
				if(board[ARC[index+dir]]==yourColor){
					index +=dir;
					count++;
					while (true){
						if(index == 0){
							index = ARC.length;
						}
						if(board[ARC[index+dir]]==myColor) {
							if(index+dir == start){
								break;
							}
							index = start;
							for(int k=1;k<=count;k++) {
								index +=dir;
								if(index == -1){
									index = ARC.length-1;;
								}


								//board[ARC[index]] = myColor;

								board[ARC[index]] = BLANK;

								//store reverse cell data to ArrayList
								reverseList.add(ARC[index]);

							}
							break;
						} else if(board[ARC[index+dir]]==yourColor) {
							if(index+dir == start){
								break;
							}
							index+=dir;
							count++;
						} else {
							break;
						}
					}
				}
			}

		}
	}

    public boolean makePlaceMap(int myColor) {//驗ゑｽｮ邵ｺ莉｣�玖撻�ｴ隰�ｿｽ邵ｺ�ｮ陋ｻ�､陞ｳ�ｽ
		int yourColor;
		boolean pass = true;
		if(myColor==BLACK) yourColor = WHITE;
		else yourColor = BLACK;
		for(int p=0;p<100;p++) {
			placeMap[p] = 0;
			if(0<p && p<100 && board[p]==0) {
				for(int i: direction) {
					if(!((((p / 10 == 1) || (p/10 ==8)) && (i == 1 || i ==-1))
							|| ((p == 13 || p == 22 || p == 31 || p == 86 || p == 77 || p == 68) && (i == 9 || i == -9))
							|| ((p == 83 || p == 72 || p == 61 || p == 16 || p == 27 || p == 38) && (i == 11 || i == -11))
							|| (((p % 10 == 1) || (p % 10 == 8)) && (i == 10 || i == -10))
							)){
						if(board[p+i]==yourColor) {
							for(int j=2;j<8;j++) {
								if(board[p+i*j]==myColor) {
									placeMap[p] += j-1;
									pass = false;
									break;
								} else if(board[p+i*j]==yourColor) {
								} else {
									break;
								}
							}
						}
					}
				}
				int index = -1;
				int count = 0;
				int start = -1;
				int dir = 1;
				for (int i = 0; i< ARC.length; i++){
					if( ARC[i] == p){
						index = i;
						start = i;
					}
				}
				if(start !=-1){
					if(index == ARC.length-1){
						index = -1;
					}
					if(board[ARC[index+dir]]==yourColor){
						index +=dir;
						count++;
						while (true){
							if(index == ARC.length-1){
								index = -1;
							}
							if(board[ARC[index+dir]]==myColor) {
								if(index+dir == start){
									break;
								}
								placeMap[p] += count;
								pass = false;
								break;
							} else if(board[ARC[index+dir]]==yourColor) {
								if(index+dir == start){
									break;
								}
								index+=dir;
								count++;
							} else {
								break;
							}
						}
					}
					dir = -1;
					count = 0;
					index = start;
					if(index == 0){
						index = ARC.length;
					}
					if(board[ARC[index+dir]]==yourColor){
						index +=dir;
						count++;
						while (true){
							if(index == 0){
								index = ARC.length;
							}
							if(board[ARC[index+dir]]==myColor) {
								if(index+dir == start){
									break;
								}
								placeMap[p] += count;
								pass = false;
								break;
							} else if(board[ARC[index+dir]]==yourColor) {
								if(index+dir == start){
									break;
								}
								index+=dir;
								count++;
							} else {
								break;
							}
						}
					}
				}
			}
		}
		return pass;
	}


    public int count(int color) {
    	int count = 0;
        	for(int i=0;i<100;i++) {
        		if(board[i]==color) count++;
        	}
    	return count;
    }

	private void startAnimation() {

		animation_cnt = 0;
		threadFlag = true;

		//各画像をリサイズ
		for (int i=0; i<12; i++) {
			turn_img[i] = Bitmap.createScaledBitmap(turn_img[i],size,size,true);
			turn_img_rev[i] = Bitmap.createScaledBitmap(turn_img_rev[i],size,size,true);
		}

		new Thread(this).start();
	}

	@Override
	public void run() {

		for (animation_cnt=0; animation_cnt<11; animation_cnt++) {

			mHandler.post(new Runnable(){
				@Override
				public void run(){

					for (int i=0; i<reverseList.size(); i++) {

						Rect rect;
						int place = 0;

						place = reverseList.get(i);
						if(place ==13 || place == 16){
							rect = new Rect(size*(place%10),size*(place/10)+size/4,size*(place%10)+size,size*(place/10)+(size*5/4));
						}else if(place ==31 || place == 61){
							rect = new Rect(size*(place%10)+size/5,size*(place/10),size*(place%10)+(size*6/5),size*(place/10)+size);
						}else if(place ==38 || place == 68){
							rect = new Rect(size*(place%10)-size/5,size*(place/10),size*(place%10)+(size*4/5),size*(place/10)+size);
						}else if(place ==83 || place == 86){
							rect = new Rect(size*(place%10),size*(place/10)-size/4,size*(place%10)+size,size*(place/10)+(size*3/4));
						}else
						rect = new Rect(size*(place%10),size*(place/10),size*(place%10)+size,size*(place/10)+size);
						invalidate(rect);
					}
				}
			});
			try {
				Thread.sleep(50);
			} catch (Exception e) {

			}

		}

		mHandler.post(new Runnable(){
			@Override
			public void run(){

				animation_cnt = -10;
				invalidate();

			}
		});

		return ;
	}

    public boolean getThreadStat() {

    	return threadFlag;
    }
}