package com.example.snaketest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

public class MainActivity extends ActionBarActivity implements OnClickListener{

	private MainActivity activity;
	private int rotation;
	private int inputMode;
	private SnakeSurfaceView sv;
	private Button stop;
	private final int MP = ViewGroup.LayoutParams.MATCH_PARENT;
	private final int WC = ViewGroup.LayoutParams.WRAP_CONTENT;
	RelativeLayout snakeLayout;
	TableLayout scoreLayout;
	RelativeLayout layout;
	private final int rankNum = 7;
	private int state = MyDefinitions.MAIN;

	private Typeface tf;
	private	String rankPath;
	private int gameMode = MyDefinitions.LENGTH_MODE;
	private int dispWidth;
	private int dispHeight;


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		requestWindowFeature(Window.FEATURE_NO_TITLE);
		activity = this;
		rankPath = "/data/data/" + this.getPackageName() + "/files/";
		//Log.e("oncreate","oncreate main activity");

		setContentView(R.layout.activity_main);

		makeMain();

	}

	private void startGame(int dispHeight){

		snakeLayout = new RelativeLayout(activity);
		setContentView(snakeLayout);
		sv = new SnakeSurfaceView(activity);
		RelativeLayout.LayoutParams svParam = new RelativeLayout.LayoutParams(MP, MP);
		sv.setId(1);
		snakeLayout.addView(sv, svParam);
		ActionButton(dispHeight, snakeLayout);
	}

	private void ActionButton(final int dispHeight,
			RelativeLayout relativeLayout) {
		//stop
		stop = new Button(activity);
		stop.setTypeface(tf);
		stop.setText("STOP");
		stop.setBackgroundResource(R.drawable.action_button_stop);

		RelativeLayout.LayoutParams stopParam = new RelativeLayout.LayoutParams(MP, dispHeight /14);
		//stopParam.setMargins(dispWidth / 10, dispHeight * 7 / 11, 0, 0);// (左, 上, 右, 下)
		stopParam.addRule(RelativeLayout.ALIGN_BOTTOM, 1);
		relativeLayout.addView(stop, stopParam);
		stop.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				if(sv.getCb().getDialogueStuck().peek() == MyDefinitions.COWNT_DOWN){
					return;
				}
				sv.getCb().pushButton();
				if(sv.getCb().getDialogueStuck().peek() == MyDefinitions.STOP){
					stop.setText("RESTART");
					stop.setBackgroundResource(R.drawable.action_button_restart);
				}else if(sv.getCb().getDialogueStuck().peek() == MyDefinitions.NO_ASK){
					stop.setText("STOP");
					stop.setBackgroundResource(R.drawable.action_button_stop);
				}
			}
		});
	}

	private void showHighScore(View v){
		v.setBackgroundColor(Color.argb(255,193, 255, 193));
		layout = new RelativeLayout(activity);
		setContentView(layout);

		TextView textA = new TextView(activity);
		textA.setText("Type_A");
		textA.setTypeface(tf);

		Paint textpaint = new Paint();
		String string = "Type A";
		int size =50;
		textpaint.setTextSize(size);
		textpaint.setTypeface(tf);
		float scale = activity.getResources().getDisplayMetrics().density;
		while(textpaint.measureText(string) > dispWidth/scale / 4){
			textpaint.setTextSize(size--);
		}
		textA.setTextSize(size);
		int w = (int) textpaint.measureText(string);
		textA.setTranslationX(dispWidth/2 - w/2);
		textA.setTextColor(Color.argb(255,255, 69, 0));

		layout.addView(textA,new LinearLayout.LayoutParams(WC,WC));

		TableLayout tableA =showRanking("lengthModeRank.txt",0,v);
		layout.addView(tableA,new LinearLayout.LayoutParams(MP,WC));

		TextView textB = new TextView(activity);
		textB.setText("Type_B");
		textB.setTypeface(tf);
		textB.setTranslationX(dispWidth/2 - w/2);
		textB.setTranslationY(dispHeight/2);
		textB.setTextSize(size);
		layout.addView(textB,new LinearLayout.LayoutParams(WC,WC));
		textB.setTextColor(Color.argb(255,0, 100, 0));
		TableLayout tableB =showRanking("scoreModeRank.txt",dispHeight/2,v);
		layout.addView(tableB,new LinearLayout.LayoutParams(MP,WC));
	}

	public TableLayout showRanking(String filename , int fromY, View v) {

		scoreLayout = new TableLayout(activity);
		scoreLayout.setColumnStretchable(0, true);
		scoreLayout.setColumnStretchable(5, true);

		scoreLayout.setTranslationY(fromY);
		int[] position = new int[2];
		scoreLayout.getLocationInWindow(position);
		Log.i("locationX",String.valueOf(position[0]));
		Log.i("locationY",String.valueOf(position[1]));

		Paint textpaint = new Paint();
		String st[] = {" RANK "," SCORE "," LENGTH ","   DATE"};
		String string = st[0] + st[1] + st[2] + "2014/12/17";

		int size =50;
		textpaint.setTextSize(size);
		textpaint.setTypeface(tf);
		float scale = activity.getResources().getDisplayMetrics().density;
		while(textpaint.measureText(string) > dispWidth*7/8/scale){
			textpaint.setTextSize(size--);
		}

		for(int i = 0 ; i < 3; i++){//for creating blank
			TableRow t= new TableRow(activity);
			TextView text = new TextView(activity);
			text.setText(" ");
			t.addView(text);
			scoreLayout.addView(t, createParam(MP, WC));
		}

		TableRow tableRow1 = new TableRow(activity);
		TextView text10 = new TextView(activity);
		text10.setText(" ");
		tableRow1.addView(text10);

		for(int i = 0 ; i < 4 ; i++){
			TextView text = new TextView(activity);
			text.setText(st[i]);
			text.setTypeface(tf);
			text.setTextSize(size);
			tableRow1.addView(text);
		}
		TextView text15 = new TextView(activity);
		text15.setText(" ");
		tableRow1.addView(text15);

		scoreLayout.addView(tableRow1, createParam(MP, WC));


		FileInputStream fis;
		try {
			fis = activity.openFileInput(filename);
			InputStreamReader isr = new InputStreamReader(fis);
			BufferedReader br = new BufferedReader(isr);

			String s;
			int ranking = 1;
			int count = 0;
			while((s= br.readLine()) != null && count < rankNum){
				count++;
				String[] item = s.split(",");
				TableRow tableRow2 = new TableRow(activity);

				TextView text20 = new TextView(activity);
				tableRow2.addView(text20);

				for(int i = 0 ; i < 4 ; i++){
					TextView text = new TextView(activity);
					if(i == 0){
						text.setText(String.valueOf(ranking++));
					}else{
						text.setText(item[i-1]);
					}
					text.setGravity(Gravity.CENTER);
					text.setTypeface(tf);
					text.setTextSize(size);
					tableRow2.addView(text);

				}
				scoreLayout.addView(tableRow2, createParam(MP, WC));
			}

			br.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return scoreLayout;
	}

	public void rewriteRanking(int score,int length,String date){
		File newfile = new File(rankPath+returnRankingFilename());
		try {
			if(newfile.createNewFile()){
				//Log.i("hoge","new create");
			}else{
				//Log.i("hoge","already exist");
			}
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		BufferedReader br = null;

		try {
			FileInputStream fis = activity.openFileInput(returnRankingFilename());
			InputStreamReader isr = new InputStreamReader(fis);
			br = new BufferedReader(isr);
		} catch (FileNotFoundException e3) {
			e3.printStackTrace();
		}

		String s = null;
		String[][] item = new String[rankNum][3];

		int count = 0;
		try {
			while((s= br.readLine()) != null && count < rankNum){
				item[count]= s.split(",");
				//Log.i("ranking",String.valueOf(count)+":"+ item[count][0]+","+item[count][1]+","+item[count][2]);
				count++;
			}
		} catch (IOException e3) {
			e3.printStackTrace();
		}
		for(int k = 0 ; k < rankNum; k++){
			if( item[k][0] == null || item[k][0].equals("null") || item[k][0].length() == 0){
				item[k][0] = "0";
			}
		}
		String[][] output = new String[rankNum][3];
		boolean flag = true;
		for(int j = 0 ; j < count ; j++){
			if(score >= Integer.parseInt(item[j][0])){
				output[j][0] = String.valueOf(score);
				output[j][1] = String.valueOf(length);
				output[j][2] = date;
				if(count == rankNum){
					for(int k = j+1 ; k < count ; k++){
						output[k] = item[k-1];
					}
				}else{
					count++;
					for(int k = j+1 ; k < count ; k++){
						output[k] = item[k-1];
					}
				}
				flag = false;
				break;
			}else{
				output[j] = item[j];
			}
		}
		if(count < rankNum && flag){
			output[count][0] = String.valueOf(score);
			output[count][1] = String.valueOf(length);
			output[count][2] = date;
			count++;
		}
		OutputStream out = null;

		try {
			out = activity.openFileOutput(returnRankingFilename(), MODE_PRIVATE);
		} catch (FileNotFoundException e2) {
			e2.printStackTrace();
		}

		PrintWriter writer;
		String crlf = System.getProperty("line.separator");
		try {
			writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
			for(int j = 0 ; j < count ; j++){
				for(int k = 0 ; k < 3 ; k++){
					if(k != 2){
						writer.append(output[j][k]+",");
					}else{
						writer.append(output[j][k]);
					}
				}
				writer.append(crlf);
			}
			writer.close();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
	}

	private TableLayout.LayoutParams createParam(int w, int h){
		return new TableLayout.LayoutParams(w, h);
	}


	@Override
	protected void onUserLeaveHint() {//バックグラウンド移行時に呼ばれる
		super.onUserLeaveHint();
		if(state == MyDefinitions.SNAKE){
			if(sv.getCb().getDialogueStuck().peek() == MyDefinitions.NO_ASK){
				stop.setText("RESTART");
				sv.getCb().pushButton();
				Log.w("onUserLeaveHint", "");
			}else if(sv.getCb().getDialogueStuck().peek() == MyDefinitions.COWNT_DOWN){
				Log.w("onUserLeaveHint", "aaaaaaaaaa");
				sv.getCb().stopCD();
			}
		}
	}

	@Override
	public void onResume(){
		super.onResume();
		switch(state){
		case MyDefinitions.SNAKE :
			setContentView(snakeLayout);
			Log.i("aaa", "aaaaaa");
			break;
			/*case MyDefinitions.MAIN :
			setContentView(R.layout.activity_main);
			break;*/
		case MyDefinitions.SCORE :
			setContentView(layout);
			break;
		default:
			break;
		}
	}

	@Override
	public void onPause(){
		super.onPause();
		Log.e("puase","pause main activity");

	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if(keyCode == KeyEvent.KEYCODE_BACK){
			switch(state){
			case MyDefinitions.SNAKE :
				//Log.e("back","back key down");
				sv.getCb().askExit();
				break;
			case MyDefinitions.MAIN :
				activity.finish();
				break;
			case MyDefinitions.SCORE:
				state = MyDefinitions.MAIN;
				setContentView(R.layout.activity_main);
				makeMain();
				break;
			case MyDefinitions.WAIT:
				break;
			default:
				break;
			}
			return true;
		}
		return false;
	}

	public void gameBack(boolean exitResult){
		if(exitResult){
			state = MyDefinitions.MAIN;
			setContentView(R.layout.activity_main);
			makeMain();
		}
	}

	private void makeMain(){
		//画面サイズの取得
		WindowManager wm = (WindowManager) getSystemService(this.WINDOW_SERVICE);
		Display display = wm.getDefaultDisplay();
		dispWidth = display.getWidth();
		dispHeight =  display.getHeight();

		//Log.e("oncreate","oncreate main activity");


		// 無操作で暗くなるのを防ぐ
		Window window = getWindow();
		window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
		rotation = window.getWindowManager().getDefaultDisplay().getRotation();
		setRotation(rotation);
		//typeface create
		tf = Typeface.createFromAsset(getAssets(), "fonts/molot.ttf");
		setTf(tf);

		TextView titleSnake = (TextView)findViewById(R.id.textView5);
		TextView titleGame = (TextView)findViewById(R.id.textView6);

		Button ButtonPlay = (Button)findViewById(R.id.button1);
		Button ButtonHighScore = (Button)findViewById(R.id.button3);

		ButtonPlay.setTypeface(tf);
		ButtonHighScore.setTypeface(tf);

		TextView titleGameMode = (TextView)findViewById(R.id.textView7);
		TextView titleInputMode = (TextView)findViewById(R.id.textView8);
		titleGameMode.setTypeface(tf);
		titleInputMode.setTypeface(tf);

		Paint textpaint = new Paint();
		String string = "SNAKE ";
		textpaint.setTypeface(tf);
		int size =500;
		textpaint.setTextSize(size);
		float scale = activity.getResources().getDisplayMetrics().density;
		while(textpaint.measureText(string) > dispWidth/scale){
			textpaint.setTextSize(size--);
		}
		titleSnake.setTypeface(tf);
		titleSnake.setTextColor(Color.RED);
		titleSnake.setTextSize(size);

		titleGame.setTypeface(tf);
		titleGame.setTextSize(size);
		titleGame.setTextColor(Color.GREEN);

		LinearLayout titleLayout= (LinearLayout) findViewById(R.id.titleLayout);
		titleLayout.setTranslationY(dispHeight * 1 / 20);

		LinearLayout spinnerLayout = (LinearLayout) findViewById(R.id.spinner);
		spinnerLayout.setTranslationY(dispHeight * 11 / 20);

		LinearLayout play = (LinearLayout) findViewById(R.id.play);
		play.setTranslationY(dispHeight * 7 / 10);

		LinearLayout score = (LinearLayout) findViewById(R.id.score);
		score.setTranslationY(dispHeight * 8 / 10);

		Spinner spinner = (Spinner) findViewById(R.id.spinner1);
		spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){
			@Override
			public void onItemSelected(AdapterView<?> arg0, View arg1,int arg2, long arg3) {
				String spinner = (String) arg0.getSelectedItem();
				if(spinner.equals("TypeA")){
					setGameMode(MyDefinitions.LENGTH_MODE);
				}else if(spinner.equals("TypeB")){
					setGameMode(MyDefinitions.SCORE_MODE);
				}
			}
			@Override
			public void onNothingSelected(AdapterView<?> arg0) {

			}
		});

		Spinner spinner2 = (Spinner) findViewById(R.id.spinnerInput);
		spinner2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){
			@Override
			public void onItemSelected(AdapterView<?> arg0, View arg1,int arg2, long arg3) {
				String spinner = (String) arg0.getSelectedItem();
				if(spinner.equals("Flick")){
					setInputMode(MyDefinitions.FLICK);
				}else if(spinner.equals("Sensor")){
					setInputMode(MyDefinitions.SENSOR);
				}
			}
			@Override
			public void onNothingSelected(AdapterView<?> arg0) {

			}
		});

		sv = new SnakeSurfaceView(activity);

		ButtonPlay.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				state = MyDefinitions.SNAKE;
				startGame(dispHeight);
			}
		});

		ButtonHighScore.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				state = MyDefinitions.SCORE;
				showHighScore(v);
			}
		});
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	public void writeScore(int score){
		OutputStream out = null;

		try {
			out = openFileOutput(returnBestFilename(), MODE_PRIVATE);
		} catch (FileNotFoundException e2) {
			try {
				File newfile = new File(returnBestFilename());
				newfile.createNewFile();
				out = openFileOutput(returnBestFilename(), MODE_PRIVATE);
			} catch (IOException e1) {
				e1.printStackTrace();
			}
		}
		PrintWriter writer;
		try {
			writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
			writer.append(String.valueOf(score));
			writer.close();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}


	}

	public int readBestScore(){
		try {
			FileInputStream fis = this.openFileInput(returnBestFilename());

			InputStreamReader isr = new InputStreamReader(fis);
			BufferedReader br = new BufferedReader(isr);
			String s = br.readLine();
			br.close();
			if(s.equals(null)){
				return 0;
			}else{
				return Integer.parseInt(s);
			}
		} catch (FileNotFoundException e) {
			return 0;
		} catch (IOException e) {
			return 0;
		}

	}

	private String returnRankingFilename(){
		if(gameMode == MyDefinitions.SCORE_MODE){
			return "scoreModeRank.txt";
		}else if(gameMode == MyDefinitions.LENGTH_MODE){
			return "lengthModeRank.txt";
		}else
			return "lengthModeRank.txt";
	}

	private String returnBestFilename(){
		if(gameMode == MyDefinitions.SCORE_MODE){
			return "scoreModeBestScore.txt";
		}else if(gameMode == MyDefinitions.LENGTH_MODE){
			return "lengthModeBestScore.txt";
		}else
			return "lengthModeBestScore.txt";
	}

	@Override
	protected void onStop() {
		super.onStop();
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		//		 as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}


	public int getRotation() {
		return rotation;
	}

	public void setRotation(int rotation) {
		this.rotation = rotation;
	}

	public Typeface getTf() {
		return tf;
	}

	public void setTf(Typeface tf) {
		this.tf = tf;
	}

	public int getInputMode() {
		return inputMode;
	}

	public void setInputMode(int inputMode) {
		this.inputMode = inputMode;
	}

	public int getGameMode() {
		return gameMode;
	}

	public void setGameMode(int gameMode) {
		this.gameMode = gameMode;
	}

	@Override
	public void onClick(DialogInterface arg0, int arg1) {
		// TODO 自動生成されたメソッド・スタブ

	}

}
