package com.example.snaketest;

import java.util.Random;

import android.graphics.Paint;

public class Food {
	private int X,Y;
	private Paint paint;
	private int score;

	public Food(int horizontalCellNum, int verticalCellNum) {
		super();
		Random r = new Random();
		this.setX(r.nextInt(horizontalCellNum));
		this.setY(r.nextInt(verticalCellNum));

		paint = new Paint();
		paint.setAntiAlias(true);
	}

	public void setScoreModeColors(int count) {
		paint.setColor(MyDefinitions.returnBColor(count));
		this.score = 5*(count+1);
	}

	public void setLengthModeColors() {
		paint.setColor(MyDefinitions.returnAColor());
		this.score = 10;
	}

	public int getX() {
		return X;
	}

	public void setX(int x) {
		X = x;
	}

	public int getY() {
		return Y;
	}

	public void setY(int y) {
		Y = y;
	}

	public Paint getPaint() {
		return paint;
	}

	public int getColor() {
		return paint.getColor();
	}

	public void setPaint(Paint paint) {
		this.paint = paint;
	}

	public int getScore() {
		return score;
	}


}
