package com.example.snaketest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;

import android.graphics.Canvas;
import android.graphics.Paint;

public class FoodSet {
	private HashSet<Food> foodset;
	private int foodSetNum;
	private LinkedList<SnakeBlock> blocks;
	Food food;
	int gameMode;

	public FoodSet(int foodSetNum , LinkedList<SnakeBlock> blocks
			, int horizontalCellNum ,int verticalCellNum,int gameMode) {
		setFoodset(new HashSet<Food>());
		setFoodSetNum(foodSetNum);
		setBlocks(blocks);
		setGameMode(gameMode);

		foodset = new HashSet<Food>();
		if(foodSetNum > horizontalCellNum*verticalCellNum-blocks.size()){
			setFoodSetNum(horizontalCellNum*verticalCellNum-blocks.size());
		}

		int foodCount = 0;
		while(foodCount < foodSetNum){
			if(gameMode == MyDefinitions.SCORE_MODE){
				Random r = new Random();
				int i = r.nextInt(7);
				food = new FoodOfScoreMode(horizontalCellNum, verticalCellNum,i);
			}else if(gameMode == MyDefinitions.LENGTH_MODE){
				food = new FoodOfLengthMode(horizontalCellNum, verticalCellNum);
			}
			if(canGenerate(food.getX(), food.getY(),food.getColor())){
				foodset.add(food);
				foodCount++;
			}else{
				continue;
			}
		}
	}

	private boolean canGenerate(int x , int y , int color){
		for(SnakeBlock block : blocks){
			if(block.getX() == x && block.getY() == y){
				return false;
			}
		}
		for(Food food : foodset){
			if(food.getX() == x && food.getY() == y){
				return false;
			}
		}
		if(gameMode == MyDefinitions.SCORE_MODE){
			for(Food food : foodset){
				if(food.getColor() == color){
					return false;
				}
			}
		}

		return true;
	}

	public boolean canEaten(int x , int y ,ArrayList<Paint> snakeColorList,Score score){
		for(Food food : foodset){
			if(food.getX() == x && food.getY() == y){
				snakeColorList.add(food.getPaint());
				score.addPoints(food.getScore());
				return true;
			}
		}
		return false;
	}

	public void draw(Canvas c , int cellWidth , int blankWidthX , int blankWidthY){
		for(Food food : foodset){
			c.drawCircle(food.getX() * cellWidth + cellWidth/2 + blankWidthX
					, food.getY() * cellWidth + cellWidth/2 + blankWidthY, cellWidth / 2, food.getPaint());
		}
	}

	public HashSet<Food> getFoodset() {
		return foodset;
	}

	public void setFoodset(HashSet<Food> foodset) {
		this.foodset = foodset;
	}

	public int getFoodSetNum() {
		return foodSetNum;
	}

	public void setFoodSetNum(int foodSetNum) {
		this.foodSetNum = foodSetNum;
	}

	public LinkedList<SnakeBlock> getBlocks() {
		return blocks;
	}

	public void setBlocks(LinkedList<SnakeBlock> blocks) {
		this.blocks = blocks;
	}


	public void setGameMode(int gameMode) {
		this.gameMode = gameMode;
	}

}
