package com.example.snaketest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Stack;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.WindowManager;

public class SnakeCallBack implements SurfaceHolder.Callback, Runnable {

	private SurfaceHolder holder = null;
	private Thread thread = null;
	private boolean isAttached;

	private MainActivity activity;
	private int inputMode;
	private int rotation;

	private int sensorY, sensorZ;
	private acSensor sensor;
	private Rect rect;
	private FoodSet foodSet;
	private int foodNum;
	private Score score;
	private Canvas c;

	private int dispHeight, dispWidth, cellWidth;
	private final int blankWidthX;
	private final int blankWidthY;
	private final int horizontalCellNum = 20;
	private final int verticalCellNum = 20;
	private int waitTime;

	private int direction;

	private LinkedList<SnakeBlock> blocks;
	private SnakeBlock tmpLastBlock, tmpFirstBlock;
	private ArrayList<Paint> snakeColorList;
	private final int defaultBlockNum = 5;

	private int defaultAngle = 0;

	private Paint bgpaint = new Paint();
	private Paint linepaint = new Paint();
	private Paint scoretextpaint = new Paint();
	private Paint scorebgpaint = new Paint();
	private Paint tryagaintextpaint = new Paint();
	private Paint tryagainbgpaint = new Paint();
	private Paint exitbgpaint = new Paint();
	private Paint exittextpaint = new Paint();
	private Paint whitepaint = new Paint();
	private Paint titlepaint = new Paint();
	private Paint CDpaint = new Paint();
	private Paint pointspaint = new Paint();

	private String title = "TYPE_A";

	private long t1 = 0, t2 = 0; // スリープ用変数
	private boolean first = true;
	private Stack<Integer> dialogueStuck;
	private int gameMode;

	public SnakeCallBack(MainActivity activity) {
		super();
		this.activity = activity;
		this.inputMode = activity.getInputMode();
		this.rotation = activity.getRotation();

		WindowManager wm = (WindowManager) activity
				.getSystemService(Context.WINDOW_SERVICE);
		Display disp = wm.getDefaultDisplay();
		dispHeight = disp.getHeight();
		dispWidth = disp.getWidth();
		blankWidthX = dispWidth / 20;
		blankWidthY = dispHeight / 8;

		cellWidth = (dispWidth - 2 * blankWidthX) / horizontalCellNum;

		dialogueStuck = new Stack<Integer>();
		dialogueStuck.push(MyDefinitions.NO_ASK);
		scorebgpaint.setAntiAlias(true);
		scoretextpaint.setTextAlign(Paint.Align.CENTER);
		exitbgpaint.setAntiAlias(true);
		exittextpaint.setTextAlign(Paint.Align.CENTER);
		tryagainbgpaint.setAntiAlias(true);
		tryagaintextpaint.setTextAlign(Paint.Align.CENTER);
		scoretextpaint.setAntiAlias(true);
		tryagaintextpaint.setAntiAlias(true);
		exittextpaint.setAntiAlias(true);
		titlepaint.setAntiAlias(true);
		CDpaint.setAntiAlias(true);
		CDpaint.setTextAlign(Paint.Align.CENTER);
		pointspaint.setTextAlign(Paint.Align.CENTER);
		pointspaint.setTypeface(activity.getTf());
		pointspaint.setColor(Color.YELLOW);
	}

	public void setLengthModeVariable() {
		title = "TYPE_A";
		titlepaint.setColor(Color.argb(255, 255, 69, 0));
		titlepaint.setTypeface(activity.getTf());
		resizeText("TYPE_A", dispWidth / 3, dispHeight, titlepaint);

		bgpaint.setColor(Color.argb(255, 240, 255, 240));
		exitbgpaint.setColor(Color.argb(255, 138, 43, 226));
		exittextpaint.setColor(Color.argb(255, 50, 205, 50));
		exittextpaint.setTextSize(35);
		exittextpaint.setTypeface(activity.getTf());

		whitepaint.setColor(Color.argb(180, 255, 255, 255));

		scorebgpaint.setColor(Color.argb(255, 124, 252, 0));

		scoretextpaint.setColor(Color.argb(255, 255, 140, 0));
		scoretextpaint.setTypeface(activity.getTf());
		scoretextpaint.setTextSize(35);

		tryagainbgpaint.setColor(Color.argb(255, 238, 64, 0));

		linepaint.setColor(Color.argb(255, 0, 245, 0));
		linepaint.setAntiAlias(true);

		tryagaintextpaint.setColor(Color.argb(255, 144, 238, 144));
		tryagaintextpaint.setTextSize(35);
		tryagaintextpaint.setTypeface(activity.getTf());

		CDpaint.setTypeface(activity.getTf());
		CDpaint.setColor(Color.argb(255, 255, 0, 0));

		gameMode = MyDefinitions.LENGTH_MODE;
		foodNum = 1;
		setWaitTime(120);

	}

	public void setScoreModeVariable() {
		title = "TYPE_B";
		titlepaint.setColor(Color.argb(255, 0, 100, 0));
		resizeText("TYPE_B", dispWidth / 3, dispHeight, titlepaint);
		titlepaint.setTypeface(activity.getTf());

		bgpaint.setColor(Color.argb(255, 230, 255, 255));

		tryagaintextpaint.setAntiAlias(true);
		tryagaintextpaint.setColor(Color.argb(255, 50, 205, 50));
		tryagaintextpaint.setTextSize(35);
		tryagaintextpaint.setTypeface(activity.getTf());

		exitbgpaint.setColor(Color.argb(255, 138, 43, 226));

		exittextpaint.setColor(Color.argb(255, 50, 205, 50));
		exittextpaint.setTextSize(35);
		exittextpaint.setTypeface(activity.getTf());
		exittextpaint.setAntiAlias(true);

		whitepaint.setColor(Color.argb(180, 255, 255, 255));

		scorebgpaint.setColor(Color.argb(255, 0, 238, 118));

		scoretextpaint.setColor(Color.argb(255, 0, 0, 238));
		scoretextpaint.setTypeface(activity.getTf());
		scoretextpaint.setAntiAlias(true);

		tryagainbgpaint.setColor(Color.argb(255, 255, 216, 0));

		linepaint.setColor(Color.argb(255, 255, 51, 51));
		linepaint.setAntiAlias(true);

		CDpaint.setTypeface(activity.getTf());
		CDpaint.setColor(Color.argb(255, 255, 62, 150));

		gameMode = MyDefinitions.SCORE_MODE;
		foodNum = 3;
		setWaitTime(100);

	}

	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {

	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		this.holder = holder;
		if (thread == null) {
			thread = new Thread(this);
			Log.d("surface",
					"thread create: " + String.valueOf(thread.getName()));
			thread.start(); // スレッドを開始
		}
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		isAttached = false;
		thread = null; // スレッドを終了
		Log.v("surface", "destroyed");
	}

	public void askExit() {
		if (dialogueStuck.peek() == MyDefinitions.COWNT_DOWN) {
			return;
		}
		isAttached = false;
		Log.v("on askexit", "askExit?");
		Canvas c;
		c = holder.lockCanvas();

		drawAll();
		drawWhite();

		RectF rectf = new RectF(dispWidth * 1 / 4, dispHeight / 4,
				dispWidth * 3 / 4, dispHeight / 2);
		c.drawRoundRect(rectf, 20, 20, exitbgpaint);

		String s = "YES    NO";
		s = resizeText(s, dispWidth / 2 - 20, dispHeight, exittextpaint);
		c.drawText("EXIT?", dispWidth / 2, dispHeight * 3 / 8, exittextpaint);

		int textHeight = (int) exittextpaint.getFontMetrics().bottom
				- (int) exittextpaint.getFontMetrics().top;
		c.drawText(s, dispWidth / 2, dispHeight * 7 / 16 + textHeight / 3,
				exittextpaint);
		holder.unlockCanvasAndPost(c);

		if (dialogueStuck.peek() != MyDefinitions.ASK_EXIT) {
			dialogueStuck.push(MyDefinitions.ASK_EXIT);
		}

	}

	private void drawWhite() {
		rect = new Rect(0, 0, dispWidth, dispHeight);
		c.drawRect(rect, whitepaint);
	}

	public void receiveExitTouch(int touchOffX, int touchOffY) {
		if (dialogueStuck.peek() == MyDefinitions.ASK_EXIT) {
			if ((touchOffX > dispWidth / 4) && (touchOffX < dispWidth / 2)
					&& (touchOffY > dispHeight * 7 / 16)
					&& (touchOffY < dispHeight / 2)) {
				dialogueStuck.pop();
				activity.gameBack(true);
			} else if ((touchOffX > dispWidth / 2)
					&& (touchOffX < dispWidth * 3 / 4)
					&& (touchOffY > dispHeight * 7 / 16)
					&& (touchOffY < dispHeight / 2)) {
				dialogueStuck.pop();
				isAttached = true;
				thread = new Thread(this);
				Log.e("thread", "start: " + String.valueOf(thread.getName()));
				thread.start();
				activity.gameBack(false);
			}
		}
	}

	public void pushButton() {
		if (dialogueStuck.peek() == MyDefinitions.NO_ASK) {
			dialogueStuck.push(MyDefinitions.STOP);
			isAttached = false;
			c = holder.lockCanvas();

			drawAll();
			drawWhite();

			holder.unlockCanvasAndPost(c);
		} else if (dialogueStuck.peek() == MyDefinitions.STOP) {// Restart
			dialogueStuck.pop();
			isAttached = true;
			thread = new Thread(this);
			thread.start();
		}
	}

	public void stopAction() {
		Log.i("stop action", "stop");
		isAttached = false;
		c = holder.lockCanvas();

		drawAll();

		rect = new Rect(0, 0, dispWidth, dispHeight);
		c.drawRect(rect, whitepaint);

		holder.unlockCanvasAndPost(c);
	}

	@Override
	public void run() {
		if (dialogueStuck.peek() == MyDefinitions.NO_ASK) {
			if (first) {
				initializer();
				first = false;
			}

			while (isAttached) {
				t1 = System.nanoTime();
				// 描画処理を開始
				c = holder.lockCanvas();

				if (inputMode == MyDefinitions.SENSOR) {
					decideDirectionBySensor();
				} else if (inputMode == MyDefinitions.FLICK) {
					decideDirectionByFlick();
				}
				drawAll();

				holder.unlockCanvasAndPost(c);
				t2 = System.nanoTime();
				int diff = (int) (t2 - t1) / 1000000;
				if (diff < waitTime) {
					try {
						Thread.sleep(waitTime - diff);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
				// Log.d("time",String.valueOf(thread.getName()) +" t2-t1= "+
				// String.valueOf((t2-t1)/1000000));
			}
			if (dialogueStuck.peek() == MyDefinitions.ASK_TRY_AGAIN) {
				askTryAgain();
			}
		} else if (dialogueStuck.peek() == MyDefinitions.ASK_TRY_AGAIN) {
			askTryAgain();
		} else if (dialogueStuck.peek() == MyDefinitions.ASK_EXIT) {
			askExit();
		} else if (dialogueStuck.peek() == MyDefinitions.STOP) {
			stopAction();
		} else if (dialogueStuck.peek() == MyDefinitions.COWNT_DOWN) {
			Log.i("cd", "aaaaaaaaaa");
			dialogueStuck.pop();
			first = true;
			isAttached = true;
			thread = new Thread(this);
			thread.start();
		}
		// Log.e(String.valueOf(dialogueStuck.peek()),"kill thread"+
		// String.valueOf(thread.getName()));
	}

	public void drawTitle() {
		c.drawText(title, blankWidthX, blankWidthY * 2 / 3, titlepaint);
	}

	private void drawScore() {
		int width = dispWidth / 5;
		int height = blankWidthY / 3;
		RectF rectf = new RectF(dispWidth - blankWidthX - width, height,
				dispWidth - blankWidthX, height * 2);

		c.drawRoundRect(rectf, 20, 20, scorebgpaint);

		rectf = new RectF(dispWidth - blankWidthX - width * 6 / 5 - width,
				height, dispWidth - blankWidthX - width * 6 / 5, height * 2);
		c.drawRoundRect(rectf, 20, 20, scorebgpaint);

		int centerX = dispWidth - blankWidthX - width / 2;
		int centerY = blankWidthY / 2;

		String s = resizeText("SCORE", width, height, scoretextpaint);
		int drawY = centerY - (int) scoretextpaint.getFontMetrics().ascent / 3;

		c.drawText("SCORE", centerX - width * 6 / 5, drawY * 2 / 3,
				scoretextpaint);
		c.drawText("BEST", centerX, drawY * 2 / 3, scoretextpaint);
		s = resizeText(String.valueOf(score.getScore()), width, height,
				scoretextpaint);
		c.drawText(s, centerX - width * 6 / 5, drawY, scoretextpaint);
		s = resizeText(String.valueOf(activity.readBestScore()), width, height,
				scoretextpaint);
		c.drawText(s, centerX, drawY, scoretextpaint);

	}

	private String resizeText(String s, int width, int height, Paint textpaint) {
		int scoretextsize = 1;
		textpaint.setTextSize(scoretextsize);
		while (textpaint.measureText(s) < width * 4 / 5
				&& textpaint.getFontMetrics().bottom
						- textpaint.getFontMetrics().top < height * 3 / 4) {
			textpaint.setTextSize(scoretextsize++);
		}
		return s;
	}

	private void askTryAgain() {
		Canvas c;

		c = holder.lockCanvas();

		drawAll();
		drawWhite();

		RectF rectf = new RectF(dispWidth * 1 / 4, dispHeight / 4,
				dispWidth * 3 / 4, dispHeight / 2);
		c.drawRoundRect(rectf, 20, 20, tryagainbgpaint);

		int textHeight = (int) tryagaintextpaint.getFontMetrics().bottom
				- (int) tryagaintextpaint.getFontMetrics().top;
		String s = "YOUR SCORE : " + String.valueOf(score.getScore());
		s = resizeText(s, dispWidth / 2 - 20, dispHeight, tryagaintextpaint);

		if (score.getScore() > activity.readBestScore()) {
			activity.writeScore(score.getScore());
			c.drawText("HIGH SCORE !", dispWidth / 2, dispHeight * 3 / 8 - 2
					* textHeight, tryagaintextpaint);
		}

		c.drawText(s, dispWidth / 2, dispHeight * 3 / 8, tryagaintextpaint);
		c.drawText("TRY AGAIN", dispWidth / 2, dispHeight * 3 / 8 + 2
				* textHeight, tryagaintextpaint);

		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");

		activity.rewriteRanking(score.getScore(), score.getLength(),
				sdf.format(calendar.getTime()));
		holder.unlockCanvasAndPost(c);
	}

	private void drawAll() {
		drawBackGround();
		drawLines();
		drawTitle();
		drawScore();
		drawFood();
		drawSnake();
		drawPoints();
	}

	public void drawPoints() {
		if (gameMode == MyDefinitions.SCORE_MODE) {
			Paint paint = new Paint();

			int count = 0;
			int width = cellWidth * horizontalCellNum / 7 + 1;

			for (int x = blankWidthX; x < blankWidthX + cellWidth
					* horizontalCellNum; x = x + width) {
				rect = new Rect(x, blankWidthY + (cellWidth * verticalCellNum)
						+ cellWidth, x + width, blankWidthY
						+ (cellWidth * verticalCellNum) + cellWidth + width / 3);
				paint.setColor(MyDefinitions.returnBColor(count++));
				c.drawRect(rect, paint);

				String s = resizeText(String.valueOf(5 * count), width,
						width / 3, pointspaint);
				c.drawText(s, x + width / 2,
						blankWidthY + (cellWidth * verticalCellNum) + cellWidth
								+ width / 4, pointspaint);
			}
		}
	}

	public void receiveTryAgainTouch(int touchOffX, int touchOffY) {
		if (dialogueStuck.peek() == MyDefinitions.ASK_TRY_AGAIN) {
			if ((touchOffX > dispWidth / 4) && (touchOffX < dispWidth * 3 / 4)
					&& (touchOffY > dispHeight / 4)
					&& (touchOffY < dispHeight / 2)) {
				dialogueStuck.pop();
				first = true;
				thread = new Thread(this);
				Log.e("thread", "start: " + String.valueOf(thread.getName()));
				thread.start();
			}
		}
	}

	private void drawFood() {
		foodSet.draw(c, cellWidth, blankWidthX, blankWidthY);
	}

	private void initializer() {

		if (inputMode == MyDefinitions.SENSOR) {
			sensor = new acSensor();
			sensor.onCreate(activity, rotation);
			Log.i("hoge", "sensor");
		}

		blocks = new LinkedList<SnakeBlock>();
		snakeColorList = new ArrayList<Paint>();

		int x = 5, y = verticalCellNum / 2;
		for (int i = 0; i < defaultBlockNum; i++) {
			Paint paint = new Paint();
			switch (i) {
			case 0:
				paint.setColor(Color.argb(255, 255, 0, 0));
				break;
			case 1:
				paint.setColor(Color.argb(255, 102, 51, 255));
				break;
			case 2:
				paint.setColor(Color.argb(255, 255, 102, 255));
				break;
			case 3:
				paint.setColor(Color.argb(255, 204, 255, 0));
				break;
			case 4:
				paint.setColor(Color.argb(255, 51, 102, 51));
				break;
			default:
				paint.setColor(Color.argb(255, 51, 204, 255));
			}
			snakeColorList.add(paint);
			blocks.add(new SnakeBlock(x, y));
			x--;
		}
		foodSet = new FoodSet(foodNum, blocks, horizontalCellNum,
				verticalCellNum, gameMode);

		setDirection(MyDefinitions.RIGHT);

		score = new Score(0, defaultBlockNum);

		isAttached = true;
		direction = MyDefinitions.RIGHT;

		if (inputMode == MyDefinitions.SENSOR) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			}
			defaultAngle = Math.round(sensor.getY());
		}
		dialogueStuck.push(MyDefinitions.COWNT_DOWN);
		drawCD();
		if(isAttached){
			dialogueStuck.pop();
		}
	}

	private void drawCD() {
		for (int i = 3; i > 0; i--) {
			if (isAttached) {
				String num = String.valueOf(i);
				c = holder.lockCanvas();
				drawAll();
				drawWhite();

				String s = resizeText(num, dispWidth / 4, dispHeight / 3,
						CDpaint);
				c.drawText(s, dispWidth / 2, dispHeight * 3 / 7, CDpaint);

				holder.unlockCanvasAndPost(c);

				try {
					Thread.sleep(1000);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}
			}
		}

	}

	public void stopCD() {
		isAttached = false;
	}

	private void decideDirectionByFlick() {
		switch (direction) {
		case MyDefinitions.UP:
			goUp();
			break;
		case MyDefinitions.LEFT:
			goLeft();
			break;
		case MyDefinitions.DOWN:
			goDown();
			break;
		case MyDefinitions.RIGHT:
			goRight();
			break;
		default:
			break;
		}
	}

	private void drawSnake() {
		int i = 0;
		for (SnakeBlock block : blocks) {
			rect = new Rect(block.getX() * cellWidth + blankWidthX,
					block.getY() * cellWidth + blankWidthY, block.getX()
							* cellWidth + blankWidthX + cellWidth, block.getY()
							* cellWidth + blankWidthY + cellWidth);
			c.drawRect(rect, snakeColorList.get(i++));
		}
	}

	private void decideDirectionBySensor() {

		sensorY = Math.round(sensor.getY() - defaultAngle);
		sensorZ = Math.round(sensor.getZ());

		if (Math.abs(sensorY) >= Math.abs(sensorZ)) {
			if (sensorY >= 0) {
				if (direction != MyDefinitions.DOWN) {
					goUp();
				} else {
					goDown();
				}
			} else if (sensorY < 0) {
				if (direction != MyDefinitions.UP) {
					goDown();
				} else {
					goUp();
				}
			}
		} else if (Math.abs(sensorY) < Math.abs(sensorZ)) {
			if (sensorZ >= 0) {
				if (direction != MyDefinitions.RIGHT) {
					goLeft();
				} else {
					goRight();
				}
			} else if (sensorZ < 0) {
				if (direction != MyDefinitions.LEFT) {
					goRight();
				} else {
					goLeft();
				}
			}
		}
	}

	private void drawBackGround() {
		rect = new Rect(0, 0, dispWidth, dispHeight);
		c.drawRect(rect, bgpaint);
	}

	public void drawLines() {

		linepaint.setStrokeWidth(1);
		for (int y = blankWidthY; y <= (cellWidth * verticalCellNum)
				+ blankWidthY; y = y + cellWidth) {
			c.drawLine(blankWidthX, y, (cellWidth * horizontalCellNum)
					+ blankWidthX, y, linepaint);
		}

		for (int x = blankWidthX; x <= (cellWidth * horizontalCellNum)
				+ blankWidthX; x = x + cellWidth) {
			c.drawLine(x, blankWidthY, x, (cellWidth * verticalCellNum)
					+ blankWidthY, linepaint);
		}

		linepaint.setStrokeWidth(5);
		c.drawLine(blankWidthX, blankWidthY, (cellWidth * horizontalCellNum)
				+ blankWidthX, blankWidthY, linepaint);
		c.drawLine(blankWidthX, (cellWidth * verticalCellNum) + blankWidthY,
				(cellWidth * horizontalCellNum) + blankWidthX,
				(cellWidth * verticalCellNum) + blankWidthY, linepaint);
		c.drawLine(blankWidthX, blankWidthY, blankWidthX,
				(cellWidth * verticalCellNum) + blankWidthY, linepaint);
		c.drawLine((cellWidth * horizontalCellNum) + blankWidthX, blankWidthY,
				(cellWidth * horizontalCellNum) + blankWidthX,
				(cellWidth * verticalCellNum) + blankWidthY, linepaint);
	}

	private void goRight() {
		direction = MyDefinitions.RIGHT;
		modifyBlockList(1, 0);
	}

	private void goLeft() {
		direction = MyDefinitions.LEFT;
		modifyBlockList(-1, 0);
	}

	private void goDown() {
		direction = MyDefinitions.DOWN;
		modifyBlockList(0, 1);
	}

	private void goUp() {
		direction = MyDefinitions.UP;
		modifyBlockList(0, -1);
	}

	private void modifyBlockList(int X, int Y) {
		int tmpX, tmpY;
		tmpX = blocks.getLast().getX();
		tmpY = blocks.getLast().getY();

		tmpLastBlock = blocks.removeLast();

		tmpFirstBlock = blocks.getFirst();
		tmpLastBlock.setX((tmpFirstBlock.getX() + X));
		tmpLastBlock.setY((tmpFirstBlock.getY() + Y));
		blocks.addFirst(tmpLastBlock);

		if (foodSet.canEaten(tmpLastBlock.getX(), tmpLastBlock.getY(),
				snakeColorList, score)) {
			eatFood(tmpX, tmpY);
		} else {
			for (SnakeBlock sb : blocks) {
				if (!tmpLastBlock.equals(sb)) {// 自分の身体
					if (tmpLastBlock.getX() == sb.getX()
							&& tmpLastBlock.getY() == sb.getY()) {
						// ゲームオーバ
						isAttached = false;
						dialogueStuck.push(MyDefinitions.ASK_TRY_AGAIN);
						break;
					}
				}
			}
		}

		if (tmpLastBlock.getX() == -1
				|| tmpLastBlock.getX() == horizontalCellNum
				|| tmpLastBlock.getY() == -1
				|| tmpLastBlock.getY() == verticalCellNum) {// 壁
			// ゲームオーバ
			isAttached = false;
			dialogueStuck.push(MyDefinitions.ASK_TRY_AGAIN);
		}

	}

	private void eatFood(int tmpX, int tmpY) {
		blocks.addLast(new SnakeBlock(tmpX, tmpY));
		score.incLength();
		foodSet = new FoodSet(foodNum, blocks, horizontalCellNum,
				verticalCellNum, gameMode);
	}

	public int getDirection() {
		return direction;
	}

	public void setDirection(int direction) {
		this.direction = direction;
	}

	public void setAttached(boolean isAttached) {
		this.isAttached = isAttached;
	}

	public Stack<Integer> getDialogueStuck() {
		return dialogueStuck;
	}

	public void setFoodNum(int foodNum) {
		this.foodNum = foodNum;
	}

	public void setWaitTime(int waitTime) {
		this.waitTime = waitTime;
	}

}
