package com.example.snaketest;

import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class SnakeSurfaceView extends SurfaceView{


	private SnakeCallBack cb;
	private int touchOnX = 0;
	private int touchOnY = 0;
	private int touchOffX = 0;
	private int touchOffY = 0;

	public SnakeSurfaceView(MainActivity activity) {
		super(activity);

		SurfaceHolder holder = getHolder();
		if(activity.getGameMode() == MyDefinitions.LENGTH_MODE){
			cb = new LengthModeCallBack(activity);
		}else if(activity.getGameMode() == MyDefinitions.SCORE_MODE){
			cb = new ScoreModeCallBack(activity);
		}
		holder.addCallback(cb);
	}



	@Override
	public boolean onTouchEvent(MotionEvent event) {
		switch(event.getAction()){
		case MotionEvent.ACTION_DOWN:
			touchOnX = (int)event.getX();
			touchOnY = (int)event.getY();
			break;
		case MotionEvent.ACTION_UP:
			touchOffX = (int)event.getX();
			touchOffY = (int)event.getY();
			if(cb.getDialogueStuck().peek() != MyDefinitions.NO_ASK){
				cb.receiveTryAgainTouch(touchOffX, touchOffY);
				cb.receiveExitTouch(touchOffX, touchOffY);
				break;
			}else if(Math.abs(touchOnX - touchOffX) >= Math.abs(touchOnY - touchOffY)){
				if((touchOnX - touchOffX) >= 10){
					if(cb.getDirection() != MyDefinitions.RIGHT){
						cb.setDirection(MyDefinitions.LEFT);
					}else{
						cb.setDirection(MyDefinitions.RIGHT);
					}
				}else if((touchOnX - touchOffX) < 10){
					if(cb.getDirection() != MyDefinitions.LEFT){
						cb.setDirection(MyDefinitions.RIGHT);
					}else{
						cb.setDirection(MyDefinitions.LEFT);
					}
				}
			}else if(Math.abs(touchOnX - touchOffX) < Math.abs(touchOnY - touchOffY)){
				if((touchOnY - touchOffY) >= 10){
					if(cb.getDirection() != MyDefinitions.DOWN){
						cb.setDirection(MyDefinitions.UP);
					}else{
						cb.setDirection(MyDefinitions.DOWN);
					}
				}else if((touchOnY - touchOffY) < 10){
					if(cb.getDirection() != MyDefinitions.UP){
						cb.setDirection(MyDefinitions.DOWN);
					}else{
						cb.setDirection(MyDefinitions.UP);
					}
				}
			}
			break;
		default:
			break;
		}
		return true;
		//		return super.onTouchEvent(event);
	}


	public SnakeCallBack getCb() {
		return cb;
	}

}
