package com.example.snaketest;

import java.util.List;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.Surface;

public class acSensor implements SensorEventListener{

	private SensorManager mySensorManager = null;
	private float y,z = 0;
	private int rotation;

	public void onCreate(Context context , int rotation){
		this.rotation = rotation;
		mySensorManager = (SensorManager)context.getSystemService(Context.SENSOR_SERVICE);
		onResume();
	}

	private void onResume() {
		List<Sensor> sensors = mySensorManager.getSensorList(Sensor.TYPE_ORIENTATION);
		if(sensors != null && !sensors.isEmpty()){
			//regist listener
			Sensor mySensor = sensors.get(0);
			mySensorManager.registerListener(this,mySensor, SensorManager.SENSOR_DELAY_GAME);
		}
	}

	public void onPause() {
		if(mySensorManager == null ){
			return;
		}
		mySensorManager.unregisterListener(this);
	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {

	}

	@Override
	public void onSensorChanged(SensorEvent event) {
		if(event.sensor.getType() == Sensor.TYPE_ORIENTATION){
			switch(rotation){
			case Surface.ROTATION_0:
				setY(event.values[1]);
				setZ(event.values[2]);
				break;
			case Surface.ROTATION_270:
				setY(event.values[2]);
				setZ(-event.values[1]);
				break;
			default:
				setY(event.values[1]);
				setZ(event.values[2]);
			}
		}
	}


	public float getY() {
		return y;
	}
	public void setY(float y) {
		this.y = y;
	}

	public float getZ() {
		return z;
	}
	public void setZ(float z) {
		this.z = z;
	}
}
