/*
 * Decompiled with CFR 0.152.
 */
package amida.log;

import amida.log.ExternalThreadInfoReader;
import amida.log.LogEntry;
import amida.log.LogFile;
import amida.log.LogFileName;
import amida.log.TextLogLineParser;
import amida.log.java.JavaTypeManager;
import amida.util.FileRangeInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;

public class TextLogFile
implements LogFile {
    private LogFileName file;
    private ArrayList<LogEntry> entries = null;

    public TextLogFile(LogFileName file) {
        this.file = file;
    }

    @Override
    public LogFileName getFilename() {
        return this.file;
    }

    public Iterator<LogEntry> read() {
        JavaTypeManager typeManager = new JavaTypeManager();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        try {
            LineNumberReader reader = new LineNumberReader(this.createReader());
            TextLogLineParser event = new TextLogLineParser(typeManager);
            String line = reader.readLine();
            while (line != null) {
                LogEntry entry = event.parseLine(line);
                if (entry != null) {
                    entries.add(entry);
                }
                line = reader.readLine();
            }
            reader.close();
            this.entries = entries;
        }
        catch (IOException e) {
            this.entries = new ArrayList();
        }
        return this.entries.iterator();
    }

    @Override
    public Iterator<LogEntry> getEntries() {
        if (this.entries == null || this.entries.size() == 0) {
            return this.read();
        }
        return this.entries.iterator();
    }

    public LogEntry getEntry(int timestamp) {
        return this.entries.get(timestamp);
    }

    private Reader createReader() throws IOException {
        Reader reader = this.file.getPhaseBegin() >= 0L ? new InputStreamReader(new FileRangeInputStream(new FileInputStream(this.file.getFileObject()), this.file.getPhaseBegin(), this.file.getPhaseEnd())) : new BufferedReader(new FileReader(this.file.getFileObject()));
        if (this.file.getThreadDeclFile() != null) {
            reader = new ExternalThreadInfoReader(reader, this.file.getThreadDeclFile());
        }
        return reader;
    }
}

