/*
 * Decompiled with CFR 0.152.
 */
package amida.log.java;

import amida.log.AccessModifier;
import amida.log.ClassData;
import amida.log.MethodData;
import amida.log.Type;
import amida.log.java.JavaAccessModifier;
import amida.log.java.JavaClassOrInterface;
import amida.log.java.JavaType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaMethod
implements MethodData {
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final Map<JavaClassOrInterface, Map<String, List<JavaMethod>>> cois = new HashMap<JavaClassOrInterface, Map<String, List<JavaMethod>>>();
    private final String name;
    private final JavaClassOrInterface coi;
    private final JavaType[] args;
    private final JavaType returnType;
    private final String signatureString;
    private final String simpleSignatureString;
    private final boolean isConstructor;
    private boolean isAbstruct = false;
    private AccessModifier accssModifier = JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED);
    private final Set<MethodData> overWrideMethods = new HashSet<MethodData>();
    private final Set<MethodData> overWriders = new HashSet<MethodData>();

    public JavaMethod(JavaType klass, String name, JavaType returnType, JavaType[] args, boolean isStatic) {
        this((JavaClassOrInterface)klass, returnType, name, args, isStatic, JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED));
    }

    private JavaMethod(JavaClassOrInterface coi, JavaType returnType, String name, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        this.name = name.intern();
        this.coi = coi;
        this.returnType = returnType;
        this.args = args;
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(returnType.getTypeName());
        buffer.append(' ');
        buffer.append(coi.getTypeName());
        buffer.append('.');
        buffer.append(name);
        buffer.append('(');
        int i = 0;
        while (i < args.length) {
            buffer.append(this.args[i].getTypeName());
            buffer.append(',');
            ++i;
        }
        if (args.length > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(')');
        this.signatureString = buffer.toString().intern();
        this.isConstructor = coi.getName().equals(name) || name.equals(CONSTRUCTOR_NAME);
        this.simpleSignatureString = this.makeSimpleSignature(this.returnType, this.args);
    }

    private String makeSimpleSignature(JavaType returnType, JavaType[] args) {
        StringBuffer buffer = new StringBuffer("(");
        JavaType[] javaTypeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            JavaType type = javaTypeArray[n2];
            buffer.append(type.getJavaSignatureName());
            ++n2;
        }
        buffer.append(")");
        buffer.append(returnType.getJavaSignatureName());
        return buffer.toString().intern();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.signatureString;
    }

    @Override
    public String getSignature() {
        return this.simpleSignatureString;
    }

    public JavaClassOrInterface getDefinedPlace() {
        return this.coi;
    }

    @Override
    public ClassData getBelongClass() {
        return this.coi;
    }

    @Override
    public Collection<MethodData> getOverWrideMethods() {
        return this.overWrideMethods;
    }

    public String getClassName() {
        return this.getDefinedPlace().getTypeName();
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Type[] getArgmentTypes() {
        return this.args;
    }

    @Override
    public int getArgmentNum() {
        return this.args.length;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    public static int getMethodNum(JavaClassOrInterface coi) {
        int sum = 0;
        if (cois.containsKey(coi)) {
            Map<String, List<JavaMethod>> map = cois.get(coi);
            for (List<JavaMethod> list : map.values()) {
                sum += list.size();
            }
        }
        return sum;
    }

    public static int getAllMethodNum() {
        int sum = 0;
        for (JavaClassOrInterface jcoi : cois.keySet()) {
            sum += JavaMethod.getMethodNum(jcoi);
        }
        return sum;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)o;
            return method == this;
        }
        return super.equals(o);
    }

    @Override
    public void addOverWrideMethod(MethodData method) {
        if (!this.overWrideMethods.contains(method)) {
            this.overWrideMethods.add(method);
            method.addOverWrider(this);
        }
    }

    @Override
    public void addOverWrider(MethodData method) {
        if (!this.overWriders.contains(method)) {
            this.overWriders.add(method);
            method.addOverWrideMethod(this);
        }
    }

    @Override
    public boolean isAbstractMethod() {
        return this.isAbstruct;
    }

    public boolean isConcreatMethod() {
        return !this.isAbstruct;
    }

    public void setAbstractMethod(boolean isAbstruct) {
        this.isAbstruct = isAbstruct;
    }

    @Override
    public AccessModifier getAccessModifier() {
        return this.accssModifier;
    }

    public void setAccessModifier(JavaAccessModifier modifier) {
        this.accssModifier = modifier;
    }
}

