/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.elements;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class NameSet {
    private String className = null;
    private String namespace = null;
    private Set<String> classNames;
    private Set<String> namespaces;
    private String classLabel;

    public void addName(String namespace, String name) {
        if (this.className == null) {
            this.className = name;
        } else {
            if (this.classNames == null) {
                this.classNames = new HashSet<String>();
                this.classNames.add(this.className);
            }
            this.classNames.add(name);
        }
        if (this.namespace == null) {
            this.namespace = namespace;
        } else {
            if (this.namespaces == null) {
                this.namespaces = new HashSet<String>();
                this.namespaces.add(namespace);
            }
            this.namespaces.add(namespace);
        }
        this.classLabel = null;
    }

    public void merge(NameSet another) {
        if (this.className == null) {
            this.className = another.className;
            this.classNames = another.classNames;
        } else {
            if (this.classNames == null) {
                this.classNames = new HashSet<String>();
                this.classNames.add(this.className);
            }
            if (another.classNames != null) {
                this.classNames.addAll(another.classNames);
            } else if (another.className != null) {
                this.classNames.add(another.className);
            }
        }
        if (this.namespace == null) {
            this.namespace = another.namespace;
            this.namespaces = another.namespaces;
        } else {
            if (this.namespaces == null) {
                this.namespaces = new HashSet<String>();
                this.namespaces.add(this.namespace);
            }
            if (another.namespaces != null) {
                this.namespaces.addAll(another.namespaces);
            } else if (another.namespace != null) {
                this.namespaces.add(another.namespace);
            }
        }
        this.classLabel = null;
    }

    public String getClassName() {
        if (this.classLabel == null) {
            if (this.classNames == null) {
                this.classLabel = this.className;
            } else {
                Object[] names = new String[this.classNames.size()];
                int i = 0;
                for (String name : this.classNames) {
                    names[i++] = name;
                }
                Arrays.sort(names);
                StringBuilder buf = new StringBuilder();
                buf.append((String)names[0]);
                i = 1;
                while (i < names.length) {
                    buf.append("/");
                    buf.append((String)names[i]);
                    ++i;
                }
                this.classLabel = buf.toString();
            }
        }
        return this.classLabel;
    }

    public String getNamespace() {
        if (this.namespaces == null) {
            return this.namespace;
        }
        if (this.namespaces.size() == 1) {
            return this.namespace;
        }
        return "*";
    }
}

