/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.Node;
import java.util.Iterator;

public class BlockNode
extends Node {
    private String blockName = "";

    public BlockNode(CallTree tree) {
        super(tree);
    }

    public void setBlockName(String name) {
        this.blockName = name;
    }

    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public int getCallNodeNum() {
        int result = 0;
        Iterator<Node> it = this.getChildren().iterator();
        while (it.hasNext()) {
            result += it.next().getCallNodeNum();
        }
        return result;
    }

    @Override
    public CallNode getCallNode(int i) {
        int num = 0;
        for (Node node : this.getChildren()) {
            if (num + node.getCallNodeNum() > i) {
                return node.getCallNode(i - num);
            }
            num += node.getCallNodeNum();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node getNewInstance() {
        return new BlockNode(this.getCallTree());
    }

    public CallTree extractSubtree() {
        CallTree copy = new CallTree();
        for (Node n : this.getAllChildren()) {
            copy.getTopNodeList().add(n.cloneForNewTree(copy));
        }
        copy.setName(this.getCallTree().getName());
        return copy;
    }
}

