/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.gui.ContentPainter;
import amida.log.LogFileName;
import amida.logmanager.AmidaLauncher;
import amida.logmanager.AmidaProperty;
import amida.logmanager.PhaseDetectionParams;
import amida.logmanager.PhaseDetectionResultList;
import amida.logmanager.PhaseSummaryWindow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PhaseDetectionResult
implements ContentPainter {
    private PhaseDetectionResultList owner;
    private PhaseDetectionParams params;
    private int[] phases;
    private long[] filePos;
    private int traceSize;
    private LogFileName logFilename;
    private int eventsInTooltip;

    public PhaseDetectionResult(PhaseDetectionResultList owner, PhaseDetectionParams p, int traceSize, int[] phases, long[] filePos, LogFileName logFilename) {
        this.owner = owner;
        this.params = p;
        this.traceSize = traceSize;
        this.phases = phases;
        this.filePos = filePos;
        this.logFilename = logFilename;
        this.eventsInTooltip = AmidaProperty.getInstance().getPhaseMethodCountForTooltip();
    }

    public PhaseDetectionParams getPhaseParams() {
        return this.params;
    }

    public int getPhaseCount() {
        return this.phases.length;
    }

    public int getPhaseHead(int phaseIndex) {
        if (phaseIndex == this.phases.length) {
            return this.traceSize;
        }
        return this.phases[phaseIndex];
    }

    private LogFileName getFilename(int phaseIndex) {
        if (this.getLength() == this.getPhaseLength(phaseIndex)) {
            return this.logFilename;
        }
        return new LogFileName(this.logFilename, this.getPhaseFilePos(phaseIndex), this.getPhaseFilePos(phaseIndex + 1));
    }

    public long getPhaseFilePos(int phaseIndex) {
        if (phaseIndex == this.phases.length) {
            return -1L;
        }
        return this.filePos[phaseIndex];
    }

    public int getLength() {
        return this.traceSize;
    }

    public int getPhaseLength(int phaseIndex) {
        if (phaseIndex == this.phases.length - 1) {
            return this.traceSize - this.phases[phaseIndex];
        }
        if (phaseIndex >= 0 && phaseIndex < this.phases.length - 1) {
            return this.phases[phaseIndex + 1] - this.phases[phaseIndex];
        }
        return 0;
    }

    private double getPhaseHeadRatio(int phaseIndex) {
        if (phaseIndex >= this.phases.length) {
            return this.owner.getScaledPosition(this.traceSize);
        }
        return this.owner.getScaledPosition(this.getPhaseHead(phaseIndex));
    }

    @Override
    public void draw(Display display, GC gc, int x, int y, int w, int h) {
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        int width = w - 1;
        Rectangle rect = new Rectangle(x, y + 1, (int)((double)width * this.getPhaseHeadRatio(this.getPhaseCount())), h - 3);
        gc.setForeground(display.getSystemColor(25));
        gc.fillRectangle(rect);
        gc.setForeground(display.getSystemColor(24));
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        if (this.phases.length * 2 < width) {
            int i = 0;
            while (i < this.phases.length) {
                gc.setForeground(display.getSystemColor(9));
                int offset = (int)((double)width * this.getPhaseHeadRatio(i));
                gc.drawLine(x + offset, y + 2, x + offset, y + h - 3);
                gc.setForeground(display.getSystemColor(16));
                String phaseName = this.getPhaseName(i);
                gc.drawText(phaseName, x + offset + 1, y + (h - gc.textExtent((String)phaseName).y) / 2);
                ++i;
            }
        } else {
            gc.setForeground(display.getSystemColor(16));
            String err = String.valueOf(Integer.toString(this.phases.length)) + " phases detected.";
            gc.drawText(err, x + 1, y + (h - gc.textExtent((String)err).y) / 2);
        }
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(rect);
        gc.setForeground(foreground);
        gc.setBackground(background);
    }

    private String getPhaseName(int phaseIndex) {
        return Integer.toString(phaseIndex + 1);
    }

    private int getPhaseIndexFromCursor(int left, int width, int cursorX) {
        int phaseIndex = this.phases.length - 1;
        int i = 1;
        while (i < this.phases.length) {
            int offset = (int)((double)width * this.getPhaseHeadRatio(i));
            if (cursorX < left + offset) {
                phaseIndex = i - 1;
                break;
            }
            ++i;
        }
        return phaseIndex;
    }

    @Override
    public void onDoubleClicked(Control sender, int x, int y, int w, int h, int cursorX, int cursorY) {
        PhaseSummaryWindow.closeCurrentWindow();
        AmidaLauncher.open(sender.getShell(), this.getFilename(this.getPhaseIndexFromCursor(x, w, cursorX)));
    }

    @Override
    public void onMouseMove(Control sender, int x, int y, int w, int h, int cursorX, int cursorY) {
        int phase = this.getPhaseIndexFromCursor(x, w, cursorX);
        sender.setToolTipText("Phase " + Integer.toString(phase + 1) + " (" + this.getPhaseLength(phase) + " events)\n" + PhaseSummaryWindow.loadHeadEvents(this.getFilename(phase), this.eventsInTooltip));
    }

    @Override
    public void onClicked(Control sender, int x, int y, int w, int h, int cursorX, int cursorY) {
        PhaseSummaryWindow.closeCurrentWindow();
        int phase = this.getPhaseIndexFromCursor(x, w, cursorX);
        String msg = "Phase " + Integer.toString(phase + 1) + " (" + this.getPhaseLength(phase) + " events)\n";
        PhaseSummaryWindow.open(sender.getShell(), msg, this.getFilename(phase), sender.toDisplay(cursorX, cursorY + h));
    }
}

