/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.viewer.SequenceDiagramDrawer;
import amida.viewer.ViewUpdater;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Slider;

public class OverviewCanvasMouseHandler
implements MouseListener,
MouseMoveListener {
    private Slider hSlider;
    private Slider vSlider;
    private Slider hOverviewSlider;
    private Slider vOverviewSlider;
    private Composite overview;
    private SequenceDiagramDrawer drawer;
    private ViewUpdater updater;
    private boolean pressed = false;
    private static final int AUTO_SCROLL_TOPLEFT = 16;
    private static final int AUTO_SCROLL_BOTTOMRIGHT = 32;

    public OverviewCanvasMouseHandler(Slider hSlider, Slider vSlider, Composite overview, Slider hOverviewSlider, Slider vOverviewSlider, SequenceDiagramDrawer drawer, ViewUpdater updater) {
        this.hSlider = hSlider;
        this.vSlider = vSlider;
        this.hOverviewSlider = hOverviewSlider;
        this.vOverviewSlider = vOverviewSlider;
        this.overview = overview;
        this.drawer = drawer;
        this.updater = updater;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.pressed = true;
        this.moveFrame(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        this.pressed = false;
    }

    public void mouseMove(MouseEvent e) {
        if (this.pressed) {
            this.moveFrame(e.x, e.y);
            this.autoScroll(e.x, e.y);
        }
    }

    private void moveFrame(int x, int y) {
        int left = this.hOverviewSlider.getSelection();
        int top = this.vOverviewSlider.getSelection();
        Point p = this.drawer.getPositionFromOverview(left + x, top + y);
        this.hSlider.setSelection(p.x);
        this.vSlider.setSelection(p.y);
        this.updater.fireRedraw();
    }

    private void autoScroll(int x, int y) {
        int left = this.hOverviewSlider.getSelection();
        int top = this.vOverviewSlider.getSelection();
        int horizontal = 0;
        if (x < 16) {
            horizontal = x - 16;
        } else if (x > this.overview.getClientArea().width - 32) {
            horizontal = x - (this.overview.getClientArea().width - 32);
        }
        if (horizontal != 0) {
            int newPos = horizontal + left;
            this.hOverviewSlider.setSelection(newPos);
        }
        int vertical = 0;
        if (y < 16) {
            vertical = y - 16;
        } else if (y > this.overview.getClientArea().height - 32) {
            vertical = y - (this.overview.getClientArea().height - 32);
        }
        if (vertical != 0) {
            int newPos = vertical + top;
            this.vOverviewSlider.setSelection(newPos);
        }
    }
}

