/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.flexible_log;

import amida.agent.flexible_log.DamidaFlexibleFormat;
import amida.agent.flexible_log.DamidaFlexibleOutputStream;
import amida.agent.flexible_log.DamidaFlexiblePermission;
import amida.agent.flexible_log.DamidaFlexiblePermit;
import amida.agent.flexible_log.DamidaFlexibleTrigger;
import amida.agent.flexible_log.DamidaXMLContext;
import amida.agent.flexible_log.DamidaXMLParser;
import amida.agent.logging_tf.DamidaLog;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DamidaFlexibleLog<T>
extends DamidaLog<T>
implements DamidaXMLParser {
    public DamidaFlexibleLog(DamidaFlexibleOutputStream<T> out, DamidaFlexibleTrigger<T> trg, DamidaFlexibleFormat fmt, DamidaFlexiblePermission prm) {
        super(out, trg, fmt, prm);
        DamidaFlexiblePermit p = new DamidaFlexiblePermit();
        p.setTfPermit(3);
        p.addPtnInClass(String.valueOf(out.getClass().getName()) + "*");
        p.addPtnInClass(String.valueOf(trg.getClass().getName()) + "*");
        p.addPtnInClass(String.valueOf(fmt.getClass().getName()) + "*");
        p.addPtnInClass(String.valueOf(prm.getClass().getName()) + "*");
        prm.addPermit(p);
    }

    @Override
    public void setting(String setting_file) {
        if (setting_file == null) {
            System.err.println("! : A setting file path is the indispensable option.");
            System.exit(-1);
        }
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(new File(setting_file));
            NodeList list = doc.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeName().equals("DamidaSetting")) {
                    this.parse(list.item(i));
                }
                ++i;
            }
            return;
        }
        catch (IOException e) {
            System.err.println("! : " + setting_file + " file can't be opened.");
        }
        catch (ParserConfigurationException e) {
            System.err.println("! : " + setting_file + " file isn't valid.");
        }
        catch (SAXException e) {
            System.err.println("! : " + setting_file + " file isn't valid.");
        }
        System.exit(-1);
    }

    public void save(String setting_file) {
        if (setting_file == null) {
            return;
        }
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(this.create(doc));
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            File outfile = new File(setting_file);
            transformer.transform(new DOMSource(doc), new StreamResult(outfile));
        }
        catch (ParserConfigurationException e) {
            System.err.println("! : Setting can't saved on " + setting_file);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("! : Setting can't saved on " + setting_file);
        }
        catch (TransformerException e) {
            System.err.println("! : Setting can't saved on " + setting_file);
        }
    }

    @Override
    public void parse(Node n) {
        NodeList list = n.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            String tag = o.getNodeName();
            if (tag.equals(DamidaXMLContext.OUT_NAMES[0])) {
                ((DamidaXMLParser)((Object)this.out)).parse(o);
            } else if (tag.equals(DamidaXMLContext.TRG_NAMES[0])) {
                ((DamidaXMLParser)((Object)this.trg)).parse(o);
            } else if (tag.equals(DamidaXMLContext.FMT_NAMES[0])) {
                ((DamidaXMLParser)((Object)this.fmt)).parse(o);
            } else if (tag.equals(DamidaXMLContext.PMS_NAMES[0])) {
                ((DamidaXMLParser)((Object)this.prm)).parse(o);
            }
            ++i;
        }
    }

    @Override
    public Node create(Document doc) {
        Element n = doc.createElement("DamidaSetting");
        n.appendChild(((DamidaXMLParser)((Object)this.out)).create(doc));
        n.appendChild(((DamidaXMLParser)((Object)this.trg)).create(doc));
        n.appendChild(((DamidaXMLParser)((Object)this.fmt)).create(doc));
        n.appendChild(((DamidaXMLParser)((Object)this.prm)).create(doc));
        return n;
    }
}

