/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.calltree.TopRecursiveBlockNode;
import amida.util.DataChangeListener;
import java.util.LinkedList;
import java.util.List;

public class CallTree {
    private NodeList topNodeList = new NodeList(null, this);
    private List<DataChangeListener> dataChangeListeners = new LinkedList<DataChangeListener>();
    private String name;

    protected CallTree() {
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    public void fireDataChange() {
        for (DataChangeListener listener : this.dataChangeListeners) {
            listener.dataChanged();
        }
    }

    public NodeList getTopNodeList() {
        return this.topNodeList;
    }

    public void clearCompressedInformations() {
        NodeList topNodeList = this.getTopNodeList();
        this.clearCompressedInformations_i(topNodeList);
        this.fireDataChange();
    }

    public void clearCompressedInfromations(NodeList nodes) {
        this.clearCompressedInformations_i(nodes);
        this.fireDataChange();
    }

    private void clearCompressedInformations_i(NodeList nodes) {
        CallTreeIterator it = nodes.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (node instanceof TopRecursiveBlockNode) {
                CallNode resetNode = ((TopRecursiveBlockNode)node).getHiddenChild();
                it.set(resetNode);
                this.clearCompressedInformations_i(resetNode.getChildren());
                continue;
            }
            if (node instanceof LoopNode) {
                NodeList resetList = ((LoopNode)node).getHiddenChildren();
                CallTreeIterator it2 = resetList.nodeIterator();
                if (it2.hasNext()) {
                    Node first = it2.next();
                    it.set(first);
                }
                while (it2.hasNext()) {
                    it.add(it2.next());
                }
                this.clearCompressedInformations_i(resetList);
                continue;
            }
            this.clearCompressedInformations_i(node.getChildren());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

