/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.Node;
import amida.calltree.NodeList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;

public class CallTreeIterator
implements ListIterator<Node> {
    private Node now = null;
    private Node parent = null;
    private ListIterator<Node> it = null;
    private NodeList children = null;

    protected CallTreeIterator(Node parent, NodeList list) {
        this.parent = parent;
        this.children = list;
        this.it = list.listIterator();
    }

    protected CallTreeIterator(Node parent, NodeList list, int index) {
        this.parent = parent;
        this.children = list;
        this.it = list.listIterator(index);
    }

    @Override
    public Node next() {
        this.now = this.it.next();
        return this.now;
    }

    public Node nextNode() {
        this.now = this.it.next();
        return this.now;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public Node previous() {
        this.now = this.it.previous();
        return this.now;
    }

    public Node previousNode() {
        this.now = this.it.previous();
        return this.now;
    }

    @Override
    public boolean hasPrevious() {
        return this.it.hasPrevious();
    }

    public boolean hasNow() {
        return this.now != null;
    }

    public Object now() {
        return this.now;
    }

    @Override
    public void remove() {
        this.it.remove();
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
    }

    @Override
    public void set(Node o) {
        this.it.set(o);
        if (this.now.getParent() == this.parent) {
            this.now.setParent(null);
        }
        this.now = o;
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.now.setParent(parent);
    }

    @Override
    public void add(Node o) {
        this.it.add(o);
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
        Node node = o;
        node.setParent(parent);
    }

    public Node getParent() {
        return this.parent;
    }

    @Override
    public int nextIndex() {
        return this.it.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.it.previousIndex();
    }

    public CallTreeIterator nextIterator() {
        return this.now.nodeIterator();
    }

    public boolean hasChildren() {
        return this.now.hasChildren();
    }

    public int size() {
        return this.children.size();
    }

    public void reset() {
        this.it = this.children.listIterator();
        this.now = null;
    }

    public void reset(int index) {
        this.it = this.children.listIterator(index);
        this.now = null;
    }

    public NodeList getChildren() {
        return this.children;
    }

    public int countCallNode() {
        Iterator<Node> it = this.children.iterator();
        int num = 0;
        while (it.hasNext()) {
            num += it.next().getCallNodeNum();
        }
        return num;
    }

    public NodeIteratorView getView() {
        return new NodeIteratorView(this);
    }

    private class NodeIteratorView
    extends CallTreeIterator {
        CallTreeIterator nit;

        private NodeIteratorView(CallTreeIterator nit) {
            super(nit.getParent(), nit.getChildren(), nit.nextIndex());
            this.nit = nit;
        }

        @Override
        public void remove() {
        }

        @Override
        public void set(Node o) {
        }

        @Override
        public void add(Node o) {
        }

        @Override
        public CallTreeIterator nextIterator() {
            return null;
        }

        @Override
        public void reset() {
            int target = this.nit.nextIndex();
            int position = this.nextIndex();
            try {
                if (target <= position) {
                    if (target < position - target) {
                        super.reset(target);
                    } else {
                        int gap = position - target;
                        int i = 0;
                        while (i < gap) {
                            this.previous();
                            ++i;
                        }
                    }
                } else {
                    int gap = target - position;
                    int i = 0;
                    while (i < gap) {
                        this.next();
                        ++i;
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                super.reset(target);
            }
        }

        public NodeIteratorView nextIteratorView() {
            return ((Node)this.now()).nodeIterator().getView();
        }

        @Override
        public NodeIteratorView getView() {
            return this;
        }
    }
}

