/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.foldrule;

import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.logcompactor.foldrule.MethodMissingLoopRule;
import amida.logcompactor.foldrule.NodeTreeComparator;
import amida.logcompactor.foldrule.RemakeRule;
import amida.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

public class RecursiveCallFoldRule {
    public static CallNode checkRecursiveCall(Stack<Node> nodeStack, Stack<Iterator<?>> iteratorStack, Comparator<Object> comp) {
        int size = nodeStack.size();
        Node[] callList = new Node[size];
        nodeStack.toArray(callList);
        ListIterator[] itList = new ListIterator[size];
        iteratorStack.toArray(itList);
        CallNode top = null;
        int i = 0;
        while (i < size - 1) {
            if (callList[i] instanceof CallNode) {
                int j = i + 1;
                while (j < size) {
                    if (callList[j] instanceof CallNode && comp.compare(callList[i], callList[j]) == 0 && !((CallNode)callList[j]).isRecursive()) {
                        top = (CallNode)callList[i];
                        return top;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static Pair<List<CallNode>, List<Iterator<?>>> makeRecursiveList(List<Integer> recursiveIndexList, Stack<Node> nodeStack, Stack<Iterator<?>> iteratorStack, NodeTreeComparator comp, CallNode topNode) {
        if (recursiveIndexList.isEmpty()) {
            return null;
        }
        int size = nodeStack.size();
        ArrayList<CallNode> sameCallList = new ArrayList<CallNode>();
        ArrayList<Iterator> sameCallItList = new ArrayList<Iterator>();
        for (int index : recursiveIndexList) {
            sameCallList.add((CallNode)nodeStack.get(index));
            sameCallItList.add((Iterator)iteratorStack.get(index));
        }
        int topIndex = recursiveIndexList.get(0);
        int num = size - topIndex - 1;
        int i = 0;
        while (i < num) {
            nodeStack.pop();
            iteratorStack.pop();
            ++i;
        }
        size = sameCallList.size();
        Set<Integer> topId = null;
        if (size > 0) {
            topId = ((CallNode)sameCallList.get(0)).getId();
        }
        int i2 = 0;
        while (i2 < size) {
            CallNode rec = (CallNode)sameCallList.get(i2);
            CallTreeIterator it = (CallTreeIterator)sameCallItList.get(i2);
            Node parent = rec.getParent();
            CallNode newNode = new CallNode(rec.getCallTree(), rec.getMethod(), rec.getId(), rec.getCallIndex());
            if (i2 == 1) {
                newNode.addId(topId);
            }
            newNode.setExitMode(rec.getExitMode());
            newNode.setParent(parent);
            newNode.setRecursive(true);
            it.set(newNode);
            ++i2;
        }
        return new Pair(sameCallList, sameCallItList);
    }

    public static List<Integer> getIncludeList(List<CallNode> list, NodeTreeComparator comp) {
        LinkedList<Integer> includes = new LinkedList<Integer>();
        int i = 0;
        while (i < list.size()) {
            CallNode call1 = list.get(i);
            ListIterator it2 = includes.listIterator();
            int large = -1;
            while (it2.hasNext()) {
                CallNode call2 = list.get((Integer)it2.next());
                large = RecursiveCallFoldRule.selectInclude(call1, call2, comp);
                if (large == 1) {
                    RemakeRule.remake(call1, call2);
                    MethodMissingLoopRule.remakeIncludeNode(call1, call2, -1, comp);
                    it2.remove();
                    continue;
                }
                if (large == 2 || large == 0) {
                    RemakeRule.remake(call2, call1);
                    MethodMissingLoopRule.remakeIncludeNode(call2, call1, -1, comp);
                    while (it2.hasNext()) {
                        call2 = list.get((Integer)it2.next());
                        if (RecursiveCallFoldRule.selectInclude(call1, call2, comp) != 2) continue;
                        RemakeRule.remake(call2, call1);
                        MethodMissingLoopRule.remakeIncludeNode(call2, call1, -1, comp);
                    }
                    break;
                }
                RemakeRule.remake(call1, call2);
                RemakeRule.remake(call2, call1);
            }
            if (large == 1 || large == -1) {
                includes.add(new Integer(i));
            }
            ++i;
        }
        return includes;
    }

    private static int selectInclude(CallNode parent1, CallNode parent2, NodeTreeComparator comp) {
        NodeList list1 = parent1.getChildren();
        NodeList list2 = parent2.getChildren();
        int callNum1 = 0;
        int callNum2 = 0;
        int callIndex1 = 0;
        int callIndex2 = 0;
        Node node1 = null;
        Node node2 = null;
        int maxCallNum1 = 0;
        Iterator it1 = list1.iterator();
        while (it1.hasNext()) {
            maxCallNum1 += ((Node)it1.next()).getCallNodeNum();
        }
        it1 = list1.iterator();
        int maxCallNum2 = 0;
        Iterator it2 = list2.iterator();
        while (it2.hasNext()) {
            maxCallNum2 += ((Node)it2.next()).getCallNodeNum();
        }
        it2 = list2.iterator();
        int large = maxCallNum1 == maxCallNum2 ? 0 : (maxCallNum1 > maxCallNum2 ? 1 : 2);
        block2: while (true) {
            if (callIndex1 >= callNum1) {
                if (!it1.hasNext()) break;
                node1 = (Node)it1.next();
                callNum1 = node1.getCallNodeNum();
                callIndex1 = 0;
            }
            if (callIndex2 >= callNum2) {
                if (!it2.hasNext()) break;
                node2 = (Node)it2.next();
                callNum2 = node2.getCallNodeNum();
                callIndex2 = 0;
            }
            while (true) {
                CallNode call2;
                if (callIndex1 >= callNum1 || callIndex2 >= callNum2) continue block2;
                CallNode call1 = node1.getCallNode(callIndex1);
                int compare = comp.compareNode(call1, call2 = node2.getCallNode(callIndex2));
                if (compare == 0) {
                    int newLarge = RecursiveCallFoldRule.selectInclude(call1, call2, comp);
                    if (newLarge != 0) {
                        if (newLarge == -1) {
                            return -1;
                        }
                        if (large == 0) {
                            large = newLarge;
                        } else if (large != newLarge) {
                            return -1;
                        }
                    }
                    ++callIndex1;
                    ++callIndex2;
                    continue;
                }
                if (large == 0) {
                    return -1;
                }
                if (large == 1) {
                    ++callIndex1;
                    continue;
                }
                ++callIndex2;
            }
            break;
        }
        if (large == 1) {
            if (callIndex2 < callNum2 || it2.hasNext()) {
                return -1;
            }
            return large;
        }
        if (large == 2) {
            if (callIndex1 < callNum1 || it1.hasNext()) {
                return -1;
            }
            return large;
        }
        if (callIndex1 < callNum1 || it1.hasNext()) {
            return 1;
        }
        if (callIndex2 < callNum2 || it2.hasNext()) {
            return 2;
        }
        return 0;
    }
}

