/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import java.util.Arrays;

public class CacheUpdateRecord {
    private int[] updateFlags;
    private int pointer;
    private int read;

    public CacheUpdateRecord(int windowSize) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window Size must be positive integer.");
        }
        this.updateFlags = new int[windowSize];
        Arrays.fill(this.updateFlags, 0);
        this.pointer = 0;
    }

    public void record(boolean flag) {
        this.updateFlags[this.pointer] = flag ? 1 : 0;
        ++this.pointer;
        if (this.pointer == this.updateFlags.length) {
            this.pointer = 0;
        }
        ++this.read;
    }

    public double getFrequency(int events) {
        if (this.read < events) {
            return (double)this.count(this.read, this.read) * 1.0 / (double)events;
        }
        return (double)this.count(this.pointer, events) * 1.0 / (double)events;
    }

    private int count(int pointer, int size) {
        int count = 0;
        int index = pointer - 1;
        if (index < 0) {
            index = this.updateFlags.length - 1;
        }
        int i = 0;
        while (i < size) {
            count += this.updateFlags[index];
            if (--index < 0) {
                index = this.updateFlags.length - 1;
            }
            ++i;
        }
        return count;
    }
}

