/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import gnu.trove.TIntIntHashMap;
import java.util.LinkedList;
import java.util.Queue;

public class LRUCache {
    private int cacheSize;
    private Queue<Integer> cache;
    private TIntIntHashMap map;

    public LRUCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new LinkedList<Integer>();
        this.map = new TIntIntHashMap(cacheSize * 2);
    }

    private void removeOldestObject() {
        int i;
        do {
            int removedID = this.cache.poll();
            i = this.map.get(removedID);
            this.map.put(removedID, --i);
            if (i != 0) continue;
            this.map.remove(removedID);
        } while (i != 0);
    }

    public boolean update(int obj) {
        if (this.map.containsKey(obj)) {
            this.cache.offer(obj);
            int i = this.map.get(obj);
            this.map.put(obj, ++i);
            return false;
        }
        if (this.map.size() == this.cacheSize) {
            this.removeOldestObject();
        }
        this.cache.offer(obj);
        this.map.put(obj, 1);
        return true;
    }
}

