/*
 * Decompiled with CFR 0.152.
 */
package amida.phase;

import amida.phase.BigDecimalIterator;
import amida.phase.IntIterator;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class Parameter {
    private int cmin;
    private int cmax;
    private int cinterval;
    private int wmin;
    private int wmax;
    private int winterval;
    private BigDecimal tmin;
    private BigDecimal tmax;
    private BigDecimal tinterval;
    private int smin;
    private int smax;
    private int sinterval;
    private int sum;
    private int count = 0;
    private String filename;

    public Parameter(String[] args) {
        int i = 0;
        int minimumParameter = 17;
        this.cmin = 1;
        if ("-c".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.cmin = Integer.parseInt(args[i]);
            ++i;
        }
        this.cmax = this.cmin;
        if ("-C".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) >= this.cmin) {
            this.cmax = Integer.parseInt(args[i]);
            ++i;
        }
        this.cinterval = 1;
        if ("-d".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.cinterval = Integer.parseInt(args[i]);
            ++i;
        }
        this.wmin = 1;
        if ("-w".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.wmin = Integer.parseInt(args[i]);
            ++i;
        }
        this.wmax = this.wmin;
        if ("-W".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) >= this.wmin) {
            this.wmax = Integer.parseInt(args[i]);
            ++i;
        }
        this.winterval = 1;
        if ("-v".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.winterval = Integer.parseInt(args[i]);
            ++i;
        }
        this.tmin = new BigDecimal(0.0);
        if ("-t".equals(args[i]) && Pattern.matches("^[01][\\.\\d+]*$", args[++i]) && Float.parseFloat(args[i]) > 0.0f) {
            this.tmin = new BigDecimal(args[i]);
            ++i;
        }
        this.tmax = this.tmin;
        if ("-T".equals(args[i]) && Pattern.matches("^[01][\\.\\d+]*$", args[++i]) && Float.parseFloat(args[i]) > 0.0f) {
            this.tmax = new BigDecimal(args[i]);
            ++i;
            if (this.tmax.compareTo(this.tmin) < 0) {
                this.tmax = this.tmin;
            }
        }
        this.tinterval = BigDecimal.ONE;
        if ("-u".equals(args[i]) && Pattern.matches("^[01][\\.\\d+]*$", args[++i]) && Float.parseFloat(args[i]) > 0.0f) {
            this.tinterval = new BigDecimal(args[i]);
            ++i;
        }
        this.smin = 1;
        if ("-s".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.smin = Integer.parseInt(args[i]);
            ++i;
        }
        this.smax = this.smin;
        if ("-S".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) >= this.smin) {
            this.smax = Integer.parseInt(args[i]);
            ++i;
        }
        this.sinterval = 1;
        if ("-r".equals(args[i]) && Pattern.matches("^\\d+$", args[++i]) && Integer.parseInt(args[i]) > 0) {
            this.sinterval = Integer.parseInt(args[i]);
            ++i;
        }
        if (args.length < 17) {
            throw new IllegalArgumentException("lacked parameter LOGFILEPATH");
        }
        this.sum = ((this.cmax - this.cmin) / this.cinterval + 1) * ((this.wmax - this.wmin) / this.winterval + 1) * (this.tmax.subtract(this.tmin).divide(this.tinterval).intValue() + 1) * ((this.smax - this.smin) / this.sinterval + 1);
        this.filename = args[args.length - 1];
    }

    public String getFilename() {
        return this.filename;
    }

    public IntIterator getWindowSizeIterator() {
        return new IntIterator(this.wmin, this.wmax, this.winterval);
    }

    public IntIterator getCacheSizeIterator() {
        return new IntIterator(this.cmin, this.cmax, this.cinterval);
    }

    public IntIterator getPhaseHeadDistanceIterator() {
        return new IntIterator(this.smin, this.smax, this.sinterval);
    }

    public BigDecimalIterator getThresholdIterator() {
        return new BigDecimalIterator(this.tmin, this.tmax, this.tinterval);
    }

    public int getMaxWindowSize() {
        return this.wmax;
    }

    public int getWindowSizeCount() {
        return (this.wmax - this.wmin) / this.winterval + 1;
    }

    public double progress() {
        ++this.count;
        BigDecimal bd = new BigDecimal((double)this.count * 100.0 / (double)this.sum);
        return bd.setScale(1, 4).doubleValue();
    }
}

