/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.calltree.DominanceTree;
import amida.viewer.elements.SequenceObject;
import amida.viewer.filter.DominatorUnificationFilter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DominanceFilter {
    private DominanceTree domtree;
    private List<DominatorUnificationFilter> filters;
    private TIntObjectHashMap<DominatorUnificationFilter> dominators;

    public DominanceFilter(DominanceTree domtree) {
        this.domtree = domtree;
        this.constructFilters();
    }

    private void constructFilters() {
        this.filters = new ArrayList<DominatorUnificationFilter>();
        this.dominators = new TIntObjectHashMap();
        TIntObjectHashMap groups = new TIntObjectHashMap();
        int[] nodes = this.domtree.getNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] > 0) {
                int dom = this.domtree.getDominator(nodes[i]);
                while (dom < 0) {
                    dom = this.domtree.getDominator(dom);
                }
                if (dom > 0) {
                    StringBuilder group = (StringBuilder)groups.get(dom);
                    if (group == null) {
                        group = new StringBuilder();
                        groups.put(dom, (Object)group);
                        group.append(dom);
                    }
                    group.append(",");
                    group.append(nodes[i]);
                }
            }
            ++i;
        }
        groups.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<StringBuilder>(){

            public boolean execute(int dominator, StringBuilder group) {
                DominatorUnificationFilter filter = new DominatorUnificationFilter();
                filter.setDominator(dominator);
                filter.setObjectCondition(group.toString());
                filter.setActive(true);
                DominanceFilter.this.filters.add(filter);
                DominanceFilter.this.dominators.put(dominator, (Object)filter);
                return true;
            }
        });
    }

    public List<Collection<SequenceObject>> apply(List<SequenceObject> seq) {
        ArrayList<Collection<SequenceObject>> groups = new ArrayList<Collection<SequenceObject>>();
        for (DominatorUnificationFilter filter : this.filters) {
            Collection<SequenceObject> group = filter.match(seq);
            if (group.size() <= 1) continue;
            groups.add(group);
        }
        return groups;
    }

    /*
     * Unable to fully structure code
     */
    public DominatorUnificationFilter getDominatorFilter(SequenceObject object) {
        ids = object.getIdList();
        dom = ids[0];
        i = 1;
        while (i < ids.length) {
            dom = this.domtree.nearestCommonAncestor(dom, ids[i]);
            ++i;
        }
        if (dom != 0) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            dom = this.domtree.getDominator(dom);
lbl11:
            // 2 sources

            ** while (dom < 0)
        }
lbl12:
        // 1 sources

        return (DominatorUnificationFilter)this.dominators.get(dom);
    }
}

