/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.FilterSet;
import java.util.ArrayList;
import java.util.List;

public class FilterManager {
    private List<FilterSet> globalFilters;
    private List<String> globalFilterName;
    private FilterSet globalFilterRedirecter;
    private List<String> localFilterName;
    private List<FilterSet> localFilters;

    public FilterManager() {
        FilterSet defaultSet = new FilterSet();
        this.globalFilters = new ArrayList<FilterSet>();
        this.globalFilters.add(defaultSet);
        this.globalFilterName = new ArrayList<String>();
        this.globalFilterName.add("Default Global Filters");
        this.localFilters = new ArrayList<FilterSet>();
        this.localFilterName = new ArrayList<String>();
        this.globalFilterRedirecter = new FilterSet();
        this.globalFilterRedirecter.setParentFilter(defaultSet);
    }

    public FilterSet getGlobalFilterSet(int idx) {
        return this.globalFilters.get(idx);
    }

    public int getGlobalFilterCount() {
        return this.globalFilters.size();
    }

    public String getGlobalFilterName(int idx) {
        return this.globalFilterName.get(idx);
    }

    public void registerFilterSet(FilterSet filter, String name) {
        filter.setParentFilter(this.globalFilterRedirecter);
        this.localFilters.add(filter);
        this.localFilterName.add(name);
    }

    public int getLocalFilterCount() {
        return this.localFilters.size();
    }

    public FilterSet getLocalFilter(int idx) {
        return this.localFilters.get(idx);
    }

    public String getLocalFilterName(int idx) {
        return this.localFilterName.get(idx);
    }

    public void disposeFilter(FilterSet filters) {
        int idx = this.localFilters.indexOf(filters);
        if (idx != -1) {
            this.localFilters.remove(idx);
            this.localFilterName.remove(idx);
        }
    }
}

