/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.flexible_log;

import amida.agent.flexible_log.DamidaXMLContext;
import amida.agent.flexible_log.DamidaXMLParser;
import java.util.LinkedList;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DamidaFlexiblePermit
implements DamidaXMLParser {
    public static final int LOGGING = 0;
    public static final int CANCEL = 1;
    public static final int UNMATCH = 2;
    public static final int ALL = 0;
    public static final int CALLER = 1;
    public static final int CALLEE = 2;
    public static final int NOT = 3;
    protected int tfPermit = 2;
    protected LinkedList<String> ptnInClass = new LinkedList();
    protected LinkedList<PmsPair> ptnInConstructor = new LinkedList();
    protected LinkedList<PmsPair> ptnInMethod = new LinkedList();
    protected LinkedList<PmsPair> ptnConstructorCall = new LinkedList();
    protected LinkedList<PmsPair> ptnMethodCall = new LinkedList();
    protected LinkedList<PmsPair> ptnFieldReader = new LinkedList();
    protected LinkedList<PmsPair> ptnFieldWriter = new LinkedList();
    protected LinkedList<PmsPair> ptnCast = new LinkedList();
    protected LinkedList<PmsPair> ptnInstanceof = new LinkedList();
    protected LinkedList<PmsPair> ptnHandler = new LinkedList();
    protected LinkedList<PmsPair> ptnNewArray = new LinkedList();
    protected LinkedList<PmsPair> ptnNewExpr = new LinkedList();

    public int getTfPermit() {
        return this.tfPermit;
    }

    public void setTfPermit(int tfPermit) {
        this.tfPermit = tfPermit;
    }

    public void addPtnInClass(String ptn) {
        this.ptnInClass.add(ptn.length() > 0 ? ptn : "*");
    }

    public void addPtnInConstructor(String ptn, boolean cancel) {
        this.ptnInConstructor.add(new PmsPair(ptn, cancel));
    }

    public void addPtnInMethod(String ptn, boolean cancel) {
        this.ptnInMethod.add(new PmsPair(ptn, cancel));
    }

    public void addPtnConstructorCall(String ptn, boolean cancel) {
        this.ptnConstructorCall.add(new PmsPair(ptn, cancel));
    }

    public void addPtnMethodCall(String ptn, boolean cancel) {
        this.ptnMethodCall.add(new PmsPair(ptn, cancel));
    }

    public void addPtnFieldReader(String ptn, boolean cancel) {
        this.ptnFieldReader.add(new PmsPair(ptn, cancel));
    }

    public void addPtnFieldWriter(String ptn, boolean cancel) {
        this.ptnFieldWriter.add(new PmsPair(ptn, cancel));
    }

    public void addPtnCast(String ptn, boolean cancel) {
        this.ptnCast.add(new PmsPair(ptn, cancel));
    }

    public void addPtnInstanceof(String ptn, boolean cancel) {
        this.ptnInstanceof.add(new PmsPair(ptn, cancel));
    }

    public void addPtnHandler(String ptn, boolean cancel) {
        this.ptnHandler.add(new PmsPair(ptn, cancel));
    }

    public void addPtnNewArray(String ptn, boolean cancel) {
        this.ptnNewArray.add(new PmsPair(ptn, cancel));
    }

    public void addPtnNewExpr(String ptn, boolean cancel) {
        this.ptnNewExpr.add(new PmsPair(ptn, cancel));
    }

    public static boolean match(String ptn, String str) {
        boolean s = ptn.startsWith("*");
        boolean e = ptn.endsWith("*");
        if (s && e) {
            if (ptn.length() == 1) {
                return true;
            }
            return str.indexOf(ptn.substring(1, ptn.length() - 1)) >= 0;
        }
        if (s) {
            return str.endsWith(ptn.substring(1, ptn.length()));
        }
        if (e) {
            return str.startsWith(ptn.substring(0, ptn.length() - 1));
        }
        return str.equals(ptn);
    }

    protected int canLgIn(LinkedList<PmsPair> ptns, String str) {
        if (this.tfPermit == 2 || this.tfPermit == 3) {
            return 1;
        }
        if (ptns.size() > 0) {
            ListIterator it = ptns.listIterator();
            while (it.hasNext()) {
                PmsPair pp = (PmsPair)it.next();
                if (!DamidaFlexiblePermit.match(pp.ptn, str)) continue;
                return pp.cancel ? 1 : 0;
            }
        }
        return 0;
    }

    protected int canLg(LinkedList<PmsPair> ptns, String str) {
        if (this.tfPermit == 1 || this.tfPermit == 3) {
            return 1;
        }
        if (ptns.size() > 0) {
            ListIterator it = ptns.listIterator();
            while (it.hasNext()) {
                PmsPair pp = (PmsPair)it.next();
                if (!DamidaFlexiblePermit.match(pp.ptn, str)) continue;
                return pp.cancel ? 1 : 0;
            }
        }
        return 0;
    }

    public int canLgInClass(String str) {
        if (this.ptnInClass.size() > 0) {
            ListIterator it = this.ptnInClass.listIterator();
            while (it.hasNext()) {
                if (!DamidaFlexiblePermit.match((String)it.next(), str)) continue;
                return this.tfPermit == 0 || this.tfPermit == 1 ? 0 : 1;
            }
            return 2;
        }
        return this.tfPermit == 0 ? 0 : 1;
    }

    public int canLgInConstructor(String str) {
        return this.canLgIn(this.ptnInConstructor, str);
    }

    public int canLgInMethod(String str) {
        return this.canLgIn(this.ptnInMethod, str);
    }

    public int canLgConstructorCall(String str) {
        return this.canLg(this.ptnConstructorCall, str);
    }

    public int canLgMethodCall(String str) {
        return this.canLg(this.ptnMethodCall, str);
    }

    public int canLgFieldReader(String str) {
        return this.canLg(this.ptnFieldReader, str);
    }

    public int canLgFieldWriter(String str) {
        return this.canLg(this.ptnFieldWriter, str);
    }

    public int canLgCast(String str) {
        return this.canLg(this.ptnCast, str);
    }

    public int canLgInstanceof(String str) {
        return this.canLg(this.ptnInstanceof, str);
    }

    public int canLgHandler(String str) {
        return this.canLg(this.ptnHandler, str);
    }

    public int canLgNewArray(String str) {
        return this.canLg(this.ptnNewArray, str);
    }

    public int canLgNewExpr(String str) {
        return this.canLg(this.ptnNewExpr, str);
    }

    @Override
    public void parse(Node n) {
        String log = ((Element)n).getAttribute("log");
        if (log.equals("all")) {
            this.setTfPermit(0);
        } else if (log.equals("caller")) {
            this.setTfPermit(1);
        } else if (log.equals("callee")) {
            this.setTfPermit(2);
        } else if (log.equals("not")) {
            this.setTfPermit(3);
        }
        NodeList list = n.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            String tag = o.getNodeName();
            if (tag.equals(DamidaXMLContext.IVT_NAMES[0])) {
                this.addPtnInClass(((Element)o).getAttribute("name"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[1])) {
                this.addPtn(this.ptnInConstructor, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[2])) {
                this.addPtn(this.ptnConstructorCall, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[3])) {
                this.addPtn(this.ptnInMethod, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[4])) {
                this.addPtn(this.ptnMethodCall, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[5])) {
                this.addPtn(this.ptnFieldReader, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[6])) {
                this.addPtn(this.ptnFieldWriter, ((Element)o).getAttribute("name"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[7])) {
                this.addPtn(this.ptnCast, ((Element)o).getAttribute("class"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[8])) {
                this.addPtn(this.ptnInstanceof, ((Element)o).getAttribute("class"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[9])) {
                this.addPtn(this.ptnHandler, ((Element)o).getAttribute("class"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[10])) {
                this.addPtn(this.ptnNewArray, ((Element)o).getAttribute("class"), ((Element)o).getAttribute("log"));
            } else if (tag.equals(DamidaXMLContext.IVT_NAMES[11])) {
                this.addPtn(this.ptnNewExpr, ((Element)o).getAttribute("class"), ((Element)o).getAttribute("log"));
            }
            ++i;
        }
    }

    @Override
    public Node create(Document doc) {
        Element n = doc.createElement(DamidaXMLContext.PMS_NAMES[1]);
        n.setAttribute("log", this.tfPermit == 0 ? "all" : (this.tfPermit == 2 ? "callee" : (this.tfPermit == 1 ? "caller" : "not")));
        ListIterator it = this.ptnInClass.listIterator();
        while (it.hasNext()) {
            Element m = doc.createElement(DamidaXMLContext.IVT_NAMES[0]);
            n.appendChild(m);
            m.setAttribute("name", (String)it.next());
        }
        Object[][] ptns = new Object[][]{{this.ptnInConstructor, DamidaXMLContext.IVT_NAMES[1]}, {this.ptnInMethod, DamidaXMLContext.IVT_NAMES[3]}, {this.ptnConstructorCall, DamidaXMLContext.IVT_NAMES[2]}, {this.ptnMethodCall, DamidaXMLContext.IVT_NAMES[3]}, {this.ptnFieldReader, DamidaXMLContext.IVT_NAMES[5]}, {this.ptnFieldWriter, DamidaXMLContext.IVT_NAMES[6]}, {this.ptnCast, DamidaXMLContext.IVT_NAMES[7]}, {this.ptnInstanceof, DamidaXMLContext.IVT_NAMES[8]}, {this.ptnHandler, DamidaXMLContext.IVT_NAMES[9]}, {this.ptnNewArray, DamidaXMLContext.IVT_NAMES[10]}, {this.ptnNewExpr, DamidaXMLContext.IVT_NAMES[11]}};
        int i = 0;
        while (i < ptns.length) {
            ListIterator is = ((LinkedList)ptns[i][0]).listIterator();
            String tag = (String)ptns[i][1];
            while (it.hasNext()) {
                PmsPair p = (PmsPair)is.next();
                Element m = doc.createElement(tag);
                m.setAttribute(i < 6 ? "name" : "class", p.ptn);
                m.setAttribute("log", p.cancel ? "ok" : "cancel");
            }
            ++i;
        }
        return n;
    }

    protected void addPtn(LinkedList<PmsPair> ptns, String ptn, String log) {
        ptns.add(new PmsPair(ptn, log));
    }

    protected class PmsPair {
        protected String ptn;
        protected boolean cancel;

        public PmsPair(String ptn, boolean cancel) {
            this.ptn = ptn;
            this.cancel = cancel;
        }

        public PmsPair(String ptn, String cancel) {
            this.ptn = ptn.length() > 0 ? ptn : "*";
            this.cancel = cancel.equals("cancel");
        }
    }
}

