/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.diagram.sequencediagram.Called;
import amida.diagram.sequencediagram.ISequenceElement;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceBlock;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.SequenceObject;
import amida.utility.SelectionChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SequenceSelectionModel {
    private Set<Integer> selectedSequenceIndex = new TreeSet<Integer>();
    private Set<Integer> selectedObjectIndex = new TreeSet<Integer>();
    private Set<SequenceBlock> selectedBlock = new HashSet<SequenceBlock>();
    private Set<Called> selectedCalled = new HashSet<Called>();
    private Set<SequenceLoop> selectedLoops = new HashSet<SequenceLoop>();
    private List<SelectionChangeListener> selectionListeners = new LinkedList<SelectionChangeListener>();
    private int lastSelected = -1;

    public Set<Integer> getSelectedSequenceIndex() {
        return this.selectedSequenceIndex;
    }

    public void setSelectedSequence(int i) {
        this.selectedSequenceIndex.add(new Integer(i));
        this.fireSelectionChanged();
    }

    public void clearSelectedSequence() {
        this.selectedSequenceIndex.clear();
        this.fireSelectionChanged();
    }

    public Set<Integer> getSelectedObjectIndex() {
        return this.selectedObjectIndex;
    }

    public boolean isSelectedObject(int index) {
        return this.selectedObjectIndex.contains(new Integer(index));
    }

    public void selectObject(int selected, boolean selectRange, boolean keepOtherObjects) {
        Integer idx = new Integer(selected);
        if (keepOtherObjects) {
            this.clearDiagramElements();
            if (this.selectedObjectIndex.contains(idx)) {
                this.selectedObjectIndex.remove(idx);
            } else {
                this.selectedObjectIndex.add(new Integer(selected));
            }
            this.lastSelected = -1;
        } else if (selectRange && this.lastSelected != -1) {
            int end;
            int start;
            this.clearAll();
            if (this.lastSelected < selected) {
                start = this.lastSelected;
                end = selected;
            } else {
                start = selected;
                end = this.lastSelected;
            }
            int i = start;
            while (i <= end) {
                this.selectedObjectIndex.add(new Integer(i));
                ++i;
            }
        } else {
            this.clearAll();
            this.selectedObjectIndex.add(new Integer(selected));
            this.lastSelected = selected;
        }
        this.fireSelectionChanged();
    }

    public void setSelectedObject(int i) {
        this.selectedObjectIndex.add(new Integer(i));
        this.lastSelected = i;
        this.fireSelectionChanged();
    }

    public void clearSelectedObject() {
        this.selectedObjectIndex.clear();
        this.fireSelectionChanged();
    }

    public Set<SequenceLoop> getSelectedLoops() {
        return this.selectedLoops;
    }

    public void setSelectedLoop(SequenceLoop loop) {
        this.selectedLoops.add(loop);
        this.fireSelectionChanged();
    }

    public void clearSelectedLoop() {
        this.selectedLoops.clear();
        this.fireSelectionChanged();
    }

    public Set<SequenceBlock> getSeletectedBlock() {
        return this.selectedBlock;
    }

    public void setSelectedBlock(SequenceBlock block) {
        this.selectedBlock.add(block);
        this.fireSelectionChanged();
    }

    public void clearSelectedBlock() {
        this.selectedBlock.clear();
        this.fireSelectionChanged();
    }

    public Set<Called> getSelectedCalled() {
        return this.selectedCalled;
    }

    public void setSelectedCalled(Called c) {
        this.selectedCalled.add(c);
        this.fireSelectionChanged();
    }

    public void clearSelectedCalled() {
        this.selectedCalled.clear();
        this.fireSelectionChanged();
    }

    private void clearDiagramElements() {
        this.selectedSequenceIndex.clear();
        this.selectedBlock.clear();
        this.selectedLoops.clear();
        this.selectedCalled.clear();
    }

    private void clearAll() {
        this.clearDiagramElements();
        this.selectedObjectIndex.clear();
    }

    public void clearAllSelection() {
        this.clearAll();
        this.fireSelectionChanged();
    }

    public void selectElement(ISequenceElement element) {
        if (element instanceof Called) {
            this.clearAllSelection();
            this.setSelectedCalled((Called)element);
        } else if (!(element instanceof SequenceObject)) {
            if (element instanceof Sequence) {
                this.clearAllSelection();
                this.setSelectedSequence(((Sequence)element).getIndex());
            } else if (element instanceof SequenceBlock) {
                this.clearAllSelection();
                this.setSelectedBlock((SequenceBlock)element);
            } else if (element instanceof SequenceLoop) {
                this.clearAllSelection();
                this.setSelectedLoop((SequenceLoop)element);
            }
        }
    }

    public void addSelectionListener(SelectionChangeListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionChangeListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void fireSelectionChanged() {
        for (SelectionChangeListener listener : this.selectionListeners) {
            listener.selectionChanged();
        }
    }
}

