/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.calltree.TopRecursiveBlockNode;
import amida.logcompactor.foldrule.LoopFoldRule;
import amida.logcompactor.foldrule.RecursiveCallFoldRule;
import amida.node.comparator.SameMethodNodeComparator;
import amida.utility.Pair;
import amida.utility.ProgressListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class Compactor {
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private int treeEndNum = 0;
    private int endCount = 0;

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(listener);
    }

    private void fireProgress(int value) {
        for (ProgressListener listener : this.listeners) {
            listener.progress(value, this.treeEndNum);
        }
    }

    public void omitRecursiveCall(NodeList nodes) {
        HashMap<Node, Integer> treeEndIndexMap = new HashMap<Node, Integer>();
        this.setTreeEndNum(this.treeEndHashCount(nodes, treeEndIndexMap));
        this.fireProgress(this.endCount);
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        CallTreeIterator it = nodes.nodeIterator();
        SameMethodNodeComparator comp = new SameMethodNodeComparator(1);
        HashSet<Node> alreadyReadyEnd = new HashSet<Node>();
        Stack<Node> nodeStack = new Stack<Node>();
        Stack iteratorStack = new Stack();
        Node node = null;
        HashMap<String, List<Integer>> methodMap = new HashMap<String, List<Integer>>();
        ArrayList<Integer> recIndexList = new ArrayList<Integer>();
        while (it.hasNext() || !iteratorStack.empty()) {
            int index;
            Iterator listIt;
            List<Integer> callList;
            CallNode call;
            if (!it.hasNext()) {
                it = (CallTreeIterator)iteratorStack.pop();
                node = (Node)nodeStack.pop();
                continue;
            }
            methodMap.clear();
            Node top = null;
            ListIterator stackIt = nodeStack.listIterator();
            int count = 0;
            boolean notTreated = false;
            recIndexList.clear();
            while (stackIt.hasNext()) {
                node = (Node)stackIt.next();
                if (node instanceof CallNode) {
                    call = (CallNode)node;
                    if (top == null) {
                        if (methodMap.containsKey(call.getMethodName())) {
                            callList = (List)methodMap.get(call.getMethodName());
                            listIt = callList.iterator();
                            while (listIt.hasNext()) {
                                index = (Integer)listIt.next();
                                if (comp.compareNode(call, (Node)nodeStack.get(index)) != 0) continue;
                                top = (CallNode)nodeStack.get(index);
                                if (!((CallNode)top).isRecursive() || !call.isRecursive()) {
                                    notTreated = true;
                                }
                                recIndexList.add(new Integer(index));
                                recIndexList.add(new Integer(count));
                                break;
                            }
                            if (top == null) {
                                callList.add(new Integer(count));
                            }
                        } else {
                            callList = new ArrayList<Integer>();
                            callList.add(new Integer(count));
                            methodMap.put(call.getMethodName(), callList);
                        }
                    } else if (comp.compareNode(call, top) == 0) {
                        if (!call.isRecursive()) {
                            notTreated = true;
                        }
                        recIndexList.add(new Integer(count));
                    }
                }
                ++count;
            }
            while (it.hasNext()) {
                node = it.next();
                if (node instanceof CallNode) {
                    call = (CallNode)node;
                    if (top == null) {
                        if (methodMap.containsKey(call.getMethodName())) {
                            callList = (List)methodMap.get(call.getMethodName());
                            listIt = callList.iterator();
                            while (listIt.hasNext()) {
                                index = (Integer)listIt.next();
                                if (comp.compareNode(call, (Node)nodeStack.get(index)) != 0) continue;
                                top = (CallNode)nodeStack.get(index);
                                if (!((CallNode)top).isRecursive() || !call.isRecursive()) {
                                    notTreated = true;
                                }
                                recIndexList.add(new Integer(index));
                                recIndexList.add(new Integer(count));
                                break;
                            }
                            if (top == null) {
                                callList.add(new Integer(count));
                            }
                        } else {
                            callList = new ArrayList();
                            callList.add(new Integer(count));
                            methodMap.put(call.getMethodName(), callList);
                        }
                    } else if (comp.compareNode(call, top) == 0) {
                        if (!call.isRecursive()) {
                            notTreated = true;
                        }
                        recIndexList.add(new Integer(count));
                    }
                }
                nodeStack.push(node);
                iteratorStack.push(it);
                ++count;
                it = node.nodeIterator();
            }
            if (!alreadyReadyEnd.contains(node)) {
                alreadyReadyEnd.add(node);
            } else {
                top = null;
            }
            if (!notTreated) {
                top = null;
            }
            if (top != null) {
                Node before = top;
                Node parent = top.getParent();
                if (parent == null || !(parent instanceof TopRecursiveBlockNode)) {
                    try {
                        before = (CallNode)((CallNode)top).clone();
                        before.setParent(top.getParent());
                    }
                    catch (CloneNotSupportedException e) {
                        System.err.println("can not clone at omitRecursive");
                        return;
                    }
                }
                Node[] nodeArray = nodeStack.toArray(new Node[0]);
                Iterator[] itArray = iteratorStack.toArray(new Iterator[0]);
                Pair<List<CallNode>, List<Iterator<?>>> pair = RecursiveCallFoldRule.makeRecursiveList(recIndexList, nodeStack, iteratorStack, comp, (CallNode)top);
                List<CallNode> recList = pair.getFirst();
                List<Iterator<?>> itList = pair.getSecond();
                List<Integer> includes = RecursiveCallFoldRule.getIncludeList(recList, comp);
                nodeStack.pop();
                it = (CallTreeIterator)iteratorStack.pop();
                if (includes.size() > 0) {
                    CallTreeIterator it2 = it;
                    int position = includes.get(0);
                    CallNode rec = recList.get(position);
                    rec.setRecursive(true);
                    it2.set(rec);
                    int start = (Integer)recIndexList.get(0);
                    int end = (Integer)recIndexList.get(0);
                    int i = 1;
                    while (i < includes.size()) {
                        end = (Integer)recIndexList.get(i) - 1;
                        int j = start;
                        while (j < end) {
                            nodeStack.push(nodeArray[j]);
                            iteratorStack.push(itArray[j]);
                            ++j;
                        }
                        start = (Integer)recIndexList.get(i);
                        it2 = (CallTreeIterator)itList.get(position + 1);
                        position = includes.get(i);
                        rec = recList.get(position);
                        rec.setRecursive(true);
                        it2.set(rec);
                        ++i;
                    }
                    if (parent == null || !(parent instanceof TopRecursiveBlockNode)) {
                        CallNode after = recList.get(includes.get(0));
                        TopRecursiveBlockNode recursive = new TopRecursiveBlockNode(after, (CallNode)before);
                        it.set(recursive);
                    }
                    if (position == recList.size() - 1) {
                        end = nodeArray.length;
                        int j = start;
                        while (j < end) {
                            nodeStack.push(nodeArray[j]);
                            iteratorStack.push(itArray[j]);
                            ++j;
                        }
                        nodeStack.pop();
                        it = (CallTreeIterator)iteratorStack.pop();
                    } else {
                        it = (CallTreeIterator)itArray[end];
                    }
                    it.previous();
                }
            } else {
                nodeStack.pop();
                it = (CallTreeIterator)iteratorStack.pop();
            }
            if (!treeEndIndexMap.containsKey(node)) continue;
            this.fireProgress((Integer)treeEndIndexMap.get(node) - 1);
        }
        this.fireProgress(this.treeEndNum);
        nodes.getCallTree().fireDataChange();
    }

    public void omitRecursiveCall(CallTree tree) {
        NodeList nodes = tree.getTopNodeList();
        this.omitRecursiveCall(nodes);
    }

    private int treeEndCount(CallTree tree) {
        return this.treeEndCount(tree.getTopNodeList());
    }

    private int treeEndCount(NodeList list) {
        CallTreeIterator it = list.nodeIterator();
        Stack<CallTreeIterator> stack = new Stack<CallTreeIterator>();
        int count = 0;
        while (it.hasNext() || !stack.isEmpty()) {
            if (it.hasNext()) {
                Node node = it.next();
                if (node.hasChildren()) {
                    stack.push(it);
                    it = it.nextIterator();
                    continue;
                }
                ++count;
                continue;
            }
            it = (CallTreeIterator)stack.pop();
        }
        return count;
    }

    private int treeEndHashCount(NodeList list, Map<Node, Integer> map) {
        CallTreeIterator it = list.nodeIterator();
        Stack<CallTreeIterator> stack = new Stack<CallTreeIterator>();
        int count = 0;
        while (it.hasNext() || !stack.isEmpty()) {
            if (it.hasNext()) {
                Node node = it.next();
                if (node.hasChildren()) {
                    stack.push(it);
                    it = it.nextIterator();
                    continue;
                }
                map.put(node, new Integer(count));
                ++count;
                continue;
            }
            it = (CallTreeIterator)stack.pop();
        }
        return count;
    }

    public void foldLoop(LoopFoldRule rule, CallTree callTree) {
        if (rule == null || callTree == null) {
            return;
        }
        this.setTreeEndNum(this.treeEndCount(callTree));
        this.endCount = 0;
        this.fireProgress(this.endCount);
        this.foldLoop_i(callTree.getTopNodeList(), rule);
        this.fireProgress(this.treeEndNum);
        callTree.fireDataChange();
    }

    public void foldLoop(NodeList list, LoopFoldRule rule) {
        this.setTreeEndNum(this.treeEndCount(list));
        this.endCount = 0;
        this.fireProgress(this.endCount);
        this.foldLoop_i(list, rule);
        this.fireProgress(this.treeEndNum);
        list.getCallTree().fireDataChange();
    }

    private void foldLoop_i(NodeList list, LoopFoldRule rule) {
        CallTreeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.nextNode();
            if (!node.hasChildren()) {
                this.fireProgress(this.endCount++);
                continue;
            }
            this.foldLoop_i(node.getChildren(), rule);
        }
        it.reset();
        int callNodeNum = 1;
        ArrayList<Node> compareList = new ArrayList<Node>(it.size() / 2);
        while (callNodeNum * 2 <= it.countCallNode()) {
            CallTreeIterator.NodeIteratorView itView = it.getView();
            while (it.hasNext()) {
                List<Node> representList;
                ((CallTreeIterator)itView).reset();
                ArrayList<Node> firstList = new ArrayList<Node>(callNodeNum);
                int callNodeCount1 = 0;
                while (callNodeCount1 < callNodeNum && itView.hasNext()) {
                    Node node = itView.nextNode();
                    firstList.add(node);
                    callNodeCount1 += node.getCallNodeNum();
                }
                compareList.clear();
                int callNodeCount2 = 0;
                while (callNodeCount2 < callNodeNum && itView.hasNext()) {
                    Node node = itView.nextNode();
                    compareList.add(node);
                    callNodeCount2 += node.getCallNodeNum();
                }
                if (callNodeNum == callNodeCount1 && callNodeNum == callNodeCount2 && (representList = rule.makeRepresentList(firstList, compareList)) != null) {
                    int countLoopNum = 1;
                    int lastNodesCount = 0;
                    while (callNodeNum == callNodeCount1 && callNodeNum == callNodeCount2 && rule.checkLoop(representList, compareList)) {
                        ++countLoopNum;
                        compareList.clear();
                        callNodeCount2 = 0;
                        lastNodesCount = 0;
                        while (callNodeCount2 < callNodeNum && itView.hasNext()) {
                            Node node = itView.nextNode();
                            compareList.add(node);
                            callNodeCount2 += node.getCallNodeNum();
                            ++lastNodesCount;
                        }
                    }
                    LoopNode newLoopNode = rule.makeNewLoop(list.getCallTree());
                    int gap = itView.nextIndex() - lastNodesCount - it.nextIndex();
                    it.add(newLoopNode);
                    int i = 0;
                    while (i < gap) {
                        Node node = it.nextNode();
                        it.remove();
                        newLoopNode.addHiddenChild(node);
                        ++i;
                    }
                    newLoopNode.addLoopNum(countLoopNum);
                    newLoopNode.setRule(rule);
                    Iterator<Node> repIt = representList.iterator();
                    while (repIt.hasNext()) {
                        newLoopNode.addCoreChild(repIt.next());
                    }
                    continue;
                }
                it.next();
            }
            ++callNodeNum;
            it.reset();
        }
    }

    public int getTreeEndNum() {
        return this.treeEndNum;
    }

    public void setTreeEndNum(int treeEndNum) {
        this.treeEndNum = treeEndNum;
    }
}

