/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.gui;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.CallTreeManager;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.logcompactor.gui.BlockEntry;
import amida.logcompactor.gui.LogTextAreaFrame;
import amida.logcompactor.gui.LoopCanvas;
import amida.logcompactor.gui.NodeString;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class LogTextArea
extends JPanel {
    private static final long serialVersionUID = -1321486880351403299L;
    public static final int SERCH_DOWN = 0;
    public static final int SERCH_RISE = 1;
    public static final Color selectionColor = new Color(204, 204, 255);
    public boolean packageSerch = true;
    public boolean classSerch = true;
    public boolean methodSerch = true;
    public boolean idSerch = true;
    public boolean argSerch = true;
    private NodeList nodeList;
    private LoopCanvas loopCanvas;
    private int maxIndex = 0;
    private int selectedStart = -1;
    private int selectedEnd = -1;
    private List<NodeString> strings = new ArrayList<NodeString>();
    private List<BlockEntry> blocks = new ArrayList<BlockEntry>();
    private Dimension defaultSize = new Dimension(100, 100);
    private JScrollBar scrollBar = null;
    private int charWidth = 1;
    private int charHeight;
    private int tabSize = 1;
    private String searchText = null;

    public LogTextArea(final LogTextAreaFrame frame, int height, int width) {
        this.setPreferredSize(new Dimension(height, width));
        this.setMinimumSize(this.defaultSize);
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int y = e.getY();
                int line = y / LogTextArea.this.charHeight + 1;
                Node node1 = null;
                NodeString string = null;
                if (line <= LogTextArea.this.strings.size()) {
                    string = (NodeString)LogTextArea.this.strings.get(line - 1);
                    node1 = string.getNode();
                }
                if (CallTreeManager.getInstance().getCallTreeNum() <= 0) {
                    return;
                }
                if (node1 == null) {
                    LogTextArea.this.setSelectedRange(-1, -1);
                } else if (e.getClickCount() == 1) {
                    if (e.getModifiers() == 16) {
                        LogTextArea.this.setSelectedRange(string.getStart(), string.getEnd());
                    } else if (e.getModifiers() == 4) {
                        LogTextArea.this.setSelectedRange(-1, -1);
                    }
                } else if (e.getClickCount() == 2) {
                    node1.setBehind(!node1.isBehind());
                    LogTextArea.this.load();
                    LogTextArea.this.loopCanvas.renew();
                    int start = LogTextArea.this.getSelectedStart();
                    string = (NodeString)LogTextArea.this.strings.get(line - 1);
                    LogTextArea.this.setSelectedRange(start, string.getEnd());
                    LogTextArea.this.resize();
                    frame.getScrollPane().revalidate();
                }
                LogTextArea.this.requestFocusInWindow();
                LogTextArea.this.repaint();
                LogTextArea.this.loopCanvas.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index = 0;
                if (e.getKeyCode() == 40) {
                    NodeString nstr;
                    index = LogTextArea.this.getSelectedEnd();
                    if (LogTextArea.this.getStrings().size() <= index || index < 0) {
                        return;
                    }
                    do {
                        if (LogTextArea.this.getStrings().size() > ++index) continue;
                        return;
                    } while ((nstr = LogTextArea.this.getStrings().get(index)).getType() != NodeString.START);
                    LogTextArea.this.setSelectedRange(nstr.getStart(), nstr.getEnd());
                    if (!LogTextArea.this.isInViewRange(index + 1)) {
                        int viewLine;
                        int size = nstr.getEnd() - nstr.getStart() + 1;
                        if (size <= (viewLine = LogTextArea.this.getViewLineNum())) {
                            LogTextArea.this.scroll(index + size - viewLine);
                        } else {
                            LogTextArea.this.scroll(index);
                        }
                    }
                } else if (e.getKeyCode() == 38) {
                    index = LogTextArea.this.getSelectedStart() - 1;
                    if (LogTextArea.this.getStrings().size() <= index || index < 0) {
                        return;
                    }
                    NodeString nstr = LogTextArea.this.getStrings().get(index);
                    LogTextArea.this.setSelectedRange(nstr.getStart(), nstr.getEnd());
                    index = nstr.getStart() - 1;
                    if (!LogTextArea.this.isInViewRange(index)) {
                        LogTextArea.this.scroll(index);
                    }
                } else if (e.getKeyCode() == 37) {
                    Node node;
                    index = LogTextArea.this.getSelectedStart();
                    if (LogTextArea.this.getStrings().size() <= index || index < 0) {
                        return;
                    }
                    NodeString nstr = LogTextArea.this.getStrings().get(index);
                    Node parent = nstr.getNode().getParent();
                    if (parent == null) {
                        return;
                    }
                    do {
                        if (--index >= 0) continue;
                        return;
                    } while ((node = (nstr = LogTextArea.this.getStrings().get(index)).getNode()) != parent);
                    LogTextArea.this.setSelectedRange(nstr.getStart(), nstr.getEnd());
                    if (!LogTextArea.this.isInViewRange(index)) {
                        LogTextArea.this.scroll(index);
                    }
                } else if (e.getKeyCode() == 39) {
                    index = LogTextArea.this.getSelectedStart() + 1;
                    if (LogTextArea.this.getStrings().size() <= index || index < 0) {
                        return;
                    }
                    NodeString nstr = LogTextArea.this.getStrings().get(index);
                    LogTextArea.this.setSelectedRange(nstr.getStart(), nstr.getEnd());
                    if (!LogTextArea.this.isInViewRange(index + 1)) {
                        int viewLine;
                        int size = nstr.getEnd() - nstr.getStart() + 1;
                        if (size <= (viewLine = LogTextArea.this.getViewLineNum())) {
                            LogTextArea.this.scroll(index + size - viewLine);
                        } else {
                            LogTextArea.this.scroll(index);
                        }
                    }
                } else if (e.getKeyCode() == 114) {
                    if (e.isShiftDown()) {
                        LogTextArea.this.searchUp();
                    } else {
                        LogTextArea.this.searchDown();
                    }
                }
                LogTextArea.this.repaint();
            }
        });
        if (CallTreeManager.getInstance().getCallTreeNum() <= 0) {
            return;
        }
        this.nodeList = CallTreeManager.getInstance().getCallTree(0).getTopNodeList();
    }

    protected void setLoopCanvas(LoopCanvas loop) {
        this.loopCanvas = loop;
    }

    public void setNodeList(NodeList list) {
        this.nodeList = list;
    }

    public NodeList getNodeList() {
        return this.nodeList;
    }

    public List<NodeString> getStrings() {
        return this.strings;
    }

    public void load() {
        this.clear();
        NodeList nodes = this.getNodeList();
        if (nodes != null) {
            this.remake(this.getNodeList(), this.getStrings(), 0);
            this.resize();
            this.revalidate();
        }
    }

    private void remake(NodeList list, List<NodeString> strings, int callDepth) {
        CallTreeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (node instanceof CallNode) {
                CallNode call = (CallNode)node;
                int start = strings.size();
                NodeString entry = new NodeString(call.getStartString(), call, start, start, call.getCallIndex(), NodeString.START, callDepth);
                strings.add(entry);
                this.maxIndex = call.getCallIndex();
                this.remake(node.getChildren(), strings, callDepth + 1);
                int end = strings.size();
                entry.setEnd(end);
                NodeString exit = new NodeString(call.getEndString(), call, start, end, -1, NodeString.END, callDepth);
                strings.add(exit);
                continue;
            }
            if (node instanceof LoopNode) {
                this.remake(node.getChildren(), strings, callDepth);
                continue;
            }
            if (!(node instanceof BlockNode)) continue;
            int start = strings.size();
            StringBuffer buffer = new StringBuffer();
            BlockEntry blockEntry = new BlockEntry(start + 1, 0, callDepth);
            this.blocks.add(blockEntry);
            NodeString methodEntry = new NodeString(buffer.toString(), node, start, 0, -1, NodeString.NONE, callDepth);
            strings.add(methodEntry);
            this.remake(node.getChildren(), strings, callDepth);
            int end = strings.size();
            blockEntry.setEnd(end + 1);
            methodEntry.setEnd(end);
            strings.add(new NodeString(buffer.toString(), node, start, end, -1, NodeString.NONE, callDepth));
        }
    }

    public void clear() {
        this.strings.clear();
        this.blocks.clear();
    }

    public int getLineCount() {
        return this.strings.size();
    }

    public void resize() {
        Dimension size = new Dimension((int)this.getSize().getWidth(), this.charHeight * this.strings.size() + 5);
        this.setSize(size);
        this.setPreferredSize(size);
        this.revalidate();
    }

    public void setScrollBar(JScrollBar scrollBar) {
        this.scrollBar = scrollBar;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void scroll(int nstrIndex) {
        double max = this.getSize().getHeight();
        double rate = (double)(nstrIndex * this.charHeight) / max;
        BoundedRangeModel model = this.getScrollBar().getModel();
        int value = (int)((double)model.getMaximum() * rate);
        model.setValue(value);
        this.revalidate();
    }

    protected boolean isInViewRange(int nstrIndex) {
        BoundedRangeModel model = this.getScrollBar().getModel();
        double maxIndex = this.getStrings().size();
        if (maxIndex == 0.0) {
            return false;
        }
        double rate = (double)(nstrIndex + 1) / maxIndex;
        int value = model.getValue();
        int extent = model.getExtent();
        double max = model.getMaximum();
        if (max == 0.0) {
            return false;
        }
        return rate >= (double)value / max && rate <= (double)(value + extent) / max;
    }

    protected int getViewLineNum() {
        BoundedRangeModel model = this.getScrollBar().getModel();
        double rate = (double)model.getExtent() / (double)model.getMaximum();
        return (int)(this.getSize().getHeight() / (double)this.getCharHeight() * rate);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.charHeight <= 1) {
            this.charHeight = g.getFontMetrics().getHeight();
            this.charWidth = g.getFontMetrics().charWidth('1');
            this.resize();
        }
        if (this.scrollBar == null) {
            Container comp = this;
            while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
            }
            if (comp != null) {
                this.scrollBar = ((JScrollPane)comp).getVerticalScrollBar();
            }
        }
        Dimension size = this.getSize();
        if (this.scrollBar == null) {
            boolean y = false;
            int n = (int)size.getHeight();
        }
        BoundedRangeModel model = this.scrollBar.getModel();
        int y = (int)((double)size.height * ((double)model.getValue() / (double)model.getMaximum()));
        int height = (int)((double)size.height * ((double)model.getExtent() / (double)model.getMaximum()));
        int maxLineNumDigit = 1;
        if (!this.strings.isEmpty()) {
            maxLineNumDigit = Integer.toString(this.maxIndex).length() + 1;
        }
        int minLine = y / this.charHeight;
        int maxLine = (y + height) / this.charHeight + 1;
        if (this.selectedStart < this.selectedEnd) {
            g.setColor(selectionColor);
            g.fillRect(0, this.selectedStart * this.charHeight + 3, (int)this.getSize().getWidth(), (this.selectedEnd - this.selectedStart + 1) * this.charHeight);
        }
        g.setColor(Color.BLACK);
        g.drawLine(maxLineNumDigit * this.charWidth + 8, y, maxLineNumDigit * this.charWidth + 8, y + height);
        int i = minLine;
        while (i < maxLine) {
            if (i < this.strings.size()) {
                this.drawString(g, i, maxLineNumDigit);
            }
            ++i;
        }
        this.drawBlock(g, minLine, maxLine, maxLineNumDigit);
    }

    private void drawBlock(Graphics g, int minLine, int maxLine, int maxDigit) {
        int xBase = maxDigit * this.charWidth + 10;
        for (BlockEntry entry : this.blocks) {
            int start = entry.getStart();
            if (start == 1) {
                start = 1;
            }
            int end = entry.getEnd();
            if (start > maxLine) {
                return;
            }
            if (end < minLine) continue;
            int width = 0;
            int i = start;
            while (i < end) {
                String str = null;
                try {
                    str = this.strings.get(i).getString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int tmpWidth = (this.checkTabNum(str) - entry.getIndent()) * this.tabSize * this.charWidth + g.getFontMetrics().stringWidth(str);
                if (tmpWidth > width) {
                    width = tmpWidth;
                }
                ++i;
            }
            g.drawRect(xBase + entry.getIndent() * this.tabSize * this.charWidth, (int)(((double)start - 0.5) * (double)this.charHeight), width + 20, (int)(((double)(end - start) + 0.5) * (double)this.charHeight));
        }
    }

    private void drawString(Graphics g, int line, int maxDigit) {
        NodeString nstr = this.strings.get(line);
        this.drawLineNumber(g, line, nstr.getIndex(), maxDigit);
        if (nstr.getNode() instanceof CallNode) {
            String str = nstr.getString();
            g.setColor(nstr.getColor());
            int tabNum = nstr.getDepth();
            g.drawString(str, maxDigit * this.charWidth + 13 + tabNum * this.tabSize * this.charWidth, (line + 1) * this.charHeight);
        }
    }

    private void drawLineNumber(Graphics g, int line, int num, int maxDigit) {
        if (num == -1) {
            return;
        }
        String lineNum = String.valueOf(num);
        int digit = lineNum.length();
        g.setColor(Color.BLACK);
        g.drawString(lineNum, (maxDigit - digit) * this.charWidth + 5, (line + 1) * this.charHeight);
    }

    private int checkTabNum(String str) {
        int size = str.length();
        int i = 0;
        while (i < size && str.charAt(i) == '\t') {
            ++i;
        }
        return i;
    }

    protected void setSelectedStart(int line) {
        this.selectedStart = line;
    }

    private int getSelectedStart() {
        return this.selectedStart;
    }

    protected void setSelectedEnd(int line) {
        this.selectedEnd = line;
    }

    protected int getSelectedEnd() {
        return this.selectedEnd;
    }

    protected void setSelectedRange(int start, int end) {
        this.setSelectedStart(start);
        this.setSelectedEnd(end);
    }

    protected int getCharHeight() {
        return this.charHeight;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int search(String key, int startLine, int direction) {
        if (key == null) {
            return -1;
        }
        if (startLine < 0) {
            startLine = 0;
        }
        this.searchText = key;
        if (direction == 0) {
            int size = this.getStrings().size();
            int i = startLine;
            while (i < size) {
                NodeString nst = this.getStrings().get(i);
                boolean result = false;
                if (nst.getString().indexOf(key) != -1) {
                    result = true;
                }
                if (result) {
                    this.setSelectedRange(i, i + nst.getEnd() - 1);
                    if (!this.isInViewRange(i)) {
                        this.scroll(i);
                    }
                    this.repaint();
                    return i;
                }
                ++i;
            }
        } else {
            int i = startLine;
            while (i >= 0) {
                NodeString nst = this.getStrings().get(i);
                boolean result = false;
                if (nst.getString().indexOf(key) != -1) {
                    result = true;
                }
                if (result) {
                    this.setSelectedRange(i, i + nst.getEnd() - 1);
                    if (!this.isInViewRange(i)) {
                        this.scroll(i);
                    }
                    this.repaint();
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public int searchDown(String key) {
        return this.search(key, this.getSelectedStart() + 1, 0);
    }

    public int searchDown() {
        return this.search(this.searchText, this.getSelectedStart() + 1, 0);
    }

    public int searchUp(String key) {
        return this.search(key, this.getSelectedStart() - 1, 1);
    }

    public int searchUp() {
        return this.search(this.searchText, this.getSelectedStart() - 1, 1);
    }
}

