/*
 * Decompiled with CFR 0.152.
 */
package amida.logcompactor.gui;

import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.CallTreeManager;
import amida.calltree.Node;
import amida.calltree.NodeList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.JPanel;

public class WorkingSetCanvas
extends JPanel {
    private static final long serialVersionUID = 2449423811496289293L;
    public static final int METHOD_PROT = 1;
    public static final int OBJECT_PROT = 2;
    private static final Insets margin = new Insets(10, 10, 0, 0);
    private static int xLength = 5;
    private int protMode;
    private List<Point> protList = new LinkedList<Point>();

    public WorkingSetCanvas(int protMode) {
        this.setPreferredSize(new Dimension(200, 800));
        this.setBackground(Color.white);
        this.protMode = protMode;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        for (Point prot : this.protList) {
            g.drawLine((int)prot.getX() * xLength + WorkingSetCanvas.margin.left, (int)prot.getY() + WorkingSetCanvas.margin.top, ((int)prot.getX() - 1) * xLength + WorkingSetCanvas.margin.left, (int)prot.getY() + WorkingSetCanvas.margin.top);
        }
    }

    public void prot() {
        if (CallTreeManager.getInstance().getCallTreeNum() <= 0) {
            return;
        }
        NodeList list = CallTreeManager.getInstance().getCallTree(0).getTopNodeList();
        if (list == null) {
            return;
        }
        this.protList.clear();
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Stack<CallTreeIterator> itStack = new Stack<CallTreeIterator>();
        CallTreeIterator it = list.nodeIterator();
        int keyNum = 0;
        int index = 0;
        while (it.hasNext() || !itStack.isEmpty()) {
            if (!it.hasNext()) {
                it = (CallTreeIterator)itStack.pop();
                continue;
            }
            Node node = it.next();
            if (node instanceof CallNode) {
                ++index;
                CallNode call = (CallNode)node;
                Object key = this.keyMaker(call);
                if (map.containsKey(key)) {
                    Integer num = (Integer)map.get(key);
                    this.protList.add(new Point(num, index));
                } else {
                    map.put(key, new Integer(++keyNum));
                    this.protList.add(new Point(keyNum, index));
                }
            }
            itStack.push(it);
            it = it.nextIterator();
        }
        this.setPreferredSize(new Dimension(map.size() * xLength + 20, index + 20));
        this.revalidate();
    }

    private Object keyMaker(CallNode call) {
        if (this.protMode == 1) {
            return String.valueOf(call.getFullClassName()) + "." + call.getMethodName();
        }
        if (this.protMode == 2) {
            return call.getId().iterator().next();
        }
        return null;
    }
}

