/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java.data;

import amida.staticdata.ClassData;
import amida.staticdata.Field;
import amida.staticdata.IllegalStaticDataConditionException;
import amida.staticdata.MethodData;
import amida.staticdata.Type;
import amida.staticdata.java.data.JavaField;
import amida.staticdata.java.data.JavaMethod;
import amida.staticdata.java.data.JavaPackage;
import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.ReferenceType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JavaClassOrInterface
implements ReferenceType,
ClassData {
    private static final int UNDECIDED = 0;
    private static final int CLASS = 1;
    private static final int INTERFACE = 2;
    private static final Map<JavaPackage, Map<String, JavaClassOrInterface>> packages = new HashMap<JavaPackage, Map<String, JavaClassOrInterface>>();
    private final String name;
    private final String fullName;
    private final String simpleJavaTypeName;
    private final JavaPackage pack;
    private int type;
    private final Set<JavaClassOrInterface> subClasses = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> superClasses = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> subInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> superInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> implementInterfaces = new HashSet<JavaClassOrInterface>();
    private final Set<JavaClassOrInterface> implementers = new HashSet<JavaClassOrInterface>();
    private final Set<JavaMethod> methods = new HashSet<JavaMethod>();
    private final Map<String, Set<JavaMethod>> methodMap = new HashMap<String, Set<JavaMethod>>();
    private final Set<Field> fields = new HashSet<Field>();
    private final Set<JavaMethod> innerClasses = new HashSet<JavaMethod>();

    protected JavaClassOrInterface(JavaPackage pack, String name, int type) {
        this.pack = pack;
        this.name = name.intern();
        this.type = type;
        this.fullName = pack.getName().length() == 0 ? name.intern() : (String.valueOf(pack.getName()) + '.' + name).intern();
        this.simpleJavaTypeName = "L" + this.fullName.replace('.', '/') + ";";
        this.simpleJavaTypeName.intern();
        packages.get(pack).put(name, this);
    }

    public static JavaClassOrInterface makeClassOrInterface(JavaPackage pack, String name) {
        if (packages.containsKey(pack)) {
            Map<String, JavaClassOrInterface> map = packages.get(pack);
            if (map.containsKey(name)) {
                return map.get(name);
            }
            JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, name, 0);
            map.put(name, newCOI);
            return newCOI;
        }
        COIMap newMap = new COIMap();
        packages.put(pack, newMap);
        JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, name, 0);
        newMap.put(name, newCOI);
        return newCOI;
    }

    public static JavaClassOrInterface getClassOrInterface(JavaPackage pack, String name) {
        Map<String, JavaClassOrInterface> map;
        if (packages.containsKey(pack) && (map = packages.get(pack)).containsKey(name)) {
            return map.get(name);
        }
        return null;
    }

    public static JavaClassOrInterface makeClass(JavaPackage pack, String className) throws IllegalStaticDataConditionException {
        if (packages.containsKey(pack)) {
            COIMap map = (COIMap)packages.get(pack);
            if (map.containsKey(className)) {
                JavaClassOrInterface coi = map.getClass(className);
                if (coi != null) {
                    return coi;
                }
                coi = map.getUndecided(className);
                if (coi != null) {
                    coi.toClass();
                    return coi;
                }
                return null;
            }
            JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, className, 1);
            map.put(className, newCOI);
            return newCOI;
        }
        COIMap newMap = new COIMap();
        packages.put(pack, newMap);
        JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, className, 1);
        newMap.put(className, newCOI);
        return newCOI;
    }

    public static JavaClassOrInterface getClass(JavaPackage pack, String className) throws IllegalStaticDataConditionException {
        COIMap map;
        if (packages.containsKey(pack) && (map = (COIMap)packages.get(pack)).containsKey(className)) {
            JavaClassOrInterface coi = map.getClass(className);
            if (coi != null) {
                return coi;
            }
            coi = map.getUndecided(className);
            if (coi != null) {
                coi.toClass();
                return coi;
            }
        }
        return null;
    }

    public static JavaClassOrInterface makeInterface(JavaPackage pack, String interfaceName) throws IllegalStaticDataConditionException {
        if (packages.containsKey(pack)) {
            COIMap map = (COIMap)packages.get(pack);
            if (map.containsKey(interfaceName)) {
                JavaClassOrInterface coi = map.getInterface(interfaceName);
                if (coi != null) {
                    return coi;
                }
                coi = map.getUndecided(interfaceName);
                if (coi != null) {
                    coi.toInterface();
                    return coi;
                }
                return null;
            }
            JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, interfaceName, 2);
            map.put(interfaceName, newCOI);
            return newCOI;
        }
        COIMap newMap = new COIMap();
        packages.put(pack, newMap);
        JavaClassOrInterface newCOI = new JavaClassOrInterface(pack, interfaceName, 2);
        newMap.put(interfaceName, newCOI);
        return newCOI;
    }

    public static JavaClassOrInterface getInterface(JavaPackage pack, String interfaceName) throws IllegalStaticDataConditionException {
        COIMap map;
        if (packages.containsKey(pack) && (map = (COIMap)packages.get(pack)).containsKey(interfaceName)) {
            JavaClassOrInterface coi = map.getInterface(interfaceName);
            if (coi != null) {
                return coi;
            }
            coi = map.getUndecided(interfaceName);
            if (coi != null) {
                coi.toInterface();
                return coi;
            }
        }
        return null;
    }

    public static int getInterfaceNum(JavaPackage pack) {
        if (packages.containsKey(pack)) {
            return ((COIMap)packages.get(pack)).getInterfaceNum();
        }
        return 0;
    }

    public static int getAllInterfaceNum() {
        int sum = 0;
        Iterator<Map<String, JavaClassOrInterface>> it = packages.values().iterator();
        while (it.hasNext()) {
            sum += JavaClassOrInterface.getInterfaceNum((JavaPackage)((Object)it.next()));
        }
        return sum;
    }

    public static int getClassNum(JavaPackage pack) {
        if (packages.containsKey(pack)) {
            return ((COIMap)packages.get(pack)).getClassNum();
        }
        return 0;
    }

    public static int getAllClassNum() {
        int sum = 0;
        Iterator<Map<String, JavaClassOrInterface>> it = packages.values().iterator();
        while (it.hasNext()) {
            sum += JavaClassOrInterface.getClassNum((JavaPackage)((Object)it.next()));
        }
        return sum;
    }

    public static int getClassOrInterfaceNum(JavaPackage pack) {
        if (packages.containsKey(pack)) {
            return packages.get(pack).size();
        }
        return 0;
    }

    public static int getAllClassOrInterfaceNum() {
        int sum = 0;
        Iterator<Map<String, JavaClassOrInterface>> it = packages.values().iterator();
        while (it.hasNext()) {
            sum += JavaClassOrInterface.getClassOrInterfaceNum((JavaPackage)((Object)it.next()));
        }
        return sum;
    }

    public JavaPackage getPackage() {
        return this.pack;
    }

    @Override
    public String getTypeName() {
        return this.fullName;
    }

    @Override
    public String getSimpleTypeName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isClass() {
        return this.type == 1;
    }

    public boolean isInterface() {
        return this.type == 2;
    }

    public boolean toClass() throws IllegalStaticDataConditionException {
        this.type = 1;
        COIMap map = (COIMap)packages.get(this.getPackage());
        return map.moveToClassMap(this.getTypeName());
    }

    public boolean toInterface() throws IllegalStaticDataConditionException {
        this.type = 2;
        COIMap map = (COIMap)packages.get(this.getPackage());
        Iterator<JavaClassOrInterface> itr = this.implementInterfaces.iterator();
        while (itr.hasNext()) {
            JavaClassOrInterface inter = itr.next();
            itr.remove();
            this.superInterfaces.add(inter);
            inter.removeSubClass(this);
            this.addSubClass(this);
        }
        itr = this.superClasses.iterator();
        while (itr.hasNext()) {
            JavaClassOrInterface superClass = itr.next();
            if (superClass.getFullName().equals("java.lang.Object")) continue;
            if (superClass.isClass()) {
                throw new IllegalStaticDataConditionException("interface " + this.getFullName() + " extend class " + superClass.getFullName() + ".");
            }
            if (superClass.isInterface()) continue;
            itr.remove();
            superClass.toInterface();
            this.superInterfaces.add(superClass);
            superClass.removeSubClass(this);
            this.addSubClass(this);
        }
        itr = this.subClasses.iterator();
        while (itr.hasNext()) {
            JavaClassOrInterface subClass = itr.next();
            itr.remove();
            if (subClass.isInterface()) {
                subClass.removeSuperClass(this);
                this.subInterfaces.add(subClass);
                subClass.addSuperClass(this);
                continue;
            }
            subClass.removeSuperClass(this);
            this.implementers.add(subClass);
            subClass.addSuperClass(this);
        }
        return map.moveToInterfaceMap(this.getName());
    }

    @Override
    public Collection<JavaClassOrInterface> getSubClasses() {
        return Collections.unmodifiableSet(this.subClasses);
    }

    @Override
    public Collection<JavaClassOrInterface> getSuperClasses() {
        return Collections.unmodifiableSet(this.superClasses);
    }

    public Collection<JavaClassOrInterface> getImplementInterfaces() {
        return Collections.unmodifiableSet(this.implementInterfaces);
    }

    public Collection<JavaClassOrInterface> getSuperInterfaces() {
        return Collections.unmodifiableSet(this.superInterfaces);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Collection<JavaMethod> getMethods(String name) {
        if (this.methodMap.containsKey(name)) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            return Collections.unmodifiableSet(methods);
        }
        return null;
    }

    public boolean hasMethod(String name) {
        return this.methodMap.containsKey(name);
    }

    @Override
    public Collection<Field> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    @Override
    public Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Collection<JavaMethod> getInnerClasses() {
        return Collections.unmodifiableSet(this.innerClasses);
    }

    @Override
    public String getNameSpace() {
        return this.getPackage().getName();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaClassOrInterface) {
            JavaClassOrInterface coi = (JavaClassOrInterface)o;
            return this == coi;
        }
        return super.equals(o);
    }

    @Override
    public String getSimpleJavaTypeName() {
        return this.simpleJavaTypeName;
    }

    @Override
    public void addSubClass(ClassData cl) throws IllegalStaticDataConditionException {
        if (cl instanceof JavaClassOrInterface) {
            JavaClassOrInterface jcl = (JavaClassOrInterface)cl;
            if (this.isInterface()) {
                if (jcl.isInterface()) {
                    if (!this.subInterfaces.contains(jcl)) {
                        this.subInterfaces.add(jcl);
                        jcl.addSuperClass(this);
                    }
                } else if (!this.implementers.contains(jcl)) {
                    this.implementers.add(jcl);
                    jcl.addSuperClass(this);
                }
            } else if (!jcl.isInterface()) {
                if (!this.subClasses.contains(jcl)) {
                    this.subClasses.add(jcl);
                    jcl.addSuperClass(this);
                }
            } else {
                if (this.isClass() && !this.getFullName().equals("java.lang.Object")) {
                    throw new IllegalStaticDataConditionException();
                }
                if (jcl.isInterface()) {
                    this.toInterface();
                    if (!this.subInterfaces.contains(jcl)) {
                        this.subInterfaces.add(jcl);
                        jcl.addSuperClass(this);
                    }
                } else if (!this.subClasses.contains(jcl)) {
                    this.subClasses.add(jcl);
                    jcl.addSuperClass(this);
                }
            }
        }
    }

    @Override
    public void addSuperClass(ClassData cl) throws IllegalStaticDataConditionException {
        boolean changed = false;
        if (cl instanceof JavaClassOrInterface) {
            JavaClassOrInterface jcl = (JavaClassOrInterface)cl;
            if (this.isInterface()) {
                if (jcl.isInterface()) {
                    if (!this.superInterfaces.contains(jcl)) {
                        this.superInterfaces.add(jcl);
                        jcl.addSubClass(this);
                        changed = true;
                    }
                } else {
                    if (jcl.isClass() && !jcl.getFullName().equals("java.lang.Object")) {
                        throw new IllegalStaticDataConditionException();
                    }
                    if (!jcl.getFullName().equals("java.lang.Object")) {
                        jcl.toInterface();
                        if (!this.superInterfaces.contains(jcl)) {
                            this.superInterfaces.add(jcl);
                            jcl.addSubClass(this);
                            changed = true;
                        }
                    }
                }
            } else if (jcl.isInterface()) {
                if (!this.implementInterfaces.contains(jcl)) {
                    this.implementInterfaces.add(jcl);
                    jcl.addSubClass(this);
                    changed = true;
                }
            } else if (!this.superClasses.contains(jcl)) {
                this.superClasses.add(jcl);
                jcl.addSubClass(this);
                changed = true;
            }
            if (changed) {
                this.resolveMethodHierarchyChange(jcl);
            }
        }
    }

    private void resolveMethodHierarchyChange(JavaClassOrInterface superCoi) {
        HashSet<JavaClassOrInterface> set = new HashSet<JavaClassOrInterface>();
        Collection<JavaMethod> methods = this.getMethods();
        for (JavaMethod method : methods) {
            method.resolveOverWride(superCoi, set);
        }
    }

    public void removeSubClass(JavaClassOrInterface coi) {
        this.subClasses.remove(coi);
        this.subInterfaces.remove(coi);
        this.implementers.remove(coi);
    }

    public void removeSuperClass(JavaClassOrInterface coi) {
        this.superClasses.remove(coi);
        this.superInterfaces.remove(coi);
        this.implementInterfaces.remove(coi);
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
        String methodName = method.getName();
        if (this.methodMap.containsKey(methodName)) {
            this.methodMap.get(methodName).add(method);
        } else {
            HashSet<JavaMethod> methods = new HashSet<JavaMethod>();
            methods.add(method);
            this.methodMap.put(methodName, methods);
        }
        method.resolveOverWride();
    }

    public void addField(JavaField field) {
        this.fields.add(field);
        if (field.isInstanceField()) {
            if (this.isInterface()) {
                throw new IllegalStaticDataConditionException("an instance field added to the Interface " + this.getFullName());
            }
            if (!this.isClass()) {
                this.toClass();
            }
        }
    }

    public boolean hasSuperClasses() {
        return !this.superClasses.isEmpty();
    }

    public boolean hasSuperInterfaces() {
        return !this.superInterfaces.isEmpty();
    }

    public boolean hasImplementInterfaces() {
        return !this.implementInterfaces.isEmpty();
    }

    public String toString() {
        return this.fullName;
    }

    @Override
    public boolean isSubClassOf(ClassData superClass) {
        if (superClass == null) {
            return false;
        }
        Collection<JavaClassOrInterface> supers = this.getSuperClasses();
        if (supers == null || supers.isEmpty()) {
            return false;
        }
        if (supers.contains(superClass)) {
            return true;
        }
        for (ClassData classData : supers) {
            if (!classData.isSubClassOf(superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMethod(String name, Type[] argTypes) {
        if (argTypes instanceof JavaType[]) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            for (JavaMethod method : methods) {
                Type[] types = method.getArgmentTypes();
                boolean match = true;
                int i = 0;
                while (i < types.length) {
                    if (argTypes[i] != types[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MethodData getMethod(String name, Type[] argTypes) {
        if (argTypes instanceof JavaType[]) {
            Set<JavaMethod> methods = this.methodMap.get(name);
            for (JavaMethod method : methods) {
                Type[] types = method.getArgmentTypes();
                boolean match = true;
                int i = 0;
                while (i < types.length) {
                    if (argTypes[i] != types[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public boolean hasField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static class COIMap
    implements Map<String, JavaClassOrInterface> {
        private final Map<String, JavaClassOrInterface> classMap = new HashMap<String, JavaClassOrInterface>();
        private final Map<String, JavaClassOrInterface> interfaceMap = new HashMap<String, JavaClassOrInterface>();
        private final Map<String, JavaClassOrInterface> undecidedMap = new HashMap<String, JavaClassOrInterface>();

        private COIMap() {
        }

        @Override
        public int size() {
            return this.classMap.size() + this.interfaceMap.size() + this.undecidedMap.size();
        }

        public int getClassNum() {
            return this.classMap.size();
        }

        public int getInterfaceNum() {
            return this.interfaceMap.size();
        }

        public int getUndecidedNum() {
            return this.undecidedMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.classMap.isEmpty() && this.interfaceMap.isEmpty() && this.undecidedMap.isEmpty();
        }

        public boolean classIsEmpty() {
            return this.classMap.isEmpty();
        }

        public boolean interfaceIsEmpty() {
            return this.interfaceMap.isEmpty();
        }

        public boolean undecidedIsEmpty() {
            return this.undecidedMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.classMap.containsKey(key) || this.interfaceMap.containsKey(key) || this.undecidedMap.containsKey(key);
        }

        public boolean containsClassKey(Object key) {
            return this.classMap.containsKey(key);
        }

        public boolean containsInterfaceKey(Object key) {
            return this.interfaceMap.containsKey(key);
        }

        public boolean containsUndecidedKey(Object key) {
            return this.undecidedMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.classMap.containsValue(value) || this.interfaceMap.containsValue(value) || this.undecidedMap.containsValue(value);
        }

        public boolean containsClassValue(Object value) {
            return this.classMap.containsValue(value);
        }

        public boolean containsInterfaceValue(Object value) {
            return this.interfaceMap.containsValue(value);
        }

        public boolean containsUndecidedValue(Object value) {
            return this.undecidedMap.containsValue(value);
        }

        @Override
        public JavaClassOrInterface get(Object name) {
            if (this.classMap.containsKey(name)) {
                return this.classMap.get(name);
            }
            if (this.interfaceMap.containsKey(name)) {
                return this.interfaceMap.get(name);
            }
            if (this.undecidedMap.containsKey(name)) {
                return this.undecidedMap.get(name);
            }
            return null;
        }

        public JavaClassOrInterface getClass(Object key) {
            if (this.classMap.containsKey(key)) {
                return this.classMap.get(key);
            }
            return null;
        }

        public JavaClassOrInterface getInterface(Object key) {
            if (this.interfaceMap.containsKey(key)) {
                return this.interfaceMap.get(key);
            }
            return null;
        }

        public JavaClassOrInterface getUndecided(Object key) {
            if (this.undecidedMap.containsKey(key)) {
                return this.undecidedMap.get(key);
            }
            return null;
        }

        @Override
        public JavaClassOrInterface put(String name, JavaClassOrInterface coi) {
            if (coi.isClass()) {
                return this.classMap.put(name, coi);
            }
            if (coi.isInterface()) {
                return this.interfaceMap.put(name, coi);
            }
            return this.undecidedMap.put(name, coi);
        }

        @Override
        public JavaClassOrInterface remove(Object name) {
            if (this.classMap.containsKey(name)) {
                return this.classMap.remove(name);
            }
            if (this.interfaceMap.containsKey(name)) {
                return this.interfaceMap.remove(name);
            }
            if (this.undecidedMap.containsKey(name)) {
                return this.undecidedMap.remove(name);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends JavaClassOrInterface> arg0) {
            for (String string : arg0.keySet()) {
                JavaClassOrInterface value = arg0.get(string);
                this.put(string, value);
            }
        }

        @Override
        public void clear() {
            this.classMap.clear();
            this.interfaceMap.clear();
            this.undecidedMap.clear();
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> result = new HashSet<String>();
            result.addAll((Collection)this.classMap.keySet());
            result.addAll((Collection)this.interfaceMap.keySet());
            result.addAll((Collection)this.undecidedMap.keySet());
            return result;
        }

        public Set<String> classKeySet() {
            return this.classMap.keySet();
        }

        public Set<String> interfaceKeySet() {
            return this.interfaceMap.keySet();
        }

        public Set<String> undecidedKeySet() {
            return this.undecidedMap.keySet();
        }

        @Override
        public Collection<JavaClassOrInterface> values() {
            HashSet<JavaClassOrInterface> result = new HashSet<JavaClassOrInterface>();
            result.addAll(this.classMap.values());
            result.addAll(this.interfaceMap.values());
            result.addAll(this.undecidedMap.values());
            return result;
        }

        public Collection<JavaClassOrInterface> classValues() {
            return this.classMap.values();
        }

        public Collection<JavaClassOrInterface> interfaceValues() {
            return this.interfaceMap.values();
        }

        public Collection<JavaClassOrInterface> undecidedValues() {
            return this.undecidedMap.values();
        }

        @Override
        public Set<Map.Entry<String, JavaClassOrInterface>> entrySet() {
            HashSet<Map.Entry<String, JavaClassOrInterface>> result = new HashSet<Map.Entry<String, JavaClassOrInterface>>();
            result.addAll((Collection)this.classMap.entrySet());
            result.addAll((Collection)this.interfaceMap.entrySet());
            result.addAll((Collection)this.undecidedMap.entrySet());
            return result;
        }

        public Set<Map.Entry<String, JavaClassOrInterface>> classEntrySet() {
            return this.classMap.entrySet();
        }

        public Set<Map.Entry<String, JavaClassOrInterface>> interfaceEntrySet() {
            return this.interfaceMap.entrySet();
        }

        public Set<Map.Entry<String, JavaClassOrInterface>> undecidedEntrySet() {
            return this.undecidedMap.entrySet();
        }

        private boolean moveToClassMap(String key) throws IllegalStaticDataConditionException {
            if (this.classMap.containsKey(key)) {
                return true;
            }
            if (this.interfaceMap.containsKey(key)) {
                throw new IllegalStaticDataConditionException("interface " + key + " is decided to class.");
            }
            JavaClassOrInterface coi = this.undecidedMap.get(key);
            this.undecidedMap.remove(key);
            this.classMap.put(key, coi);
            return true;
        }

        private boolean moveToInterfaceMap(String key) throws IllegalStaticDataConditionException {
            if (this.classMap.containsKey(key)) {
                throw new IllegalStaticDataConditionException("class " + key + " is decided as interface.");
            }
            if (this.interfaceMap.containsKey(key)) {
                return true;
            }
            JavaClassOrInterface coi = this.undecidedMap.get(key);
            this.undecidedMap.remove(key);
            this.interfaceMap.put(key, coi);
            return true;
        }
    }
}

