/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import java.util.ArrayList;

public class IDMatcher {
    private ArrayList<IDRange> rangeList;

    public IDMatcher(String pattern) {
        this.rangeList = this.parseRangeIDList(pattern);
    }

    public boolean match(int eventID) {
        if (this.rangeList.size() == 0) {
            return true;
        }
        for (IDRange range : this.rangeList) {
            if (!range.match(eventID)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<IDRange> parseRangeIDList(String arg) {
        ArrayList<IDRange> rangeList = new ArrayList<IDRange>();
        String[] args = arg.split(",");
        int i = 0;
        while (i < args.length) {
            String s = args[i].trim();
            if (s.length() != 0) {
                int idx = s.indexOf(45);
                if (idx >= 0) {
                    String start = s.substring(0, idx).trim();
                    String end = s.substring(idx + 1).trim();
                    try {
                        int startInt = 1;
                        if (start.length() > 0) {
                            startInt = Integer.valueOf(start);
                        }
                        int endInt = Integer.MAX_VALUE;
                        if (end.length() > 0) {
                            endInt = Integer.valueOf(end);
                        }
                        rangeList.add(new IDRange(startInt, endInt));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        int objID = Integer.valueOf(s);
                        rangeList.add(new IDRange(objID, objID));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return rangeList;
    }

    private static class IDRange {
        private int start;
        private int end;

        public IDRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean match(int objectID) {
            return this.start <= objectID && objectID <= this.end;
        }
    }
}

