/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.AbstractFilter;
import amida.viewer.filter.FilterChangeListener;
import amida.viewer.filter.FilterSet;
import amida.viewer.filter.FilterTableEditHandler;
import amida.viewer.filter.MethodFilter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MethodFilterTableEditHandler
extends FilterTableEditHandler {
    private static final String[] METHOD_FILTER_TYPE = new String[]{"Show", "Fold", "Hide", "Delete"};
    private static final String[] COLUMN_HEAD = new String[]{"Filter Type", "Timestamps", "Package Name", "Class Name", "Method Name", "Object IDs", "Use Regex"};

    public MethodFilterTableEditHandler(FilterChangeListener changeListener) {
        super(changeListener);
    }

    @Override
    protected String[] getTypeItems() {
        return METHOD_FILTER_TYPE;
    }

    @Override
    protected String[] getDefaultItem() {
        return new String[]{METHOD_FILTER_TYPE[2], "", "", "", "", "", ""};
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEAD.length;
    }

    @Override
    public String getColumnHead(int idx) {
        return COLUMN_HEAD[idx];
    }

    @Override
    protected void setItemAttribute(int index, AbstractFilter f) {
        assert (f instanceof MethodFilter);
        MethodFilter m = (MethodFilter)f;
        TableItem item = this.getTable().getItem(index);
        m.setTypeIndex(this.getTypeIndex(item));
        m.setTimestampCondition(item.getText(1));
        m.setPackageCondition(item.getText(2));
        m.setClassCondition(item.getText(3));
        m.setMethodCondition(item.getText(4));
        m.setObjectCondition(item.getText(5));
        m.setUseRegex(this.getUseRegexValue(item));
    }

    @Override
    protected void copyFilterAttributeToItem(TableItem item, AbstractFilter f) {
        assert (f instanceof MethodFilter);
        MethodFilter m = (MethodFilter)f;
        item.setText(0, this.getTypeItems()[m.getTypeIndex()]);
        item.setText(1, m.getTimestampCondition());
        item.setText(2, m.getPackageCondition());
        item.setText(3, m.getClassCondition());
        item.setText(4, m.getMethodCondition());
        item.setText(5, m.getObjectCondition());
        item.setText(6, this.getUseRegexString(f.getUseRegex()));
    }

    @Override
    protected void saveFilters(FilterSet filters) {
        Table table = this.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            MethodFilter f = new MethodFilter();
            this.setItemAttribute(i, f);
            filters.addMethodFilter(f);
            ++i;
        }
    }
}

