/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.binary_log;

import amida.agent.binary_log.DamidaBinaryFormat;
import amida.agent.flexible_log.DamidaFlexibleBinaryPrinter;
import amida.agent.flexible_log.DamidaFlexiblePrinter;
import java.io.IOException;

public class DamidaBinaryPrinter
extends DamidaFlexibleBinaryPrinter {
    public DamidaBinaryPrinter(boolean gzip) {
        super(gzip);
    }

    @Override
    public DamidaFlexiblePrinter<byte[]> clone() {
        return new DamidaBinaryPrinter(this.gzip);
    }

    @Override
    public void writeOutputStream(long log) throws IOException {
        this.out.write((int)(log & 0xFF00000000000000L) >> 56);
        this.out.write((int)(log & 0xFF000000000000L) >> 48);
        this.out.write((int)(log & 0xFF0000000000L) >> 40);
        this.out.write((int)(log & 0xFF00000000L) >> 32);
        this.out.write((int)(log & 0xFF000000L) >> 24);
        this.out.write((int)(log & 0xFF0000L) >> 16);
        this.out.write((int)(log & 0xFF00L) >> 8);
        this.out.write((int)(log & 0xFFL));
    }

    @Override
    public void writeOutputStream(char log) throws IOException {
        this.out.write((log & 0xFF000000) >> 24);
        this.out.write((log & 0xFF0000) >> 16);
        this.out.write((log & 0xFF00) >> 8);
        this.out.write(log & 0xFF);
    }

    @Override
    public void writeOutputStream(byte log) throws IOException {
        this.out.write(log);
    }

    @Override
    public void writeOutputStream(boolean log) throws IOException {
        this.out.write(log ? 1 : 0);
    }

    @Override
    public void writeOutputStream(String log) throws IOException {
        byte[] bs = log.getBytes();
        this.writeOutputStream(bs.length);
        this.writeOutputStream(bs);
    }

    @Override
    public void doFirst() {
        DamidaBinaryFormat.preThread(this, Thread.currentThread().getId());
    }

    @Override
    public void doFinal() {
        DamidaBinaryFormat.aftThread(this);
    }

    @Override
    public String getExp() {
        if (this.gzip) {
            return "dat.zip";
        }
        return "dat";
    }
}

