/*
 * Decompiled with CFR 0.152.
 */
package amida.agent.xml_log;

import amida.agent.feature.Feature;
import amida.agent.flexible_log.DamidaFlexibleFormat;
import amida.agent.flexible_log.DamidaFlexiblePrinter;
import amida.agent.xml_log.DamidaXMLLog;
import amida.agent.xml_log.DamidaXMLPrinter;
import java.io.IOException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.Instanceof;
import javassist.expr.MethodCall;
import javassist.expr.NewArray;
import javassist.expr.NewExpr;

public class DamidaXMLFormat
extends DamidaFlexibleFormat {
    public static final String PATH = DamidaXMLFormat.class.getName();
    public static final String LOG = String.valueOf(DamidaXMLLog.class.getName()) + ".LOG";
    public static final String TAG_THREAD = "Thread";
    public static final String TAG_CONSTRUCTOR = "Constructor";
    public static final String TAG_METHOD = "Method";
    public static final String TAG_FIELD = "Field";
    public static final String TAG_CAST = "Cast";
    public static final String TAG_INSTANSEOF = "Instanseof";
    public static final String TAG_HANDLER = "Handler";
    public static final String TAG_NEWARRAY = "NewArray";
    public static final String TAG_NEWEXPR = "NewExpr";
    public static final String TAG_INIT = "Init";
    public static final String TAG_RETURN = "Return";
    public static final String TAG_DEF_CLASS = "ClassDefine";
    public static final String TAG_DEF_CONSTRUCTOR = "ConstructorDefine";
    public static final String TAG_DEF_METHOD = "MethodDefine";
    public static final String TAG_DEF_FIELD = "FieldDefine";
    public static final String TAG_ANNOTATION = "Annotation";
    public static final String ATT_STAMP = " stamp=\"";
    public static final String ATT_DEC_CLASS = " declare_class=\"";
    public static final String ATT_CLASS = " class=\"";
    public static final String ATT_ID = " id=\"";
    public static final String ATT_NAME = " name=\"";
    public static final String ATT_VAL = " val=\"";
    public static final String ATT_PRM_DEC_CLASS = " param_declare_class=\"";
    public static final String ATT_PRM_CLASS = " param_class=\"";
    public static final String ATT_PRM_VAL = " param_val=\"";
    public static final String ATT_RTN_DEC_CLASS = " return_declare_class=\"";
    public static final String ATT_RTN_CLASS = " return_class=\"";
    public static final String ATT_RTN_VAL = " return_val=\"";
    public static final String ATT_ACS_TYPE = " access_type=\"";
    public static final String ATT_DEF_DEC_CLASS = " define_declare_class=\"";
    public static final String ATT_DEF_CLASS = " define_class=\"";
    public static final String ATT_DEF_ID = " define_id=\"";
    public static final String ATT_ENC_CLASS = " enclose_class=\"";
    public static final String ATT_ENC_ID = " enclose_id=\"";
    public static final String ATT_DIM = " dim=\"";
    public static final String ATT_SIZE = " size=\"";
    public static final String ATT_FEATURES = " features=\"";
    public static final String ATT_END = "\"";

    public static void annotation(String name, String val) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getAnnotation(name, val));
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void preThread(DamidaXMLPrinter printer, long id, String name) {
        try {
            printer.writeOutputStream(DamidaXMLFormat.getThreadHeader("" + id, name));
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void aftThread(DamidaXMLPrinter printer) {
        try {
            printer.writeOutputStream(DamidaXMLFormat.getThreadFooter());
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void preConstructorIn(String dec_cls, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getConstructorHeader(dec_cls, name, param_dec_cls, param_cls, param_val, features));
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void midConstructorIn(String dec_cls, Object callee) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getInit(DamidaXMLFormat.getType(dec_cls, callee), DamidaXMLFormat.getID(callee)));
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void aftConstructorIn() {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getConstructorFooter());
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void constructorCall(String dec_cls, Object callee, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getConstructorHeader(dec_cls, name, param_dec_cls, param_cls, param_val, features));
            printer.writeOutputStream(DamidaXMLFormat.getInit(DamidaXMLFormat.getType(dec_cls, callee), DamidaXMLFormat.getID(callee)));
            printer.writeOutputStream(DamidaXMLFormat.getConstructorFooter());
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void preMethodIn(String dec_cls, Object callee, String rtn_dec_cls, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getMethodHeader(dec_cls, DamidaXMLFormat.getType(dec_cls, callee), DamidaXMLFormat.getID(callee), rtn_dec_cls, name, param_dec_cls, param_cls, param_val, features));
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void aftMethodIn(String rtn_cls, String rtn_val) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getReturn(rtn_cls, rtn_val));
            printer.writeOutputStream(DamidaXMLFormat.getMethodFooter());
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static void methodCall(String dec_cls, Object callee, String rtn_dec_cls, String rtn_cls, String rtn_val, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        try {
            DamidaFlexiblePrinter<String> printer = DamidaXMLLog.OUT.getPrinter();
            printer.writeOutputStream(DamidaXMLFormat.getMethodHeader(dec_cls, DamidaXMLFormat.getType(dec_cls, callee), DamidaXMLFormat.getID(callee), rtn_dec_cls, name, param_dec_cls, param_cls, param_val, features));
            printer.writeOutputStream(DamidaXMLFormat.getReturn(rtn_cls, rtn_val));
            printer.writeOutputStream(DamidaXMLFormat.getMethodFooter());
        }
        catch (IOException e) {
            System.err.println("! : IOException Error.");
        }
    }

    public static String getAnnotation(String name, String val) {
        return "<Annotation name=\"" + name + ATT_END + ATT_VAL + val + ATT_END + "/>";
    }

    public static String getInit(String cls, String id) {
        return "<Init class=\"" + cls + ATT_END + ATT_ID + id + ATT_END + "/>";
    }

    public static String getReturn(String rtn_cls, String rtn_val) {
        return "<Return return_class=\"" + rtn_cls + ATT_END + ATT_RTN_VAL + rtn_val + ATT_END + "/>";
    }

    public static String getThreadHeader(String id, String name) {
        return "<Thread id=\"" + id + ATT_END + ATT_NAME + name + ATT_END + ">";
    }

    public static String getThreadFooter() {
        return "</Thread>";
    }

    public static String getConstructorHeader(String dec_cls, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        return "<Constructor stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_NAME + name + ATT_END + ATT_PRM_DEC_CLASS + param_dec_cls + ATT_END + ATT_PRM_CLASS + param_cls + ATT_END + ATT_PRM_VAL + param_val + ATT_END + ATT_FEATURES + features + ATT_END + ">";
    }

    public static String getConstructorFooter() {
        return "</Constructor>";
    }

    public static String getMethodHeader(String dec_cls, String callee_cls, String callee_id, String rtn_dec_cls, String name, String param_dec_cls, String param_cls, String param_val, String features) {
        return "<Method stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_CLASS + callee_cls + ATT_END + ATT_ID + callee_id + ATT_END + ATT_NAME + name + ATT_END + ATT_RTN_DEC_CLASS + rtn_dec_cls + ATT_END + ATT_PRM_DEC_CLASS + param_dec_cls + ATT_END + ATT_PRM_CLASS + param_cls + ATT_END + ATT_PRM_VAL + param_val + ATT_END + ATT_FEATURES + features + ATT_END + ">";
    }

    public static String getMethodFooter() {
        return "</Method>";
    }

    public static String getField(String type, String def_dec_cls, Object def, String dec_cls, String cls, String val, String name, String features) {
        return "<Field stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_ACS_TYPE + type + ATT_END + ATT_DEF_DEC_CLASS + def_dec_cls + ATT_END + ATT_DEF_CLASS + DamidaXMLFormat.getType(def_dec_cls, def) + ATT_END + ATT_DEF_ID + DamidaXMLFormat.getID(def) + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_CLASS + cls + ATT_END + ATT_VAL + val + ATT_END + ATT_NAME + name + ATT_END + ATT_FEATURES + features + ATT_END + " />";
    }

    public static String getHandler(String enc_cls, Object enc, String dec_cls, Object handler) {
        return "<Handler stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_ENC_CLASS + enc_cls + ATT_END + ATT_ENC_ID + DamidaXMLFormat.getID(enc) + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_CLASS + DamidaXMLFormat.getType(dec_cls, handler) + ATT_END + ATT_ID + DamidaXMLFormat.getID(handler) + ATT_END + " />";
    }

    public static String getNewExpr(String dec_cls, Object callee, String param_dec_cls, String param_cls, String param_val) {
        return "<NewExpr stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_CLASS + DamidaXMLFormat.getType(dec_cls, callee) + ATT_END + ATT_ID + DamidaXMLFormat.getID(callee) + ATT_END + ATT_PRM_DEC_CLASS + param_dec_cls + ATT_END + ATT_PRM_CLASS + param_cls + ATT_END + ATT_PRM_VAL + param_val + ATT_END + " />";
    }

    public static String getNewArray(String dec_cls, Object array, int dim, String size) {
        return "<NewArray stamp=\"" + DamidaXMLLog.LOG.getTimeStamp() + ATT_END + ATT_DEC_CLASS + dec_cls + ATT_END + ATT_CLASS + DamidaXMLFormat.getType(dec_cls, array) + ATT_END + ATT_ID + DamidaXMLFormat.getID(array) + ATT_END + ATT_DIM + dim + ATT_END + ATT_SIZE + size + ATT_END + " />";
    }

    public static String getType(String dec_cls, Object o) {
        return o == null ? dec_cls : o.getClass().getName();
    }

    public static String getID(Object o) {
        return o == null ? "null" : Integer.toString(System.identityHashCode(o));
    }

    public static String getVal(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return DamidaXMLFormat.toXMLString((String)o);
        }
        return Integer.toString(System.identityHashCode(o));
    }

    public static String toXMLString(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace("'", "&apos;");
        s = s.replace(ATT_END, "&quot;");
        s = s.replace("\n", "\\n");
        s = s.replace(",", "@comma;");
        return s;
    }

    public static String getParameterDeclareClass(CtBehavior c) {
        StringBuilder sb = new StringBuilder(256);
        try {
            CtClass[] cls = c.getParameterTypes();
            int i = 0;
            while (i < cls.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(cls[i].getName());
                ++i;
            }
        }
        catch (NotFoundException e) {
            System.err.println("!  : Parameters of " + c.getLongName() + " can't be logged.");
            return "ERROR";
        }
        return sb.toString();
    }

    public static String getParameterClassString(CtBehavior c) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("\"\"");
        try {
            CtClass[] cls = c.getParameterTypes();
            int i = 0;
            while (i < cls.length) {
                if (i > 0) {
                    sb.append("+\",\"");
                }
                if (cls[i].isPrimitive()) {
                    sb.append("+\"" + cls[i].getName() + ATT_END);
                } else {
                    sb.append("+" + PATH + ".getType(\"" + cls[i].getName() + "\",$args[" + i + "])");
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            System.err.println("!  : Parameters of " + c.getLongName() + " can't be logged.");
            return "\"ERROR\"";
        }
        return sb.toString();
    }

    public static String getParameterValString(CtBehavior c) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("\"\"");
        try {
            CtClass[] cls = c.getParameterTypes();
            int i = 0;
            while (i < cls.length) {
                if (i > 0) {
                    sb.append("+\",\"");
                }
                if (cls[i].isPrimitive()) {
                    sb.append("+$" + (i + 1));
                } else {
                    sb.append("+" + PATH + ".getVal($args[" + i + "])");
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            System.err.println("!  : Parameters of " + c.getLongName() + " can't be logged.");
            return "\"ERROR\"";
        }
        return sb.toString();
    }

    public String getFeatureNames(Object as) {
        if (as instanceof Feature) {
            Feature f = (Feature)as;
            StringBuffer names = new StringBuffer(64);
            int n = 0;
            while (n < f.value().length) {
                if (n > 0) {
                    names.append(",");
                }
                names.append(f.value()[n]);
                ++n;
            }
            return names.toString();
        }
        return "";
    }

    public String getFeaturesNames(CtMember c) {
        try {
            Object[] as = c.getAnnotations();
            if (as.length <= 0) {
                as = c.getDeclaringClass().getAnnotations();
            }
            StringBuffer names = new StringBuffer(256);
            int i = 0;
            while (i < as.length) {
                if (i > 0) {
                    names.append(",");
                }
                names.append(this.getFeatureNames(as[i]));
                ++i;
            }
            return names.toString();
        }
        catch (ClassNotFoundException e) {
            System.err.println("! : Annotation of " + c.getName() + " can't be logged.");
            return null;
        }
    }

    public String getFeatureCode(Object[] as) {
        StringBuffer code = new StringBuffer(256);
        int i = 0;
        while (i < as.length) {
            code.append(String.valueOf(PATH) + ".annotation( \"Feature\", \"" + this.getFeatureNames(as[i]) + "\" );");
            ++i;
        }
        return code.toString();
    }

    @Override
    public String[] getLgConstructorInsertCode(CtConstructor c) {
        StringBuilder[] codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512), new StringBuilder(512)};
        codes[0].append(String.valueOf(PATH) + ".preConstructorIn(\"");
        codes[0].append(c.getDeclaringClass().getName());
        codes[0].append("\",\"");
        codes[0].append(c.getName());
        codes[0].append("\",\"");
        codes[0].append(DamidaXMLFormat.getParameterDeclareClass((CtBehavior)c));
        codes[0].append("\",");
        codes[0].append(DamidaXMLFormat.getParameterClassString((CtBehavior)c));
        codes[0].append(",");
        codes[0].append(DamidaXMLFormat.getParameterValString((CtBehavior)c));
        codes[0].append(",\"");
        codes[0].append(this.getFeaturesNames((CtMember)c));
        codes[0].append("\");");
        codes[1].append(String.valueOf(PATH) + ".midConstructorIn( \"" + c.getDeclaringClass().getName() + "\", $0 );");
        codes[2].append(String.valueOf(PATH) + ".aftConstructorIn();");
        String[] strs = new String[]{codes[0].toString(), codes[1].toString(), codes[2].toString()};
        return strs;
    }

    @Override
    public String[] getLgMethodInsertCode(CtMethod c) {
        StringBuilder[] codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512)};
        codes[0].append(String.valueOf(PATH) + ".preMethodIn(\"");
        codes[0].append(c.getDeclaringClass().getName());
        codes[0].append("\",");
        if (!Modifier.isStatic((int)c.getModifiers())) {
            codes[0].append("$0,\"");
        } else {
            codes[0].append("null,\"");
        }
        try {
            codes[0].append(c.getReturnType().getName());
            codes[0].append("\",\"");
            codes[0].append(c.getName());
            codes[0].append("\",\"");
            codes[0].append(DamidaXMLFormat.getParameterDeclareClass((CtBehavior)c));
            codes[0].append("\",");
            codes[0].append(DamidaXMLFormat.getParameterClassString((CtBehavior)c));
            codes[0].append(",");
            codes[0].append(DamidaXMLFormat.getParameterValString((CtBehavior)c));
            codes[0].append(",\"");
            codes[0].append(this.getFeaturesNames((CtMember)c));
            codes[0].append("\");");
            codes[1].append(String.valueOf(PATH) + ".aftMethodIn( ");
            if (c.getReturnType().isPrimitive()) {
                codes[1].append(ATT_END + c.getReturnType().getName() + "\", ");
                codes[1].append("String.valueOf($_)");
            } else {
                codes[1].append(String.valueOf(PATH) + ".getType(\"" + c.getDeclaringClass().getName() + "\",$_), ");
                codes[1].append(String.valueOf(PATH) + ".getVal($_)");
            }
            codes[1].append(" );");
        }
        catch (NotFoundException e) {
            System.err.println("! : Return val of " + c.getLongName() + " can't be logged.");
        }
        String[] strs = new String[]{codes[0].toString(), codes[1].toString()};
        return strs;
    }

    @Override
    public String getLgConstructorCallCode(ConstructorCall c) {
        CtConstructor m;
        StringBuilder[] codes;
        block3: {
            codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512)};
            try {
                m = c.getConstructor();
                if (!DamidaXMLLog.PER.canLgInConstructor(m)) break block3;
                return null;
            }
            catch (NotFoundException e) {
                System.err.println("!  : " + c.getClassName() + " can't be logged.");
                return null;
            }
        }
        codes[1].append(String.valueOf(PATH) + ".constructorCall(\"");
        codes[1].append(c.getClassName());
        codes[1].append("\",$0,\"");
        codes[1].append(m.getName());
        codes[1].append("\",\"");
        codes[1].append(DamidaXMLFormat.getParameterDeclareClass((CtBehavior)m));
        codes[1].append("\",");
        codes[1].append(DamidaXMLFormat.getParameterClassString((CtBehavior)m));
        codes[1].append(",");
        codes[1].append(DamidaXMLFormat.getParameterValString((CtBehavior)m));
        codes[1].append(",\"");
        codes[1].append(this.getFeaturesNames((CtMember)m));
        codes[1].append("\");");
        return codes[0].append("$_=$proceed($$);").append((CharSequence)codes[1]).toString();
    }

    @Override
    public String getLgMethodCallCode(MethodCall c) {
        CtMethod m;
        StringBuilder[] codes;
        block7: {
            codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512)};
            try {
                m = c.getMethod();
                if (!DamidaXMLLog.PER.canLgInMethod(m)) break block7;
                return null;
            }
            catch (NotFoundException e) {
                System.err.println("!  : " + c.getMethodName() + "() can't be logged.");
                return null;
            }
        }
        codes[1].append(String.valueOf(PATH) + ".methodCall(\"");
        codes[1].append(m.getDeclaringClass().getName());
        codes[1].append("\",");
        if (!Modifier.isStatic((int)m.getModifiers())) {
            codes[1].append("$0,\"");
        } else {
            codes[1].append("null,\"");
        }
        codes[1].append(m.getReturnType().getName());
        codes[1].append("\",");
        if (m.getReturnType().isPrimitive()) {
            codes[1].append(ATT_END + m.getReturnType().getName() + "\", ");
            codes[1].append("String.valueOf($_)");
        } else {
            codes[1].append(String.valueOf(PATH) + ".getType(\"" + m.getDeclaringClass().getName() + "\",$_) , ");
            codes[1].append(String.valueOf(PATH) + ".getVal($_)");
        }
        codes[1].append(",\"");
        codes[1].append(m.getName());
        codes[1].append("\",\"");
        codes[1].append(DamidaXMLFormat.getParameterDeclareClass((CtBehavior)m));
        codes[1].append("\",");
        codes[1].append(DamidaXMLFormat.getParameterClassString((CtBehavior)m));
        codes[1].append(",");
        codes[1].append(DamidaXMLFormat.getParameterValString((CtBehavior)m));
        codes[1].append(",\"");
        codes[1].append(this.getFeaturesNames((CtMember)m));
        codes[1].append("\");");
        return codes[0].append("$_=$proceed($$);").append((CharSequence)codes[1]).toString();
    }

    @Override
    public String getLgFieldAccessCode(FieldAccess c) {
        String val;
        String type;
        if (c.getFieldName().equals("this$0") || c.where().getDeclaringClass().getName().matches("([^\\$]+\\$)+\\d")) {
            return null;
        }
        StringBuilder code = new StringBuilder(512);
        if (c.isReader()) {
            type = "read";
            val = "$_";
        } else {
            type = "write";
            val = "$1";
        }
        code.append(String.valueOf(LOG) + ".addLg(" + PATH + ".getField(\"");
        code.append(type);
        code.append("\",\"");
        try {
            CtField m = c.getField();
            code.append(c.getClassName());
            if (!Modifier.isStatic((int)c.where().getModifiers())) {
                code.append("\",$0,\"");
            } else {
                code.append("\",null,\"");
            }
            code.append(m.getType().getName());
            code.append("\",");
            if (m.getType().isPrimitive()) {
                code.append(ATT_END + m.getType().getName() + "\", ");
                code.append("String.valueOf(" + val + ")");
            } else {
                code.append(String.valueOf(PATH) + ".getType(\"" + m.getType().getName() + "\"," + val + ") , ");
                code.append(String.valueOf(PATH) + ".getVal(" + val + ")");
            }
            code.append(",\"");
            code.append(c.getFieldName());
            code.append("\",\"");
            code.append(this.getFeaturesNames((CtMember)m));
        }
        catch (NotFoundException e) {
            System.err.println("! : " + c.getClassName() + "." + c.getFieldName() + " can't be logged.");
            return null;
        }
        catch (Exception e) {
            System.err.println("? : " + c.getClassName() + "." + c.getFieldName() + " can't be logged.");
            e.printStackTrace();
            return null;
        }
        code.append("\") );");
        return code.insert(0, "$_=$proceed($$);").toString();
    }

    @Override
    public String getLgCastCode(Cast c) {
        return null;
    }

    @Override
    public String getLgInstanceofCode(Instanceof c) {
        return null;
    }

    @Override
    public String getLgHandlerCode(Handler c) {
        StringBuilder[] codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512)};
        codes[1].append(String.valueOf(LOG) + ".addLg(" + PATH + ".getHandler(\"");
        try {
            codes[1].append(c.getEnclosingClass().getName());
            if (!Modifier.isStatic((int)c.where().getModifiers())) {
                codes[1].append("\",this,\"");
            } else {
                codes[1].append("\",null,\"");
            }
            codes[1].append(c.getType().getName());
            codes[1].append("\",$1 ) );");
            c.insertBefore(codes[1].toString());
        }
        catch (NotFoundException e) {
            System.err.println("!  : Handler in " + c.getEnclosingClass().getName() + " can't be logged.");
            return null;
        }
        catch (Exception e) {
            System.err.println("?  : Handler in " + c.getEnclosingClass().getName() + " can't be logged.");
            return null;
        }
        return null;
    }

    @Override
    public String getLgNewArrayCode(NewArray c) {
        StringBuilder[] codes = new StringBuilder[]{new StringBuilder(512), new StringBuilder(512)};
        try {
            codes[1].append(String.valueOf(LOG) + ".addLg(" + PATH + ".getNewArray(\"");
            codes[1].append(c.getComponentType().getName());
            codes[1].append("\",$_,");
            codes[1].append(c.getDimension());
            codes[1].append(",\"\"");
            int i = 1;
            while (i <= c.getDimension()) {
                if (i > 1) {
                    codes[1].append("+\",\"");
                }
                if (i > c.getCreatedDimensions()) {
                    codes[1].append("+0");
                } else {
                    codes[1].append("+$" + i);
                }
                ++i;
            }
            codes[1].append(") );");
        }
        catch (NotFoundException e) {
            System.err.println("!  : NewArray in " + c.getEnclosingClass() + " can't be logged.");
            return null;
        }
        catch (Exception e) {
            System.err.println("?  : NewArray in " + c.getEnclosingClass() + " can't be logged.");
            return null;
        }
        return codes[0].append("$_=$proceed($$);").append((CharSequence)codes[1]).toString();
    }

    @Override
    public String getLgNewExprCode(NewExpr c) {
        CtConstructor m;
        StringBuilder code;
        block4: {
            code = new StringBuilder(512);
            m = c.getConstructor();
            if (!DamidaXMLLog.PER.canLgInConstructor(m)) break block4;
            return null;
        }
        try {
            code.append(String.valueOf(LOG) + ".addLg(" + PATH + ".getNewExpr(\"");
            code.append(c.getClassName());
            code.append("\",$_,\"");
            code.append(DamidaXMLFormat.getParameterDeclareClass((CtBehavior)m));
            code.append("\",");
            code.append(DamidaXMLFormat.getParameterClassString((CtBehavior)m));
            code.append(",");
            code.append(DamidaXMLFormat.getParameterValString((CtBehavior)m));
            code.append(") );");
        }
        catch (NotFoundException e) {
            System.err.println("! : new " + c.getClassName() + "() can't be logged.");
            return null;
        }
        catch (Exception e) {
            System.err.println("? : new " + c.getClassName() + "() can't be logged.");
            e.printStackTrace();
            return null;
        }
        return code.insert(0, "$_=$proceed($$);").toString();
    }
}

