/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CallTreeGroup {
    private Map<Integer, Integer> objectIdMap = new TreeMap<Integer, Integer>();
    private List<CallTree> callTreeList = new ArrayList<CallTree>();
    private Map<Object, Integer> treeIndexMap = new HashMap<Object, Integer>();
    private int callCount = 0;

    protected CallTreeGroup() {
    }

    protected CallTree makeCallTree() {
        CallTree newTree = new CallTree(this);
        this.callTreeList.add(newTree);
        return newTree;
    }

    protected CallTree makeCallTree(Object key) {
        int index = this.callTreeList.size();
        CallTree newTree = this.makeCallTree();
        this.treeIndexMap.put(key, new Integer(index));
        return newTree;
    }

    public CallTree getCallTree(int index) {
        return this.callTreeList.get(index);
    }

    public CallTree getCallTree(Object key) {
        if (!this.treeIndexMap.containsKey(key)) {
            return null;
        }
        return this.getCallTree(this.treeIndexMap.get(key));
    }

    public int getCallTreeIndex(Object o) {
        if (!this.treeIndexMap.containsKey(o)) {
            return -1;
        }
        return this.treeIndexMap.get(o);
    }

    public int getCallTreeIndex(CallTree tree) {
        return this.callTreeList.indexOf(tree);
    }

    protected void removeCallTree(int index) {
        this.callTreeList.remove(index);
        this.declementIndexMap(index);
    }

    protected void removeCallTree(Object o) {
        if (this.treeIndexMap.containsKey(o)) {
            Integer index = this.treeIndexMap.get(o);
            this.callTreeList.remove(index);
            this.treeIndexMap.remove(o);
            this.declementIndexMap(index);
        }
    }

    protected void removeCallTree(CallTree tree) {
        int index = this.callTreeList.indexOf(tree);
        this.callTreeList.remove(tree);
        this.declementIndexMap(index);
    }

    protected void deleteAllCallTree() {
        this.callTreeList.clear();
        this.treeIndexMap.clear();
    }

    protected void declementIndexMap(int borderIndex) {
        Iterator<Map.Entry<Object, Integer>> it = this.treeIndexMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Integer> entry = it.next();
            Object o = entry.getKey();
            int ivalue = entry.getValue();
            if (ivalue == borderIndex) {
                it.remove();
                continue;
            }
            if (ivalue <= borderIndex) continue;
            this.treeIndexMap.put(o, new Integer(ivalue - 1));
        }
    }

    protected void setKey(Object key, int index) {
        this.treeIndexMap.put(key, new Integer(index));
    }

    protected void setKey(Object key, CallTree tree) {
        int index = this.getCallTreeIndex(tree);
        if (index != -1) {
            this.treeIndexMap.put(key, new Integer(index));
        }
    }

    public int getCallTreeNum() {
        return this.callTreeList.size();
    }

    protected void clearAllCallTree() {
        this.callTreeList.clear();
        this.treeIndexMap.clear();
    }

    protected Map<Integer, Integer> getIdMap() {
        return this.objectIdMap;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int getNextCallIndex() {
        return ++this.callCount;
    }

    public int getGroupID(int id) {
        if (this.objectIdMap.containsKey(id)) {
            return this.objectIdMap.get(id);
        }
        Integer groupId = new Integer(this.objectIdMap.size() + 1);
        this.objectIdMap.put(id, groupId);
        return groupId;
    }
}

