/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.calltree.CallNode;
import amida.diagram.sequencediagram.ISequenceElement;
import amida.diagram.sequencediagram.SequenceObject;
import java.util.List;

public class Sequence
implements ISequenceElement {
    public static final int CALL = 0;
    public static final int RETURN = 1;
    public static final int NULL = 2;
    public static final int BLOCK = 3;
    public static final int RETURN_BLOCK = 4;
    public static final int RETURN_EXCEPTION = 5;
    public static final int RETURN_BLOCK_EXCEPTION = 6;
    private SequenceObject start;
    private SequenceObject end;
    private Sequence pare = null;
    private CallNode node;
    private int type;
    private int startLevel;
    private int endLevel;
    private int index;
    private boolean isBranch = false;
    private List<Sequence> indirectCalls = null;
    private static final String BRANCH_MARK = "? ";

    public Sequence(CallNode node, SequenceObject start, SequenceObject end, int direction, int index) {
        this.start = start;
        this.end = end;
        this.node = node;
        this.type = direction;
        if (start != null) {
            this.startLevel = start.getLevel();
        }
        if (end != null) {
            this.endLevel = end.getLevel();
        }
        this.index = index;
    }

    public SequenceObject getStart() {
        return this.start;
    }

    public SequenceObject getEnd() {
        return this.end;
    }

    public int getIndex() {
        return this.index;
    }

    public void setPareSequence(Sequence pare) {
        this.pare = pare;
        pare.pare = this;
    }

    public Sequence getPareSequence() {
        return this.pare;
    }

    public int getStartIndex() {
        if (this.getStart() == null) {
            return 0;
        }
        return this.getStart().getIndex();
    }

    public int getEndIndex() {
        if (this.getEnd() == null) {
            return 0;
        }
        return this.getEnd().getIndex();
    }

    public CallNode getNode() {
        return this.node;
    }

    public int getType() {
        return this.type;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getEndLevel() {
        return this.endLevel;
    }

    public void setBranch(boolean bool) {
        this.isBranch = bool;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public void setRecursive(boolean bool) {
    }

    public void setIndirectSequence(List<Sequence> indirect) {
        this.indirectCalls = indirect;
    }

    public boolean isIndirect() {
        return this.indirectCalls != null && this.indirectCalls.size() > 0;
    }

    public String getCallLabel() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.valueOf(this.getNode().getCallIndex()) + ": " + this.getNode().getMethodName() + "(");
        String[] args = this.getNode().getSimpleArgmentTypeNames();
        if (args != null) {
            int j = 0;
            while (j < args.length) {
                buffer.append(String.valueOf(args[j]) + ",");
                ++j;
            }
            if (j > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
        }
        buffer.append(")");
        if (this.isBranch()) {
            buffer.insert(0, BRANCH_MARK);
        }
        return buffer.toString();
    }
}

