/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.LanguageType;
import amida.logloader.EntryType;
import amida.logloader.LogEntry;
import amida.logloader.LogFile;
import amida.logloader.LogParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Queue;

public class BinaryLogFile
extends LogFile {
    private final int unitSize;
    private BufferedInputStream iStream = null;

    public BinaryLogFile(File logFile, LanguageType language, int unitSize, LogParser parser, boolean preLoad) {
        super(logFile, language, parser, preLoad);
        this.unitSize = unitSize;
        try {
            this.iStream = new BufferedInputStream(new FileInputStream(logFile));
            if (preLoad) {
                Object o;
                int count = 0;
                while ((o = this.read()) != null) {
                    LogEntry entry;
                    Queue<LogEntry> queue = parser.parse(o);
                    while ((entry = queue.poll()) != null) {
                        if (entry.getEntryType() == EntryType.METHOD_CALL) {
                            ++count;
                        }
                        if (entry.getEntryType() == EntryType.UNKNOWN) continue;
                        this.addEntry(entry);
                    }
                }
                this.setMethodCallCount(count);
            }
        }
        catch (FileNotFoundException e) {
            this.iStream = null;
        }
    }

    @Override
    protected Object read() {
        byte[] buffer = new byte[this.unitSize];
        try {
            int size = this.iStream.read(buffer);
            if (size != this.unitSize) {
                this.iStream.close();
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        return buffer;
    }

    @Override
    public boolean hasLogSource() {
        return this.iStream != null;
    }
}

