/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.logloader.LogEntry;
import amida.logloader.LogParser;
import amida.logloader.MethodCallEntry;
import amida.logloader.MethodExitByThrowExceptionEntry;
import amida.logloader.MethodExitEntry;
import amida.logloader.ThreadStartEntry;
import amida.logloader.UnknownEntry;
import amida.staticdata.StaticDataAccessor;
import amida.staticdata.Type;
import amida.staticdata.java.JavaStaticDataAccessor;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.JavaTypeManager;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class TDLLogParser
implements LogParser {
    private String lastThrowedException = null;
    private Map<Integer, String> objectClassMap = new TreeMap<Integer, String>();
    private final Queue<LogEntry> entries = new LinkedList<LogEntry>();

    @Override
    public Queue<LogEntry> parse(Object o) {
        int threadIndex;
        if (!(o instanceof String)) {
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        String line = (String)o;
        StringTokenizer st = new StringTokenizer(line, " #()=");
        if (!st.hasMoreTokens()) {
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        String token = st.nextToken();
        if (token.equals("@thread")) {
            if (st.hasMoreTokens()) {
                try {
                    token = st.nextToken();
                    int index = Integer.parseInt(token);
                    StringBuffer buffer = new StringBuffer();
                    boolean inThreadName = false;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        if (token.startsWith("\"")) {
                            inThreadName = true;
                            token = token.substring(1);
                        }
                        if (!inThreadName) continue;
                        buffer.append(String.valueOf(token) + ' ');
                        if (token.charAt(token.length() - 1) == '\"') break;
                    }
                    if (buffer.length() == 0) {
                        this.entries.offer(UnknownEntry.getInstance());
                        return this.entries;
                    }
                    this.entries.offer(new ThreadStartEntry(buffer.substring(0, buffer.length() - 1), index));
                    return this.entries;
                }
                catch (NumberFormatException e) {
                    this.entries.offer(UnknownEntry.getInstance());
                    return this.entries;
                }
            }
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        if (token.equals("@object")) {
            int id;
            if (!st.hasMoreTokens()) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            token = st.nextToken();
            if (!token.startsWith("0x")) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            try {
                id = Integer.parseInt(token.substring(2, token.length() - 2), 16);
            }
            catch (NumberFormatException e) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            if (!st.hasMoreTokens()) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            token = st.nextToken();
            String className = this.translateJniType(token);
            this.objectClassMap.put(id, className);
            return null;
        }
        try {
            threadIndex = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        if (!st.hasMoreTokens()) {
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        token = st.nextToken();
        if (token.equals("}")) {
            if (st.hasMoreTokens() && (token = st.nextToken()).equals("e") && this.lastThrowedException != null) {
                this.entries.offer(new MethodExitByThrowExceptionEntry(threadIndex, this.translateJniType(this.lastThrowedException)));
                return this.entries;
            }
            this.entries.offer(new MethodExitEntry(threadIndex));
            return this.entries;
        }
        if (token.equals("throw")) {
            if (st.hasMoreTokens()) {
                this.lastThrowedException = st.nextToken();
            }
            return null;
        }
        if (token.equals("catch")) {
            return null;
        }
        if (token.equals("static")) {
            if (!st.hasMoreTokens()) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            Object[] methodData = this.getMethodData(st);
            JavaStaticDataAccessor accessor = JavaStaticDataAccessor.getInstance();
            Type[] argTypes = new JavaType[((String[])methodData[3]).length];
            int i = 0;
            while (i < argTypes.length) {
                argTypes[i] = JavaTypeManager.getType(((String[])methodData[3])[i]);
                ++i;
            }
            this.entries.offer(new MethodCallEntry(threadIndex, ((StaticDataAccessor)accessor).makeMethodData(((StaticDataAccessor)accessor).makeClassData((String)methodData[0]), (String)methodData[2], JavaTypeManager.getType((String)methodData[1]), argTypes, true, JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED)), 0));
            return this.entries;
        }
        if (token.startsWith("0x")) {
            try {
                Integer.parseInt(token.substring(2, token.length() - 2), 16);
            }
            catch (NumberFormatException e) {
                this.entries.offer(UnknownEntry.getInstance());
                return this.entries;
            }
            Object[] methodData = this.getMethodData(st);
            JavaStaticDataAccessor accessor = JavaStaticDataAccessor.getInstance();
            Type[] argTypes = new JavaType[((String[])methodData[3]).length];
            int i = 0;
            while (i < argTypes.length) {
                argTypes[i] = JavaTypeManager.getType(((String[])methodData[3])[i]);
                ++i;
            }
            this.entries.offer(new MethodCallEntry(threadIndex, ((StaticDataAccessor)accessor).makeMethodData(((StaticDataAccessor)accessor).makeClassData((String)methodData[0]), (String)methodData[2], JavaTypeManager.getType((String)methodData[1]), argTypes, false, JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED)), 0));
            return this.entries;
        }
        this.entries.offer(UnknownEntry.getInstance());
        return this.entries;
    }

    private Object[] getMethodData(StringTokenizer st) {
        String[] args;
        if (!st.hasMoreTokens()) {
            return null;
        }
        String className = this.translateJniType(st.nextToken());
        if (!st.hasMoreTokens()) {
            return null;
        }
        String methodName = st.nextToken();
        String returnType = null;
        if (!st.hasMoreTokens()) {
            return null;
        }
        String argsText = null;
        String temp = st.nextToken();
        if (st.hasMoreTokens()) {
            argsText = temp;
            returnType = this.translateJniType(st.nextToken());
            StringTokenizer st2 = new StringTokenizer(argsText, ",");
            int num = st2.countTokens();
            args = new String[num];
            int i = 0;
            while (i < num) {
                args[i] = st2.nextToken();
                ++i;
            }
        } else {
            args = new String[]{};
            returnType = this.translateJniType(temp);
        }
        return new Object[]{className, returnType, methodName, args};
    }

    /*
     * Unable to fully structure code
     */
    private String translateJniType(String text) {
        buffer = new StringBuffer();
        arrayCount = 0;
        i = 0;
        ** GOTO lbl63
        {
            ++arrayCount;
            ++i;
            do {
                if (i < text.length() && text.charAt(i) == '[') continue block12;
                if (i < text.length()) {
                    c = text.charAt(i);
                    switch (c) {
                        case 'V': {
                            buffer.append("void");
                            break;
                        }
                        case 'I': {
                            buffer.append("int");
                            break;
                        }
                        case 'Z': {
                            buffer.append("boolean");
                            break;
                        }
                        case 'J': {
                            buffer.append("long");
                            break;
                        }
                        case 'S': {
                            buffer.append("short");
                            break;
                        }
                        case 'B': {
                            buffer.append("byte");
                            break;
                        }
                        case 'D': {
                            buffer.append("double");
                            break;
                        }
                        case 'F': {
                            buffer.append("float");
                            break;
                        }
                        case 'C': {
                            buffer.append("char");
                            break;
                        }
                        case 'L': {
                            end = text.indexOf(59, i);
                            subString = text.substring(i + 1, end);
                            buffer.append(subString.replace('/', '.'));
                            i = end;
                        }
                    }
                    ++i;
                }
                j = 0;
                while (j < arrayCount) {
                    buffer.append("[]");
                    ++j;
                }
                buffer.append(",");
lbl63:
                // 2 sources

            } while (i < text.length());
        }
        return buffer.substring(0, buffer.length() - 1).toString();
    }
}

