/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.logloader.LogFile;
import amida.profiler.Profiler;
import amida.profiler.ProfilerException;
import amida.utility.PromptManager;
import amida.utility.ThreadEndListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class ProfileThread
extends Thread {
    private List<ThreadEndListener> endListeners = new LinkedList<ThreadEndListener>();
    private PromptManager prompt;
    private File profiler;
    private File logDirectory;
    private File newCurrentDirectory;
    private String command;
    private List<String> profilerInit;
    private List<LogFile> logFiles;
    private boolean logComperssed;
    private boolean recordThreadId;

    public ProfileThread(File profiler, File logDirectory, String command, List<String> profilerInit, boolean compressLog, boolean recordThreadID, File newCurrentDirectory, PromptManager prompt) {
        this.profiler = profiler;
        this.logDirectory = logDirectory;
        this.command = command;
        this.profilerInit = profilerInit;
        this.newCurrentDirectory = newCurrentDirectory;
        this.prompt = prompt;
        this.logComperssed = compressLog;
    }

    public void addEndListener(ThreadEndListener listener) {
        this.endListeners.add(listener);
    }

    private void threadEnd() {
        for (ThreadEndListener listener : this.endListeners) {
            listener.threadEnd(this);
        }
    }

    public List<LogFile> getLogfiles() {
        return this.logFiles;
    }

    @Override
    public void run() {
        try {
            this.logFiles = Profiler.profile(this.profiler, this.logDirectory, this.command, this.profilerInit, this.logComperssed, this.recordThreadId, this.newCurrentDirectory, this.prompt);
        }
        catch (ProfilerException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Profile Error", 0);
        }
        this.threadEnd();
    }
}

