/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.LanguageType;
import amida.logloader.BinaryLogFile;
import amida.logloader.DefaultBinaryLogParser;
import amida.logloader.DefaultLogParser;
import amida.logloader.LogFile;
import amida.logloader.TextLogFile;
import amida.profiler.ProfilerException;
import amida.profiler.ProfilerPrompt;
import amida.utility.PromptManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Profiler {
    public static final String COMMAND_TOP = "java -Djava.compiler=NONE -Xdebug -agentpath:";
    public static final String JAR_OPTION = "-jar";
    public static final String MAX_HEAP_SIZE_OPTION = "-Xmx";
    public static final String JAR_EXTENSION = "jar";
    public static final String DEFAULT_PROFILER_NAME = "amidaprof.dll";
    public static final String DEFAULT_CURRENT = String.valueOf(new File(".").getAbsoluteFile().getParentFile().getAbsolutePath()) + "\\";
    private static final String LOG_FILE_EXTENSION = "log";
    private static final String INDEX_FILE_EXTENSION = "dat";
    public static final String DEFAULT_LOG_DIRECTORY = String.valueOf(DEFAULT_CURRENT) + "log\\";

    public static List<LogFile> profile(File profiler, File logDirectory, String command, List<String> init, boolean compressLog, boolean recordThreadID, File newCurrent, PromptManager prompt) throws ProfilerException {
        File prevCurrent = new File(".").getAbsoluteFile().getParentFile();
        File newProfiler = null;
        if (!profiler.getParentFile().equals(newCurrent)) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                if (!prevCurrent.equals(newCurrent)) {
                    try {
                        Runtime.getRuntime().exec("cmd /c cd " + newCurrent.getAbsolutePath());
                    }
                    catch (IOException e) {
                        throw new ProfilerException("Can not move current directory.");
                    }
                }
                try {
                    String copyCommand = "cmd /c copy " + profiler.getAbsolutePath() + " " + newCurrent.getAbsolutePath();
                    Process process = Runtime.getRuntime().exec(copyCommand);
                    process.waitFor();
                    newProfiler = new File(String.valueOf(newCurrent.getAbsolutePath()) + "\\profiler.dll");
                }
                catch (IOException e) {
                    throw new ProfilerException("Can not copy profiler.dll to " + newCurrent.getAbsolutePath());
                }
                catch (InterruptedException e) {
                    throw new ProfilerException("Can not copy profiler.dll to " + newCurrent.getAbsolutePath());
                }
            }
            throw new ProfilerException("Can not use this function on " + os + ".");
        }
        File iniFile = new File(String.valueOf(newCurrent.getAbsolutePath()) + "\\" + "profiler.ini");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(iniFile));
            String lineSeparator = System.getProperty("line.separator");
            Iterator<String> it = init.iterator();
            while (it.hasNext()) {
                bw.write(String.valueOf(it.next()) + lineSeparator);
            }
            bw.close();
        }
        catch (IOException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not make profiler.ini at " + newCurrent.getAbsolutePath());
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (prompt != null) {
                prompt.setStdOut(process.getInputStream());
                prompt.setStdErr(process.getErrorStream());
                ((ProfilerPrompt)prompt).start();
            }
            process.waitFor();
            if (newProfiler != null) {
                if (newProfiler.exists()) {
                    newProfiler.delete();
                }
                if (iniFile.exists()) {
                    iniFile.delete();
                }
            }
        }
        catch (InterruptedException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not execution \"" + command + "\".");
        }
        catch (IOException e) {
            if (newProfiler != null && newProfiler.exists()) {
                newProfiler.delete();
            }
            throw new ProfilerException("Can not execution \"" + command + "\".");
        }
        File[] directories = logDirectory.listFiles();
        File currentLogDirectory = null;
        long max = 0L;
        int i = 0;
        while (i < directories.length) {
            if (directories[i].lastModified() > max) {
                currentLogDirectory = directories[i];
                max = directories[i].lastModified();
            }
            ++i;
        }
        File[] files = currentLogDirectory.listFiles();
        ArrayList<File> logFiles = new ArrayList<File>();
        File indexFile = null;
        int i2 = 0;
        while (i2 < files.length) {
            String fileName = files[i2].getName();
            int index = fileName.lastIndexOf(46);
            if (index >= 0 && index + 1 < fileName.length()) {
                String extension = fileName.substring(index + 1, fileName.length());
                if (extension.equals(LOG_FILE_EXTENSION)) {
                    logFiles.add(files[i2]);
                } else if (extension.equals(INDEX_FILE_EXTENSION)) {
                    indexFile = files[i2];
                }
            }
            ++i2;
        }
        ArrayList<LogFile> newLogFiles = new ArrayList<LogFile>();
        if (logFiles.isEmpty()) {
            throw new ProfilerException("Log file not found.");
        }
        if (compressLog && indexFile != null) {
            DefaultBinaryLogParser parser = new DefaultBinaryLogParser(indexFile, LanguageType.JAVA);
            int i3 = 0;
            while (i3 < logFiles.size()) {
                newLogFiles.add(new BinaryLogFile((File)logFiles.get(i3), LanguageType.JAVA, parser.getPrefferedUnitSize(), parser, true));
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < logFiles.size()) {
                newLogFiles.add(new TextLogFile((File)logFiles.get(i4), LanguageType.JAVA, "\n", new DefaultLogParser(LanguageType.JAVA), true, -1, -1, null));
                ++i4;
            }
        }
        return newLogFiles;
    }
}

