/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.LanguageType;
import amida.calltree.CallTreeGroup;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceObject;
import amida.logcompactor.CompactorThread;
import amida.logcompactor.LoopCompactorThread;
import amida.logcompactor.RecursiveCallCompactorThread;
import amida.logcompactor.foldrule.MethodMissingLoopRule;
import amida.logcompactor.foldrule.ObjectDifferenceLoopRule;
import amida.logcompactor.foldrule.SimpleLoopRule;
import amida.logloader.DefaultLogParser;
import amida.logloader.LogLoader;
import amida.logloader.TextLogFile;
import amida.logmanager.AmidaProperty;
import amida.logmanager.LogFileName;
import amida.node.comparator.NodeTreeComparator;
import amida.utility.ProgressListener;
import amida.utility.SelectionChangeListener;
import amida.viewer.ModelChangeListener;
import amida.viewer.OverviewCanvasMouseHandler;
import amida.viewer.SearchDialog;
import amida.viewer.SearchListener;
import amida.viewer.SequenceDiagramDrawer;
import amida.viewer.SequenceDiagramModel;
import amida.viewer.SequenceObjectSorter;
import amida.viewer.ViewUpdater;
import amida.viewer.filter.FilterChangeListener;
import amida.viewer.filter.FilterDialog;
import amida.viewer.filter.FilterManager;
import amida.viewer.filter.FilterSet;
import amida.viewer.filter.ObjectFilter;
import java.io.File;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class ViewerWindow {
    private static final String KEY_DIAGRAM_VIEW = "AMIDA_SEQUENCE_DIAGRAM_VIEW";
    private static final String LABEL_STATUS_OK = "Open a log file from [File]-[Open a log file].";
    private static final String[] LIBRARY_FILTER = new String[]{"java.*", "javax.*", "sun.*"};
    private Shell shell;
    private SearchDialog searchDialog;
    private CTabFolder tabFolder;
    private CTabItem defaultTab;
    private ProgressBar progress;
    private FilterManager filterManager;
    private Label statusLabel;
    private TextSearch search;

    public static void main(String[] args) {
        Display display = new Display();
        ViewerWindow window = new ViewerWindow(display);
        window.shell.open();
        while (!window.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void open(Shell parent, LogFileName file) {
        ViewerWindow window = new ViewerWindow(parent.getDisplay());
        window.shell.open();
        if (file != null) {
            window.loadFile(file.getFileObject(), file.getPhaseBegin(), file.getPhaseEnd(), file.getThreadDeclFile());
        }
    }

    private ViewerWindow(Display display) {
        this.shell = new Shell(display);
        this.constructWindow();
    }

    private ViewerWindow(Shell parent) {
        this.shell = new Shell(parent, 66672);
        this.constructWindow();
    }

    public void constructWindow() {
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.filterManager = new FilterManager();
        this.setupDefaultGlobalFilters();
        this.constructTabs((Composite)this.shell);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite statusbar = new Composite((Composite)this.shell, 0);
        statusbar.setLayoutData((Object)new GridData(4, 4, true, false));
        statusbar.setLayout((Layout)new GridLayout(2, false));
        this.statusLabel = new Label(statusbar, 0);
        this.statusLabel.setText(LABEL_STATUS_OK);
        this.statusLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.progress = new ProgressBar(statusbar, 0);
        this.progress.setLayoutData((Object)new GridData(4, 4, true, false));
        this.progress.setVisible(false);
        this.search = new TextSearch();
        this.searchDialog = new SearchDialog(this.shell);
        this.searchDialog.setSearchListener(this.search);
        this.tabFolder.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000C) {
                    ViewerWindow.this.searchDialog.search((e.stateMask & 0x20000) == 0);
                }
            }
        });
        this.constructMenu();
        this.shell.setText("Amida Viewer");
        this.shell.pack();
        this.shell.setSize(640, 400);
    }

    private void constructMenu() {
        Menu menubar = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menubar);
        MenuItem mnuFile = new MenuItem(menubar, 64);
        mnuFile.setText("File(&F)");
        Menu menu1 = new Menu(mnuFile);
        mnuFile.setMenu(menu1);
        MenuItem mnuFileOpen = new MenuItem(menu1, 8);
        mnuFileOpen.setText("Open a log file (&O) ...\tCTRL+O");
        mnuFileOpen.setAccelerator(262223);
        new MenuItem(menu1, 2);
        MenuItem mnuQuit = new MenuItem(menu1, 8);
        mnuQuit.setText("Quit (&X)");
        mnuFileOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean isFirst = true;

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(ViewerWindow.this.shell, 4096);
                if (this.isFirst) {
                    dialog.setFilterPath(AmidaProperty.getInstance().getLogDir());
                    this.isFirst = false;
                }
                dialog.setFilterExtensions(new String[]{"*.log", "*.*"});
                String s = dialog.open();
                if (s != null) {
                    File f = new File(s);
                    ViewerWindow.this.loadFile(f, -1L, -1L, null);
                }
            }
        });
        mnuQuit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.shell.close();
            }
        });
        MenuItem toolMenu = new MenuItem(menubar, 64);
        toolMenu.setText("Tool(&T)");
        Menu toolChildrenMenu = new Menu(toolMenu);
        toolMenu.setMenu(toolChildrenMenu);
        MenuItem mnuFindDialog = new MenuItem(toolChildrenMenu, 8);
        mnuFindDialog.setText("Search ... \tCTRL+F");
        mnuFindDialog.setAccelerator(262214);
        mnuFindDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.searchDialog.open();
            }
        });
        MenuItem mnuFilterDialog = new MenuItem(toolChildrenMenu, 8);
        mnuFilterDialog.setText("Filters ...\tCTRL+E");
        mnuFilterDialog.setAccelerator(262213);
        mnuFilterDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDialog.open(ViewerWindow.this.shell, ViewerWindow.this.filterManager, new FilterChangeListener(){

                    @Override
                    public void changed() {
                        ViewerWindow.this.updateAllTabs();
                    }
                });
            }
        });
        MenuItem conpactionMenu = new MenuItem(toolChildrenMenu, 64);
        conpactionMenu.setText("Compaction");
        Menu menu2 = new Menu(conpactionMenu);
        conpactionMenu.setMenu(menu2);
        MenuItem mnuSimpleLoop = new MenuItem(menu2, 8);
        mnuSimpleLoop.setText("Simple Loop Detection");
        MenuItem mnuObjectLoop = new MenuItem(menu2, 8);
        mnuObjectLoop.setText("Object difference loop");
        MenuItem mnuMissingLoop = new MenuItem(menu2, 8);
        mnuMissingLoop.setText("Method missing loop");
        MenuItem mnuRecursiveLoop = new MenuItem(menu2, 8);
        mnuRecursiveLoop.setText("Recursive call detection");
        mnuSimpleLoop.addSelectionListener((SelectionListener)new CompactionProcess(1));
        mnuObjectLoop.addSelectionListener((SelectionListener)new CompactionProcess(2));
        mnuMissingLoop.addSelectionListener((SelectionListener)new CompactionProcess(3));
        mnuRecursiveLoop.addSelectionListener((SelectionListener)new CompactionProcess(4));
        MenuItem mnuSort = new MenuItem(toolChildrenMenu, 64);
        mnuSort.setText("Sort Objects");
        Menu mnuSortChildren = new Menu(mnuSort);
        mnuSort.setMenu(mnuSortChildren);
        MenuItem mnuSortNatural = new MenuItem(mnuSortChildren, 8);
        mnuSortNatural.setText("Timestamp");
        mnuSortNatural.addSelectionListener((SelectionListener)new ObjectSorter(0));
        MenuItem mnuSortID = new MenuItem(mnuSortChildren, 64);
        mnuSortID.setText("Object ID");
        mnuSortID.addSelectionListener((SelectionListener)new ObjectSorter(1));
        MenuItem mnuSortPackage = new MenuItem(mnuSortChildren, 64);
        mnuSortPackage.setText("Package Name");
        mnuSortPackage.addSelectionListener((SelectionListener)new ObjectSorter(2));
        MenuItem mnuSortClass = new MenuItem(mnuSortChildren, 64);
        mnuSortClass.setText("Class Name");
        mnuSortClass.addSelectionListener((SelectionListener)new ObjectSorter(3));
    }

    private void updateAllTabs() {
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem tab = this.tabFolder.getItem(i);
            SequenceDiagramModel model = ((SequenceDiagramView)tab.getData(KEY_DIAGRAM_VIEW)).getModel();
            if (model != null) {
                model.renew();
            }
            ++i;
        }
        this.tabFolder.redraw();
    }

    private void constructTabs(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 64);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerWindow.this.updateStatusLabel();
            }
        });
        this.defaultTab = this.createTab(this.tabFolder, "(Default)", null);
    }

    private CTabItem createTab(CTabFolder folder, final String caption, final SequenceDiagramModel model) {
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText(caption);
        SashForm overviewSplitter = new SashForm((Composite)folder, 256);
        tab.setControl((Control)overviewSplitter);
        SashForm objectSplitter = new SashForm((Composite)overviewSplitter, 512);
        final Composite objectComposite = new Composite((Composite)objectSplitter, 262144);
        objectComposite.setBackground(this.shell.getDisplay().getSystemColor(25));
        Composite overviewScrollCanvas = new Composite((Composite)overviewSplitter, 0);
        overviewScrollCanvas.setLayout((Layout)new GridLayout(2, false));
        final Composite overviewComposite = new Composite(overviewScrollCanvas, 262144);
        overviewComposite.setBackground(this.shell.getDisplay().getSystemColor(25));
        overviewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Slider vOverviewSlider = new Slider(overviewScrollCanvas, 512);
        vOverviewSlider.setLayoutData((Object)new GridData(4, 4, false, true));
        final Slider hOverviewSlider = new Slider(overviewScrollCanvas, 256);
        hOverviewSlider.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite diagramScrollCanvas = new Composite((Composite)objectSplitter, 0);
        diagramScrollCanvas.setLayout((Layout)new GridLayout(2, false));
        final Composite diagramComposite = new Composite(diagramScrollCanvas, 262144);
        diagramComposite.setBackground(this.shell.getDisplay().getSystemColor(25));
        diagramComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Slider vDiagramSlider = new Slider(diagramScrollCanvas, 512);
        vDiagramSlider.setLayoutData((Object)new GridData(4, 4, false, true));
        final Slider hDiagramSlider = new Slider(diagramScrollCanvas, 256);
        hDiagramSlider.setLayoutData((Object)new GridData(4, 4, true, false));
        final ViewUpdater updater = new ViewUpdater(new Composite[]{diagramComposite, objectComposite, overviewComposite});
        final SequenceDiagramDrawer drawer = new SequenceDiagramDrawer(model, updater);
        SelectionAdapter scrollUpdater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                updater.fireRedraw();
            }
        };
        hDiagramSlider.addSelectionListener((SelectionListener)scrollUpdater);
        vDiagramSlider.addSelectionListener((SelectionListener)scrollUpdater);
        hOverviewSlider.addSelectionListener((SelectionListener)scrollUpdater);
        vOverviewSlider.addSelectionListener((SelectionListener)scrollUpdater);
        diagramComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = diagramComposite.getSize().x;
                int h = diagramComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle region = new Rectangle(0, 0, w, h);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), vDiagramSlider.getSelection(), w, h);
                drawer.drawDiagram(e.display, bufferedGC, view, region);
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        objectComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = objectComposite.getSize().x;
                int h = objectComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), 0, w, h);
                drawer.drawTopObject(e.display, bufferedGC, view, vDiagramSlider.getSelection());
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        overviewComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = overviewComposite.getSize().x;
                int h = overviewComposite.getSize().y;
                Image bufferedImage = new Image((Device)e.display, w, h);
                GC bufferedGC = new GC((Drawable)bufferedImage);
                Rectangle overviewView = new Rectangle(hOverviewSlider.getSelection(), vOverviewSlider.getSelection(), w, h);
                Rectangle view = new Rectangle(hDiagramSlider.getSelection(), vDiagramSlider.getSelection(), diagramComposite.getSize().x, diagramComposite.getSize().y);
                drawer.drawSequenceOverview(e.display, bufferedGC, overviewView, view);
                e.gc.drawImage(bufferedImage, 0, 0);
                bufferedImage.dispose();
            }
        });
        OverviewCanvasMouseHandler handler = new OverviewCanvasMouseHandler(hDiagramSlider, vDiagramSlider, overviewComposite, hOverviewSlider, vOverviewSlider, drawer, updater);
        overviewComposite.addMouseListener((MouseListener)handler);
        overviewComposite.addMouseMoveListener((MouseMoveListener)handler);
        Point size = drawer.computeOverviewSize();
        hOverviewSlider.setMaximum(size.x);
        vOverviewSlider.setMaximum(size.y);
        Point diagramSize = drawer.computeDiagramSize();
        hDiagramSlider.setMaximum(diagramSize.x);
        vDiagramSlider.setMaximum(diagramSize.y);
        tab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (model != null) {
                    ViewerWindow.this.filterManager.disposeFilter(model.getFilters());
                    ViewerWindow.this.updateStatusLabel();
                    model.dispose();
                }
            }
        });
        tab.setData(KEY_DIAGRAM_VIEW, (Object)new SequenceDiagramView(model, drawer, diagramComposite, hDiagramSlider, vDiagramSlider));
        overviewSplitter.setWeights(new int[]{9, 1});
        objectSplitter.setWeights(new int[]{1, 6});
        if (model != null) {
            Menu popup = new Menu((Decorations)this.shell, 0);
            diagramComposite.setMenu(popup);
            MenuItem mnuExtractDiagram = new MenuItem(popup, 8);
            mnuExtractDiagram.setText("Extract a diagram");
            mnuExtractDiagram.addSelectionListener((SelectionListener)new SelectionAdapter(){

                private String makeCaption(int idx) {
                    return String.valueOf(caption) + "-" + Integer.toString(idx);
                }

                public void widgetSelected(SelectionEvent e) {
                    int idx = 1;
                    while (true) {
                        boolean found = false;
                        int i = 0;
                        while (i < ViewerWindow.this.tabFolder.getItemCount()) {
                            CTabItem t = ViewerWindow.this.tabFolder.getItem(i);
                            found = found || t.getText().equals(this.makeCaption(idx));
                            ++i;
                        }
                        if (!found) break;
                        ++idx;
                    }
                    SequenceDiagramModel newModel = drawer.extractSelectedModel();
                    if (newModel != null) {
                        ViewerWindow.this.openNewDiagram(newModel, this.makeCaption(idx));
                    }
                }
            });
            diagramComposite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    drawer.selectElement(e.x, e.y, e.button);
                }

                public void mouseDoubleClick(MouseEvent e) {
                    drawer.processDoubleClick(e.x, e.y, e.button);
                }
            });
            Menu objectPopup = new Menu((Decorations)this.shell, 0);
            objectComposite.setMenu(objectPopup);
            MenuItem mnuObjectHide = new MenuItem(objectPopup, 8);
            MenuItem mnuObjectDelete = new MenuItem(objectPopup, 8);
            mnuObjectHide.setText("Hide selected objects");
            mnuObjectDelete.setText("Delete selected objects");
            mnuObjectHide.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    drawer.createObjectHideFilter();
                }
            });
            mnuObjectDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    drawer.createObjectDeleteFilter();
                }
            });
            objectComposite.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    drawer.selectObject(e.x + hDiagramSlider.getSelection(), e.y, objectComposite.getClientArea().height, vDiagramSlider.getSelection(), diagramComposite.getClientArea().height, (e.stateMask & 0x20000) != 0, (e.stateMask & 0x40000) != 0, e.button == 3);
                }
            });
            drawer.getSelectionModel().addSelectionListener(new SelectionChangeListener(){

                @Override
                public void selectionChanged() {
                    updater.fireRedraw();
                }
            });
            model.addModelChangeListener(new ModelChangeListener(){

                @Override
                public void changing(SequenceDiagramModel model) {
                }

                @Override
                public void changed(SequenceDiagramModel model) {
                    if (!ViewerWindow.this.shell.isDisposed()) {
                        ViewerWindow.this.shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Point diagramSize = drawer.computeDiagramSize();
                                hDiagramSlider.setMaximum(diagramSize.x);
                                vDiagramSlider.setMaximum(diagramSize.y);
                                updater.fireRedraw();
                                Point size = drawer.computeOverviewSize();
                                hOverviewSlider.setMaximum(size.x);
                                vOverviewSlider.setMaximum(size.y);
                            }
                        });
                    }
                }
            });
        }
        return tab;
    }

    private void openNewDiagram(SequenceDiagramModel model, String name) {
        this.filterManager.registerFilterSet(model.getFilters(), name);
        CTabItem newTab = this.createTab(this.tabFolder, name, model);
        this.tabFolder.setSelection(newTab);
        if (this.defaultTab != null) {
            this.defaultTab.dispose();
            this.defaultTab = null;
        }
        this.updateStatusLabel();
    }

    private SequenceDiagramView getActiveView() {
        if (this.tabFolder.isDisposed()) {
            return null;
        }
        CTabItem tab = this.tabFolder.getSelection();
        if (tab == null) {
            return null;
        }
        if (tab.isDisposed()) {
            return null;
        }
        return (SequenceDiagramView)tab.getData(KEY_DIAGRAM_VIEW);
    }

    private SequenceDiagramModel getActiveModel() {
        SequenceDiagramView view = this.getActiveView();
        if (view == null) {
            return null;
        }
        return view.getModel();
    }

    private void updateStatusLabel() {
        SequenceDiagramModel model = this.getActiveModel();
        if (model != null) {
            this.statusLabel.setText(model.getFileName());
            this.statusLabel.getParent().layout();
        } else if (!this.statusLabel.isDisposed()) {
            this.statusLabel.setText(LABEL_STATUS_OK);
            this.statusLabel.getParent().layout();
        }
    }

    private void loadFile(File f, long start, long end, File externalLog) {
        DefaultLogParser parser = new DefaultLogParser(LanguageType.JAVA);
        TextLogFile textLogFile = new TextLogFile(f, LanguageType.JAVA, "\n", parser, false, (int)start, (int)end, externalLog);
        CallTreeGroup group = LogLoader.load(textLogFile);
        int i = 0;
        while (i < group.getCallTreeNum()) {
            FilterSet filters = new FilterSet();
            SequenceDiagramModel model = new SequenceDiagramModel(f.getAbsolutePath(), group.getCallTree(i), filters);
            this.openNewDiagram(model, group.getCallTree(i).getName());
            ++i;
        }
    }

    private void setupDefaultGlobalFilters() {
        int i = 0;
        while (i < LIBRARY_FILTER.length) {
            ObjectFilter f = new ObjectFilter();
            f.setPackageCondition(LIBRARY_FILTER[i]);
            f.setTypeIndex(1);
            this.filterManager.getGlobalFilterSet(0).addObjectFilter(f);
            ++i;
        }
    }

    private class CompactionProcess
    extends SelectionAdapter {
        private int ruleNumber;

        public CompactionProcess(int ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public void widgetSelected(SelectionEvent e) {
            CompactorThread thread;
            SequenceDiagramModel model = ViewerWindow.this.getActiveModel();
            if (model == null) {
                return;
            }
            NodeTreeComparator.compareNotEndedNode = true;
            switch (this.ruleNumber) {
                case 1: {
                    thread = new LoopCompactorThread(new SimpleLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                    break;
                }
                case 2: {
                    thread = new LoopCompactorThread(new ObjectDifferenceLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                    break;
                }
                case 3: {
                    thread = new LoopCompactorThread(new MethodMissingLoopRule(5), model.getCallTree(), model.getTargetNode(), model.getTargetNodeList());
                    break;
                }
                case 4: {
                    thread = new RecursiveCallCompactorThread(model.getCallTree());
                    break;
                }
                default: {
                    return;
                }
            }
            thread.addProgressListener(new ProgressListener(){

                @Override
                public void progress(final int value, final int max) {
                    if (!ViewerWindow.this.shell.isDisposed()) {
                        Display display = ViewerWindow.this.shell.getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!ViewerWindow.this.progress.getVisible()) {
                                    ViewerWindow.this.progress.getParent().layout();
                                    ViewerWindow.this.progress.setVisible(true);
                                }
                                ViewerWindow.this.progress.setMaximum(max);
                                ViewerWindow.this.progress.setSelection(value);
                                if (max == value) {
                                    ViewerWindow.this.progress.setVisible(false);
                                }
                            }
                        });
                    }
                }
            });
            thread.start();
        }
    }

    private class ObjectSorter
    extends SelectionAdapter {
        private int kind;

        public ObjectSorter(int kind) {
            this.kind = kind;
        }

        public void widgetSelected(SelectionEvent e) {
            SequenceDiagramModel model = ViewerWindow.this.getActiveModel();
            if (model != null) {
                model.setSorter(SequenceObjectSorter.getSorter(this.kind));
            }
        }
    }

    private class SequenceDiagramView {
        private SequenceDiagramModel model;
        private SequenceDiagramDrawer drawer;
        private Composite diagramComposite;
        private Slider horizontal;
        private Slider vertical;

        public SequenceDiagramView(SequenceDiagramModel model, SequenceDiagramDrawer drawer, Composite diagramComposite, Slider horizontal, Slider vertical) {
            this.model = model;
            this.drawer = drawer;
            this.diagramComposite = diagramComposite;
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public SequenceDiagramModel getModel() {
            return this.model;
        }

        private void showObject(int objIndex) {
            int x = this.drawer.getObjectPosition(objIndex);
            if ((x -= this.diagramComposite.getSize().x / 2) < 0) {
                x = 0;
            }
            this.horizontal.setSelection(x);
        }

        public void selectAndShowObject(int objIndex) {
            this.showObject(objIndex);
            this.drawer.selectObjectByIndex(objIndex);
        }

        public void selectAndShowSequence(int seqIndex) {
            Sequence seq = this.model.getSequence(seqIndex);
            this.showObject(seq.getEndIndex());
            int y = this.drawer.getSequenceY(seqIndex);
            if ((y -= this.diagramComposite.getSize().y / 2) < 0) {
                y = 0;
            }
            this.vertical.setSelection(y);
            if (seq.getType() == 1 || seq.getType() == 5) {
                seqIndex = seq.getPareSequence().getIndex();
            }
            this.drawer.selectSequenceByIndex(seqIndex);
        }
    }

    private class TextSearch
    implements SearchListener {
        private int objectPos;
        private int sequencePos;
        private static final int OBJECT_POS_NOSELECT = Integer.MIN_VALUE;

        public TextSearch() {
            this.reset();
        }

        public void reset() {
            this.objectPos = Integer.MIN_VALUE;
            this.sequencePos = Integer.MIN_VALUE;
        }

        @Override
        public void searchObject(String searchString, boolean useRegex, boolean forward) {
            SequenceDiagramModel model = ViewerWindow.this.getActiveModel();
            if (model == null) {
                return;
            }
            if (forward) {
                this.objectPos = this.objectPos < 0 ? 0 : ++this.objectPos;
                int i = this.objectPos;
                while (i < model.getObjectNum()) {
                    SequenceObject obj = model.getObject(i);
                    if (this.matchObject(obj, searchString, useRegex)) {
                        ViewerWindow.this.getActiveView().selectAndShowObject(obj.getIndex());
                        this.objectPos = i;
                        break;
                    }
                    ++i;
                }
            } else {
                this.objectPos = this.objectPos == Integer.MIN_VALUE || this.objectPos > model.getObjectNum() ? model.getObjectNum() - 1 : --this.objectPos;
                int i = this.objectPos;
                while (i >= 0) {
                    SequenceObject obj = model.getObject(i);
                    if (this.matchObject(obj, searchString, useRegex)) {
                        ViewerWindow.this.getActiveView().selectAndShowObject(obj.getIndex());
                        this.objectPos = i;
                        break;
                    }
                    --i;
                }
            }
        }

        private void searchSequence(String searchString, boolean useRegex, boolean call, boolean forward) {
            SequenceDiagramModel model = ViewerWindow.this.getActiveModel();
            if (model == null) {
                return;
            }
            if (forward) {
                this.sequencePos = this.sequencePos < 0 ? 0 : ++this.sequencePos;
                int i = this.sequencePos;
                while (i < model.getSequenceNum()) {
                    Sequence seq = model.getSequence(i);
                    if (this.matchSequence(seq, searchString, useRegex, call)) {
                        ViewerWindow.this.getActiveView().selectAndShowSequence(seq.getIndex());
                        this.sequencePos = i;
                        break;
                    }
                    ++i;
                }
            } else {
                this.sequencePos = this.sequencePos == Integer.MIN_VALUE || this.sequencePos > model.getSequenceNum() ? model.getSequenceNum() - 1 : --this.sequencePos;
                int i = this.sequencePos;
                while (i >= 0) {
                    Sequence seq = model.getSequence(i);
                    if (this.matchSequence(seq, searchString, useRegex, call)) {
                        ViewerWindow.this.getActiveView().selectAndShowSequence(seq.getIndex());
                        this.sequencePos = i;
                        break;
                    }
                    --i;
                }
            }
        }

        @Override
        public void searchCall(String searchString, boolean useRegex, boolean forward) {
            this.searchSequence(searchString, useRegex, true, forward);
        }

        @Override
        public void searchReturn(String searchString, boolean useRegex, boolean forward) {
            this.searchSequence(searchString, useRegex, false, forward);
        }

        private boolean matchObject(SequenceObject obj, String searchString, boolean useRegex) {
            if (useRegex) {
                return obj.getNameSpace().matches(searchString) || obj.getClassName().matches(searchString);
            }
            return obj.getNameSpace().indexOf(searchString) >= 0 || obj.getClassName().indexOf(searchString) >= 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean matchSequence(Sequence seq, String searchString, boolean useRegex, boolean call) {
            String s;
            if (call) {
                if (seq.getType() != 0) return false;
                s = seq.getCallLabel();
                return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
            } else if (seq.getType() == 1) {
                s = seq.getNode().getReturnTypeName();
                return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
            } else {
                if (seq.getType() != 5) return false;
                s = seq.getNode().getExceptionName();
            }
            return s != null && !useRegex && s.indexOf(searchString) >= 0 || useRegex && s.matches(searchString);
        }
    }
}

