/*
 * Decompiled with CFR 0.152.
 */
package amida.library;

import amida.library.ProgressListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog
implements ProgressListener {
    private final JProgressBar progressBar = new JProgressBar();
    private final Component owner;
    private final JLabel percentage;

    public ProgressDialog(JFrame owner) {
        super(owner, "Progress", true);
        this.setValue(0);
        this.owner = owner;
        Container cp = this.getContentPane();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder(0));
        panel.setLayout(new GridLayout(2, 1));
        this.percentage = new JLabel("0%");
        this.percentage.setHorizontalAlignment(0);
        panel.add(this.percentage);
        panel.add(this.progressBar);
        cp.add(panel);
        this.setSize(200, 50);
        this.setResizable(false);
        this.setUndecorated(true);
    }

    public void setMaximum(int i) {
        this.progressBar.setMaximum(i);
    }

    public void setMinimun(int i) {
        this.progressBar.setMinimum(i);
    }

    public void setValue(int i) {
        this.progressBar.setValue(i);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.owner);
        }
        super.setVisible(b);
    }

    public void progress(int value, int max) {
        this.setMaximum(max);
        this.setValue(value);
        this.percentage.setText(String.valueOf(value * 100 / max) + "%");
        this.percentage.repaint();
        this.progressBar.repaint();
        if (value >= max) {
            this.setVisible(false);
        }
    }
}

